/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product;

import com.bc.ceres.core.ProgressMonitor;
import com.vividsolutions.jts.geom.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.table.DefaultTableModel;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.ProductNodeListenerAdapter;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.ArrayUtils;
import org.esa.snap.core.util.math.MathUtils;
import org.opengis.referencing.operation.TransformException;

public abstract class AbstractPlacemarkTableModel
extends DefaultTableModel {
    private final PlacemarkDescriptor placemarkDescriptor;
    private Product product;
    private Band[] selectedBands;
    private TiePointGrid[] selectedGrids;
    private final PlacemarkListener placemarkListener;
    private final ArrayList<Placemark> placemarkList = new ArrayList(10);

    protected AbstractPlacemarkTableModel(PlacemarkDescriptor placemarkDescriptor, Product product, Band[] selectedBands, TiePointGrid[] selectedGrids) {
        this.placemarkDescriptor = placemarkDescriptor;
        this.product = product;
        this.initSelectedBands(selectedBands);
        this.initSelectedGrids(selectedGrids);
        this.placemarkListener = new PlacemarkListener();
        if (product != null) {
            product.addProductNodeListener((ProductNodeListener)this.placemarkListener);
        }
        this.initPlacemarkList(product);
    }

    public Placemark[] getPlacemarks() {
        return this.placemarkList.toArray(new Placemark[this.placemarkList.size()]);
    }

    public Placemark getPlacemarkAt(int modelRow) {
        return this.placemarkList.get(modelRow);
    }

    public PlacemarkDescriptor getPlacemarkDescriptor() {
        return this.placemarkDescriptor;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        if (this.product == product) {
            return;
        }
        if (this.product != null) {
            this.product.removeProductNodeListener((ProductNodeListener)this.placemarkListener);
        }
        this.product = product;
        if (this.product != null) {
            this.product.addProductNodeListener((ProductNodeListener)this.placemarkListener);
        }
        this.placemarkList.clear();
        this.initPlacemarkList(this.product);
        this.selectedBands = new Band[0];
        this.selectedGrids = new TiePointGrid[0];
        this.fireTableStructureChanged();
    }

    public Band[] getSelectedBands() {
        return this.selectedBands;
    }

    public void setSelectedBands(Band[] selectedBands) {
        this.selectedBands = selectedBands != null ? selectedBands : new Band[]{};
        this.fireTableStructureChanged();
    }

    public TiePointGrid[] getSelectedGrids() {
        return this.selectedGrids;
    }

    public void setSelectedGrids(TiePointGrid[] selectedGrids) {
        this.selectedGrids = selectedGrids != null ? selectedGrids : new TiePointGrid[]{};
        this.fireTableStructureChanged();
    }

    public boolean addPlacemark(Placemark placemark) {
        if (this.placemarkList.add(placemark)) {
            int insertedRowIndex = this.placemarkList.indexOf(placemark);
            this.fireTableRowsInserted(insertedRowIndex, insertedRowIndex);
            return true;
        }
        return false;
    }

    public boolean removePlacemark(Placemark placemark) {
        int index = this.placemarkList.indexOf(placemark);
        if (index != -1) {
            this.placemarkList.remove(placemark);
            this.fireTableRowsDeleted(index, index);
            return true;
        }
        return false;
    }

    public void removePlacemarkAt(int index) {
        if (this.placemarkList.size() > index) {
            Placemark placemark = this.placemarkList.get(index);
            this.removePlacemark(placemark);
        }
    }

    public abstract String[] getStandardColumnNames();

    public String[] getAdditionalColumnNames() {
        String[] standardColumnNames = this.getStandardColumnNames();
        int columnCount = this.getColumnCount();
        int columnCountMin = standardColumnNames.length;
        String[] additionalColumnNames = new String[columnCount - columnCountMin];
        for (int i = 0; i < additionalColumnNames.length; ++i) {
            additionalColumnNames[i] = this.getColumnName(columnCountMin + i);
        }
        return additionalColumnNames;
    }

    @Override
    public abstract boolean isCellEditable(int var1, int var2);

    protected abstract Object getStandardColumnValueAt(int var1, int var2);

    @Override
    public int getRowCount() {
        if (this.placemarkList == null) {
            return 0;
        }
        return this.placemarkList.size();
    }

    @Override
    public int getColumnCount() {
        int count = this.getStandardColumnNames().length;
        if (this.selectedBands != null) {
            count += this.selectedBands.length;
        }
        if (this.selectedGrids != null) {
            count += this.selectedGrids.length;
        }
        return count;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex < this.getStandardColumnNames().length) {
            return this.getStandardColumnNames()[columnIndex];
        }
        int newIndex = columnIndex - this.getStandardColumnNames().length;
        if (newIndex < this.getNumSelectedBands()) {
            return this.selectedBands[newIndex].getName();
        }
        if (this.selectedGrids != null && (newIndex -= this.getNumSelectedBands()) < this.selectedGrids.length) {
            return this.selectedGrids[newIndex].getName();
        }
        return "?";
    }

    public int getColumnIndex(String columnName) {
        int elementIndex;
        Object[] standardColumnNames = this.getStandardColumnNames();
        int index = Arrays.binarySearch(standardColumnNames, columnName);
        if (index < 0 && (elementIndex = ArrayUtils.getElementIndex((Object)columnName, (Object[])this.getAdditionalColumnNames())) >= 0) {
            index = standardColumnNames.length + elementIndex;
        }
        return index;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.getStandardColumnNames().length - 1) {
            return Double.class;
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex < this.getStandardColumnNames().length) {
            return this.getStandardColumnValueAt(rowIndex, columnIndex);
        }
        return this.getAdditionalValue(rowIndex, columnIndex);
    }

    private Object getAdditionalValue(int rowIndex, int columnIndex) {
        Placemark placemark = this.placemarkList.get(rowIndex);
        int index = columnIndex - this.getStandardColumnNames().length;
        Object defaultGeometry = placemark.getFeature().getDefaultGeometry();
        if (!(defaultGeometry instanceof Point)) {
            throw new IllegalStateException("A placemark must have a point feature");
        }
        Point point = (Point)defaultGeometry;
        Point2D.Double sceneCoords = new Point2D.Double(point.getX(), point.getY());
        if (index < this.getNumSelectedBands()) {
            AffineTransform modelToImageTransform;
            Point2D modelCoords;
            Band band = this.selectedBands[index];
            try {
                modelCoords = band.getSceneToModelTransform().transform((Point2D)sceneCoords, (Point2D)new Point2D.Double());
                modelToImageTransform = band.getImageToModelTransform().createInverse();
            }
            catch (NoninvertibleTransformException | TransformException e) {
                return "Indeterminate";
            }
            PixelPos rasterPos = (PixelPos)modelToImageTransform.transform(modelCoords, (Point2D)new PixelPos());
            int x = MathUtils.floorInt((double)rasterPos.getX());
            int y = MathUtils.floorInt((double)rasterPos.getY());
            int width = band.getRasterWidth();
            int height = band.getRasterHeight();
            if (x < 0 || x >= width || y < 0 || y >= height) {
                return "No-data";
            }
            if (band.isPixelValid(x, y)) {
                try {
                    float[] value = null;
                    value = band.readPixels(x, y, 1, 1, value, ProgressMonitor.NULL);
                    return Float.valueOf(value[0]);
                }
                catch (IOException ignored) {
                    return "I/O-error";
                }
            }
            return "NaN";
        }
        if ((index -= this.getNumSelectedBands()) < this.selectedGrids.length) {
            AffineTransform modelToImageTransform;
            Point2D modelCoords;
            TiePointGrid grid = this.selectedGrids[index];
            try {
                modelCoords = grid.getSceneToModelTransform().transform((Point2D)sceneCoords, (Point2D)new Point2D.Double());
                modelToImageTransform = grid.getImageToModelTransform().createInverse();
            }
            catch (NoninvertibleTransformException | TransformException e) {
                return "Indeterminate";
            }
            PixelPos rasterPos = (PixelPos)modelToImageTransform.transform(modelCoords, (Point2D)new PixelPos());
            int x = MathUtils.floorInt((double)rasterPos.getX());
            int y = MathUtils.floorInt((double)rasterPos.getY());
            int width = grid.getRasterWidth();
            int height = grid.getRasterHeight();
            if (x < 0 || x >= width || y < 0 || y >= height) {
                return "No-data";
            }
            try {
                float[] value = null;
                value = grid.readPixels(x, y, 1, 1, value, ProgressMonitor.NULL);
                return Float.valueOf(value[0]);
            }
            catch (IOException ignored) {
                return "I/O-error";
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (value == null) {
            return;
        }
        if (columnIndex < this.getStandardColumnNames().length) {
            Placemark placemark = this.placemarkList.get(rowIndex);
            if (columnIndex == 0) {
                this.setPixelPosX(value, placemark);
            } else if (columnIndex == 1) {
                this.setPixelPosY(value, placemark);
            } else if (columnIndex == 2) {
                this.setGeoPosLon(value, placemark);
            } else if (columnIndex == 3) {
                this.setGeoPosLat(value, placemark);
            } else if (columnIndex == this.getStandardColumnNames().length - 1) {
                String strValue = value.toString();
                placemark.setLabel(strValue);
            } else {
                throw new IllegalStateException("Column[" + columnIndex + "] '" + this.getColumnName(columnIndex) + "' is not editable");
            }
        }
    }

    public void dispose() {
        if (this.product != null) {
            this.product.removeProductNodeListener((ProductNodeListener)this.placemarkListener);
        }
        this.selectedBands = null;
        this.selectedGrids = null;
        this.placemarkList.clear();
    }

    protected void setGeoPosLat(Object lat, Placemark placemark) {
        double lon = placemark.getGeoPos() == null ? Double.NaN : placemark.getGeoPos().lon;
        placemark.setGeoPos(new GeoPos(((Double)lat).doubleValue(), lon));
    }

    protected void setGeoPosLon(Object lon, Placemark placemark) {
        double lat = placemark.getGeoPos() == null ? Double.NaN : placemark.getGeoPos().lat;
        placemark.setGeoPos(new GeoPos(lat, ((Double)lon).doubleValue()));
    }

    protected void setPixelPosY(Object value, Placemark placemark) {
        double pixelX = placemark.getPixelPos() == null ? -1.0 : placemark.getPixelPos().x;
        placemark.setPixelPos(new PixelPos(pixelX, ((Double)value).doubleValue()));
    }

    protected void setPixelPosX(Object value, Placemark placemark) {
        double pixelY = placemark.getPixelPos() == null ? -1.0 : placemark.getPixelPos().y;
        placemark.setPixelPos(new PixelPos(((Double)value).doubleValue(), pixelY));
    }

    private void initSelectedBands(Band[] selectedBands) {
        this.selectedBands = selectedBands != null ? selectedBands : new Band[]{};
    }

    private void initSelectedGrids(TiePointGrid[] selectedGrids) {
        this.selectedGrids = selectedGrids != null ? selectedGrids : new TiePointGrid[]{};
    }

    private void initPlacemarkList(Product product) {
        if (product != null) {
            Placemark[] placemarks = (Placemark[])this.placemarkDescriptor.getPlacemarkGroup(product).toArray((ProductNode[])new Placemark[0]);
            this.placemarkList.addAll(Arrays.asList(placemarks));
        }
    }

    private int getNumSelectedBands() {
        return this.selectedBands != null ? this.selectedBands.length : 0;
    }

    private class PlacemarkListener
    extends ProductNodeListenerAdapter {
        private PlacemarkListener() {
        }

        public void nodeChanged(ProductNodeEvent event) {
            this.fireTableDataChanged(event);
        }

        public void nodeDataChanged(ProductNodeEvent event) {
            if (event.getSourceNode() instanceof Band) {
                Band sourceBand = (Band)event.getSourceNode();
                if (AbstractPlacemarkTableModel.this.selectedBands != null) {
                    for (Band band : AbstractPlacemarkTableModel.this.selectedBands) {
                        if (band != sourceBand) continue;
                        AbstractPlacemarkTableModel.this.fireTableDataChanged();
                        return;
                    }
                }
            }
            if (event.getSourceNode() instanceof TiePointGrid) {
                TiePointGrid sourceTPG = (TiePointGrid)event.getSourceNode();
                if (AbstractPlacemarkTableModel.this.selectedGrids != null) {
                    for (Band band : AbstractPlacemarkTableModel.this.selectedGrids) {
                        if (band != sourceTPG) continue;
                        AbstractPlacemarkTableModel.this.fireTableDataChanged();
                        return;
                    }
                }
            }
        }

        private void fireTableDataChanged(ProductNodeEvent event) {
            if (event.getSourceNode() instanceof Placemark) {
                Placemark placemark = (Placemark)event.getSourceNode();
                int index = AbstractPlacemarkTableModel.this.placemarkList.indexOf(placemark);
                if (index != -1) {
                    AbstractPlacemarkTableModel.this.fireTableRowsUpdated(index, index);
                }
            }
        }
    }
}

