/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.diagram;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.esa.snap.core.util.ObjectUtils;
import org.esa.snap.ui.diagram.Diagram;
import org.esa.snap.ui.diagram.DiagramChangeListener;
import org.esa.snap.ui.diagram.DiagramGraph;

public class DiagramCanvas
extends JPanel {
    private Diagram diagram;
    private String messageText;
    private Insets insets;
    private DiagramGraph selectedGraph;
    private Point dragPoint;
    private DiagramChangeHandler diagramChangeHandler;

    public DiagramCanvas() {
        this.setName("diagram");
        this.diagramChangeHandler = new DiagramChangeHandler();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (DiagramCanvas.this.diagram != null) {
                    DiagramCanvas.this.diagram.invalidate();
                }
            }
        });
        IndicatorHandler mouseHandler = new IndicatorHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.setPreferredSize(new Dimension(320, 200));
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public void setDiagram(Diagram diagram) {
        Diagram oldDiagram = this.diagram;
        if (oldDiagram != diagram) {
            if (oldDiagram != null) {
                oldDiagram.removeChangeListener(this.diagramChangeHandler);
            }
            this.diagram = diagram;
            if (this.diagram != null) {
                diagram.addChangeListener(this.diagramChangeHandler);
            }
            this.firePropertyChange("diagram", oldDiagram, diagram);
            this.repaint();
        }
    }

    public String getMessageText() {
        return this.messageText;
    }

    public void setMessageText(String messageText) {
        String oldValue = this.messageText;
        if (!ObjectUtils.equalObjects((Object)oldValue, (Object)messageText)) {
            this.messageText = messageText;
            this.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.insets = this.getInsets(this.insets);
        int width = this.getWidth() - (this.insets.left + this.insets.right);
        int height = this.getHeight() - (this.insets.top + this.insets.bottom);
        int x0 = this.insets.left;
        int y0 = this.insets.top;
        if (this.diagram != null) {
            this.diagram.render(g2d, x0, y0, width, height);
            if (this.dragPoint != null && this.selectedGraph != null) {
                this.drawValueIndicator(g2d);
            }
        }
        if (this.messageText != null) {
            this.drawTextBox(g2d, this.messageText, x0 + width / 2, y0 + height / 2, new Color(255, 192, 102));
        }
    }

    private void drawValueIndicator(Graphics2D g2d) {
        Diagram.RectTransform transform = this.diagram.getTransform();
        Point2D a = transform.transformB2A(this.dragPoint, null);
        double x = a.getX();
        if (x < this.selectedGraph.getXMin()) {
            x = this.selectedGraph.getXMin();
        }
        if (x > this.selectedGraph.getXMax()) {
            x = this.selectedGraph.getXMax();
        }
        Stroke oldStroke = g2d.getStroke();
        Color oldColor = g2d.getColor();
        double y = this.getY(this.selectedGraph, x);
        Point2D b = transform.transformA2B(new Point2D.Double(x, y), null);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.setColor(this.diagram.getForegroundColor());
        Ellipse2D.Double marker = new Ellipse2D.Double(b.getX() - 4.0, b.getY() - 4.0, 8.0, 8.0);
        g2d.draw(marker);
        g2d.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{6.0f, 6.0f}, 12.0f));
        g2d.setColor(this.diagram.getForegroundColor());
        Rectangle graphArea = this.diagram.getGraphArea();
        g2d.draw(new Line2D.Double(b.getX(), graphArea.y + graphArea.height, b.getX(), b.getY()));
        g2d.draw(new Line2D.Double(graphArea.x, b.getY(), b.getX(), b.getY()));
        DecimalFormat decimalFormat = new DecimalFormat("0.#####E0");
        String text = this.selectedGraph.getYName() + ": x = " + decimalFormat.format(x) + ", y = " + decimalFormat.format(y);
        g2d.setStroke(oldStroke);
        g2d.setColor(oldColor);
        this.drawTextBox(g2d, text, graphArea.x + 6, graphArea.y + 6 + 16, new Color(255, 255, 255, 128));
    }

    private void drawTextBox(Graphics2D g2D, String text, int x0, int y0, Color color) {
        FontMetrics fontMetrics = g2D.getFontMetrics();
        Rectangle2D textBounds = fontMetrics.getStringBounds(text, g2D);
        x0 = (int)((double)x0 - textBounds.getWidth() / 2.0);
        textBounds.setRect(textBounds.getX() - 1.0, textBounds.getY(), textBounds.getWidth(), textBounds.getHeight());
        Rectangle2D.Double r = new Rectangle2D.Double((double)x0 + textBounds.getX() - 2.0, (double)y0 + textBounds.getY() - 2.0, textBounds.getWidth() + 4.0, textBounds.getHeight() + 4.0);
        if (r.getMaxX() > (double)this.getWidth()) {
            r.setRect((double)this.getWidth() - r.getWidth(), r.getY(), r.getWidth(), r.getHeight());
        }
        if (r.getMinX() < 0.0) {
            r.setRect(0.0, r.getY(), r.getWidth(), r.getHeight());
        }
        if (r.getMaxY() > (double)this.getHeight()) {
            r.setRect(r.getX(), (double)this.getHeight() - r.getHeight(), r.getWidth(), r.getHeight());
        }
        if (r.getMinY() < 0.0) {
            r.setRect(r.getX(), 0.0, r.getWidth(), r.getHeight());
        }
        g2D.setColor(color);
        g2D.fill(r);
        g2D.setColor(Color.black);
        g2D.draw(r);
        g2D.drawString(text, x0, y0);
    }

    public double getY(DiagramGraph graph, double x) {
        int n = graph.getNumValues();
        double x2 = 0.0;
        double y2 = 0.0;
        for (int i = 0; i < n; ++i) {
            double x1 = x2;
            double y1 = y2;
            x2 = graph.getXValueAt(i);
            y2 = graph.getYValueAt(i);
            if (i <= 0 || !(x >= x1) || !(x <= x2)) continue;
            return y1 + (x - x1) / (x2 - x1) * (y2 - y1);
        }
        throw new IllegalArgumentException("x out of bounds: " + x);
    }

    private class DiagramChangeHandler
    implements DiagramChangeListener {
        private DiagramChangeHandler() {
        }

        @Override
        public void diagramChanged(Diagram diagram) {
            DiagramCanvas.this.repaint();
        }
    }

    private class IndicatorHandler
    extends MouseInputAdapter {
        private IndicatorHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (DiagramCanvas.this.getDiagram() == null) {
                return;
            }
            if (DiagramCanvas.this.selectedGraph == null) {
                DiagramCanvas.this.selectedGraph = DiagramCanvas.this.getDiagram().getClosestGraph(e.getX(), e.getY());
            }
            if (DiagramCanvas.this.selectedGraph != null) {
                DiagramCanvas.this.dragPoint = e.getPoint();
            } else {
                DiagramCanvas.this.dragPoint = null;
            }
            DiagramCanvas.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            DiagramCanvas.this.selectedGraph = null;
            DiagramCanvas.this.dragPoint = null;
            DiagramCanvas.this.repaint();
        }
    }
}

