/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.diagram;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.ObjectUtils;
import org.esa.snap.core.util.math.Range;
import org.esa.snap.ui.diagram.DiagramAxis;
import org.esa.snap.ui.diagram.DiagramChangeListener;
import org.esa.snap.ui.diagram.DiagramGraph;

public class Diagram {
    public static final String DEFAULT_FONT_NAME = "Verdana";
    public static final int DEFAULT_FONT_SIZE = 9;
    public static final Color DEFAULT_FOREGROUND_COLOR = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND_COLOR = new Color(210, 210, 255);
    private List<DiagramGraph> graphs = new ArrayList<DiagramGraph>(3);
    private DiagramAxis xAxis;
    private DiagramAxis yAxis;
    private boolean drawGrid = true;
    private Font font = new Font("Verdana", 0, 9);
    private int textGap = 3;
    private Color textColor;
    private int majorTickLength = 5;
    private int minorTickLength = 3;
    private Color majorGridColor;
    private Color minorGridColor;
    private Color foregroundColor = DEFAULT_FOREGROUND_COLOR;
    private Color backgroundColor = DEFAULT_BACKGROUND_COLOR;
    private ArrayList<DiagramChangeListener> changeListeners;
    private int numMergedChangeEvents;
    private boolean valid;
    private double xMinAccum;
    private double xMaxAccum;
    private double yMinAccum;
    private double yMaxAccum;
    private FontMetrics fontMetrics;
    private Rectangle graphArea;
    private String[] yTickTexts;
    private String[] xTickTexts;
    private int maxYTickTextWidth;
    private RectTransform transform;

    public Diagram() {
        this.minorGridColor = DEFAULT_BACKGROUND_COLOR.brighter();
        this.majorGridColor = DEFAULT_BACKGROUND_COLOR.darker();
        this.textColor = DEFAULT_FOREGROUND_COLOR;
        this.changeListeners = new ArrayList(3);
        this.disableChangeEventMerging();
        this.resetMinMaxAccumulators();
    }

    public Diagram(DiagramAxis xAxis, DiagramAxis yAxis, DiagramGraph graph) {
        this();
        this.setXAxis(xAxis);
        this.setYAxis(yAxis);
        this.addGraph(graph);
        this.resetMinMaxAccumulatorsFromAxes();
    }

    public void enableChangeEventMerging() {
        this.numMergedChangeEvents = 0;
    }

    public void disableChangeEventMerging() {
        boolean changeEventsMerged = this.numMergedChangeEvents > 0;
        this.numMergedChangeEvents = -1;
        if (changeEventsMerged) {
            this.invalidate();
        }
    }

    public RectTransform getTransform() {
        return this.transform;
    }

    public boolean getDrawGrid() {
        return this.drawGrid;
    }

    public void setDrawGrid(boolean drawGrid) {
        if (this.drawGrid != drawGrid) {
            this.drawGrid = drawGrid;
            this.invalidate();
        }
    }

    public DiagramAxis getXAxis() {
        return this.xAxis;
    }

    public void setXAxis(DiagramAxis xAxis) {
        Guardian.assertNotNull((String)"xAxis", (Object)xAxis);
        if (this.xAxis != xAxis) {
            if (this.xAxis != null) {
                this.xAxis.setDiagram(null);
            }
            this.xAxis = xAxis;
            this.xAxis.setDiagram(this);
            this.invalidate();
        }
    }

    public DiagramAxis getYAxis() {
        return this.yAxis;
    }

    public void setYAxis(DiagramAxis yAxis) {
        Guardian.assertNotNull((String)"yAxis", (Object)yAxis);
        if (this.yAxis != yAxis) {
            if (this.yAxis != null) {
                this.yAxis.setDiagram(null);
            }
            this.yAxis = yAxis;
            this.yAxis.setDiagram(this);
            this.invalidate();
        }
    }

    public DiagramGraph[] getGraphs() {
        return this.graphs.toArray(new DiagramGraph[0]);
    }

    public int getGraphCount() {
        return this.graphs.size();
    }

    public DiagramGraph getGraph(int index) {
        return this.graphs.get(index);
    }

    public void addGraph(DiagramGraph graph) {
        Guardian.assertNotNull((String)"graph", (Object)graph);
        if (this.graphs.add(graph)) {
            graph.setDiagram(this);
            this.invalidate();
        }
    }

    public void removeGraph(DiagramGraph graph) {
        Guardian.assertNotNull((String)"graph", (Object)graph);
        if (this.graphs.remove(graph)) {
            graph.setDiagram(null);
            this.invalidate();
        }
    }

    public void removeAllGraphs() {
        if (this.getGraphCount() > 0) {
            for (DiagramGraph graph : this.graphs) {
                graph.setDiagram(null);
            }
            this.graphs.clear();
            this.invalidate();
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (!ObjectUtils.equalObjects((Object)this.font, (Object)font)) {
            this.font = font;
            this.invalidate();
        }
    }

    public Color getMajorGridColor() {
        return this.majorGridColor;
    }

    public void setMajorGridColor(Color majorGridColor) {
        if (!ObjectUtils.equalObjects((Object)this.majorGridColor, (Object)majorGridColor)) {
            this.majorGridColor = majorGridColor;
            this.invalidate();
        }
    }

    public Color getMinorGridColor() {
        return this.minorGridColor;
    }

    public void setMinorGridColor(Color minorGridColor) {
        if (!ObjectUtils.equalObjects((Object)this.minorGridColor, (Object)minorGridColor)) {
            this.minorGridColor = minorGridColor;
            this.invalidate();
        }
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color foregroundColor) {
        if (!ObjectUtils.equalObjects((Object)this.foregroundColor, (Object)foregroundColor)) {
            this.foregroundColor = foregroundColor;
            this.invalidate();
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        if (!ObjectUtils.equalObjects((Object)this.backgroundColor, (Object)backgroundColor)) {
            this.backgroundColor = backgroundColor;
            this.invalidate();
        }
    }

    public int getTextGap() {
        return this.textGap;
    }

    public void setTextGap(int textGap) {
        if (!ObjectUtils.equalObjects((Object)this.font, (Object)this.font)) {
            this.textGap = textGap;
            this.invalidate();
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void invalidate() {
        this.setValid(false);
        this.fireDiagramChanged();
    }

    public Rectangle getGraphArea() {
        return new Rectangle(this.graphArea);
    }

    public void render(Graphics2D g2d, int x, int y, int width, int height) {
        Font oldFont = g2d.getFont();
        g2d.setFont(this.font);
        if (!this.isValid()) {
            this.validate(g2d, x, y, width, height);
        }
        if (this.isValid()) {
            this.drawAxes(g2d, x, y, width, height);
            this.drawGraphs(g2d);
        }
        g2d.setFont(oldFont);
    }

    private void validate(Graphics2D g2d, int x, int y, int width, int height) {
        this.fontMetrics = g2d.getFontMetrics();
        this.xTickTexts = this.xAxis.createTickmarkTexts();
        this.yTickTexts = this.yAxis.createTickmarkTexts();
        int fontAscent = this.fontMetrics.getAscent();
        this.maxYTickTextWidth = 0;
        for (String yTickText : this.yTickTexts) {
            int sw = this.fontMetrics.stringWidth(yTickText);
            this.maxYTickTextWidth = Math.max(this.maxYTickTextWidth, sw);
        }
        int widthMaxX = this.fontMetrics.stringWidth(this.xTickTexts[this.xTickTexts.length - 1]);
        int x1 = this.textGap + fontAscent + this.textGap + this.maxYTickTextWidth + this.textGap + this.majorTickLength;
        int y1 = this.textGap + fontAscent / 2;
        int x2 = x + width - (this.textGap + widthMaxX / 2);
        int y2 = y + height - (this.textGap + fontAscent + this.textGap + fontAscent + this.textGap + this.majorTickLength);
        int w = x2 - x1 + 1;
        int h = y2 - y1 + 1;
        this.graphArea = new Rectangle(x1, y1, w, h);
        this.transform = null;
        if (w > 0 && h > 0) {
            this.transform = new RectTransform(new Range(this.xAxis.getMinValue(), this.xAxis.getMaxValue()), new Range(this.yAxis.getMinValue(), this.yAxis.getMaxValue()), new Range((double)this.graphArea.x, (double)(this.graphArea.x + this.graphArea.width)), new Range((double)(this.graphArea.y + this.graphArea.height), (double)this.graphArea.y));
        }
        this.setValid(w > 0 && h > 0);
    }

    private void drawGraphs(Graphics2D g2d) {
        DiagramGraph[] graphs;
        Stroke oldStroke = g2d.getStroke();
        Color oldColor = g2d.getColor();
        Rectangle oldClip = g2d.getClipBounds();
        g2d.setClip(this.graphArea.x, this.graphArea.y, this.graphArea.width, this.graphArea.height);
        for (DiagramGraph graph : graphs = this.getGraphs()) {
            double ya;
            double xa;
            int i;
            Point2D.Double a = new Point2D.Double();
            Point2D.Double b1 = new Point2D.Double();
            Point2D.Double b2 = new Point2D.Double();
            g2d.setStroke(graph.getStyle().getOutlineStroke());
            g2d.setColor(graph.getStyle().getOutlineColor());
            int n = graph.getNumValues();
            for (i = 0; i < n; ++i) {
                xa = graph.getXValueAt(i);
                ya = graph.getYValueAt(i);
                if (Double.isNaN(ya)) continue;
                a.setLocation(xa, ya);
                if (b2.equals(new Point2D.Double())) {
                    this.transform.transformA2B(a, b1);
                    b2.setLocation(b1);
                } else {
                    b1.setLocation(b2);
                    this.transform.transformA2B(a, b2);
                }
                if (i <= 0 || b1.equals(b2)) continue;
                g2d.draw(new Line2D.Double(b1, b2));
            }
            g2d.setStroke(new BasicStroke(0.5f));
            if (!graph.getStyle().isShowingPoints()) continue;
            for (i = 0; i < n; ++i) {
                xa = graph.getXValueAt(i);
                ya = graph.getYValueAt(i);
                if (Double.isNaN(ya)) continue;
                a.setLocation(xa, ya);
                this.transform.transformA2B(a, b1);
                Rectangle2D.Double r = new Rectangle2D.Double(b1.getX() - 1.5, b1.getY() - 1.5, 3.0, 3.0);
                g2d.setPaint(graph.getStyle().getFillPaint());
                g2d.fill(r);
                g2d.setColor(graph.getStyle().getOutlineColor());
                g2d.draw(r);
            }
        }
        g2d.setStroke(oldStroke);
        g2d.setColor(oldColor);
        g2d.setClip(oldClip);
    }

    private void drawAxes(Graphics2D g2d, int xOffset, int yOffset, int width, int height) {
        int tw;
        String text;
        int i;
        Stroke oldStroke = g2d.getStroke();
        Color oldColor = g2d.getColor();
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.setColor(this.backgroundColor);
        g2d.fillRect(this.graphArea.x, this.graphArea.y, this.graphArea.width, this.graphArea.height);
        int th = this.fontMetrics.getAscent();
        int xMin = this.graphArea.x;
        int xMax = this.graphArea.x + this.graphArea.width;
        int yMin = this.graphArea.y;
        int yMax = this.graphArea.y + this.graphArea.height;
        int y1 = this.graphArea.y + this.graphArea.height;
        int n1 = this.xAxis.getNumMajorTicks();
        int n2 = this.xAxis.getNumMinorTicks();
        int n = (n1 - 1) * (n2 + 1) + 1;
        for (i = 0; i < n; ++i) {
            int y2;
            int x0 = xMin + i * (xMax - xMin) / (n - 1);
            if (i % (n2 + 1) == 0) {
                y2 = y1 + this.majorTickLength;
                text = this.xTickTexts[i / (n2 + 1)];
                tw = this.fontMetrics.stringWidth(text);
                g2d.setColor(this.textColor);
                g2d.drawString(text, x0 - tw / 2, y2 + this.textGap + this.fontMetrics.getAscent());
                if (this.drawGrid) {
                    g2d.setColor(this.majorGridColor);
                    g2d.drawLine(x0, y1, x0, yMin);
                }
            } else {
                y2 = y1 + this.minorTickLength;
                if (this.drawGrid) {
                    g2d.setColor(this.minorGridColor);
                    g2d.drawLine(x0, y1, x0, yMin);
                }
            }
            g2d.setColor(this.foregroundColor);
            g2d.drawLine(x0, y1, x0, y2);
        }
        int x1 = this.graphArea.x;
        n1 = this.yAxis.getNumMajorTicks();
        n2 = this.yAxis.getNumMinorTicks();
        n = (n1 - 1) * (n2 + 1) + 1;
        for (i = 0; i < n; ++i) {
            int x2;
            int y0 = this.yAxis.isMinToMax() ? yMin + i * (yMax - yMin) / (n - 1) : yMax - i * (yMax - yMin) / (n - 1);
            if (i % (n2 + 1) == 0) {
                x2 = x1 - this.majorTickLength;
                text = this.yTickTexts[n1 - 1 - i / (n2 + 1)];
                tw = this.fontMetrics.stringWidth(text);
                g2d.setColor(this.textColor);
                g2d.drawString(text, x2 - this.textGap - tw, y0 + th / 2);
                if (this.drawGrid) {
                    g2d.setColor(this.majorGridColor);
                    g2d.drawLine(x1, y0, xMax, y0);
                }
            } else {
                x2 = x1 - this.minorTickLength;
                if (this.drawGrid) {
                    g2d.setColor(this.minorGridColor);
                    g2d.drawLine(x1, y0, xMax, y0);
                }
            }
            g2d.setColor(this.foregroundColor);
            g2d.drawLine(x1, y0, x2, y0);
        }
        g2d.setColor(this.foregroundColor);
        g2d.drawRect(this.graphArea.x, this.graphArea.y, this.graphArea.width, this.graphArea.height);
        text = this.getAxisText(this.xAxis);
        tw = this.fontMetrics.stringWidth(text);
        x1 = this.graphArea.x + this.graphArea.width / 2 - tw / 2;
        y1 = yOffset + height - this.textGap;
        g2d.setColor(this.textColor);
        g2d.drawString(text, x1, y1);
        text = this.getAxisText(this.yAxis);
        tw = this.fontMetrics.stringWidth(text);
        x1 = this.graphArea.x - this.majorTickLength - this.textGap - this.maxYTickTextWidth - this.textGap;
        y1 = this.graphArea.y + this.graphArea.height / 2 + tw / 2;
        AffineTransform oldTransform = g2d.getTransform();
        g2d.translate(x1, y1);
        g2d.rotate(-1.5707963267948966);
        g2d.setColor(this.textColor);
        g2d.drawString(text, 0, 0);
        g2d.setTransform(oldTransform);
        g2d.setStroke(oldStroke);
        g2d.setColor(oldColor);
    }

    private String getAxisText(DiagramAxis axis) {
        StringBuilder sb = new StringBuilder(37);
        if (axis.getName() != null && axis.getName().length() > 0) {
            sb.append(axis.getName());
        }
        if (axis.getUnit() != null && axis.getUnit().length() > 0) {
            sb.append(" (");
            sb.append(axis.getUnit());
            sb.append(")");
        }
        return sb.toString();
    }

    public DiagramGraph getClosestGraph(int x, int y) {
        double minDist = Double.MAX_VALUE;
        Point2D.Double a = new Point2D.Double();
        Point2D.Double b1 = new Point2D.Double();
        Point2D.Double b2 = new Point2D.Double();
        DiagramGraph closestGraph = null;
        for (DiagramGraph graph : this.getGraphs()) {
            double minDistGraph = Double.MAX_VALUE;
            int n = graph.getNumValues();
            for (int i = 0; i < n; ++i) {
                Line2D.Double segment;
                double v;
                a.setLocation(graph.getXValueAt(i), graph.getYValueAt(i));
                b1.setLocation(b2);
                this.transform.transformA2B(a, b2);
                if (i <= 0 || !((v = (segment = new Line2D.Double(b1, b2)).ptSegDist(x, y)) < minDistGraph)) continue;
                minDistGraph = v;
            }
            if (!(minDistGraph < minDist)) continue;
            minDist = minDistGraph;
            closestGraph = graph;
        }
        return closestGraph;
    }

    public void adjustAxes(boolean reset) {
        if (reset) {
            this.resetMinMaxAccumulators();
        }
        for (DiagramGraph graph : this.graphs) {
            this.adjustAxes(graph);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adjustAxes(DiagramGraph graph) {
        try {
            boolean yRangeValid;
            boolean xRangeValid;
            this.enableChangeEventMerging();
            DiagramAxis xAxis = this.getXAxis();
            this.xMinAccum = Math.min(this.xMinAccum, graph.getXMin());
            this.xMaxAccum = Math.max(this.xMaxAccum, graph.getXMax());
            boolean bl = xRangeValid = this.xMaxAccum > this.xMinAccum;
            if (xRangeValid) {
                xAxis.setValueRange(this.xMinAccum, this.xMaxAccum);
                xAxis.setOptimalSubDivision(4, 6, 5);
            }
            DiagramAxis yAxis = this.getYAxis();
            this.yMinAccum = Math.min(this.yMinAccum, graph.getYMin());
            this.yMaxAccum = Math.max(this.yMaxAccum, graph.getYMax());
            boolean bl2 = yRangeValid = this.yMaxAccum > this.yMinAccum;
            if (yRangeValid) {
                yAxis.setValueRange(this.yMinAccum, this.yMaxAccum);
                yAxis.setOptimalSubDivision(3, 6, 5);
            }
        }
        finally {
            this.disableChangeEventMerging();
        }
    }

    public void resetMinMaxAccumulators() {
        this.xMinAccum = Double.MAX_VALUE;
        this.xMaxAccum = -1.7976931348623157E308;
        this.yMinAccum = Double.MAX_VALUE;
        this.yMaxAccum = -1.7976931348623157E308;
    }

    public void resetMinMaxAccumulatorsFromAxes() {
        this.xMinAccum = this.getXAxis().getMinValue();
        this.xMaxAccum = this.getXAxis().getMaxValue();
        this.yMinAccum = this.getYAxis().getMinValue();
        this.yMaxAccum = this.getYAxis().getMaxValue();
    }

    private void fireDiagramChanged() {
        if (this.numMergedChangeEvents == -1) {
            DiagramChangeListener[] listeners;
            for (DiagramChangeListener listener : listeners = this.getChangeListeners()) {
                listener.diagramChanged(this);
            }
        } else {
            ++this.numMergedChangeEvents;
        }
    }

    public DiagramChangeListener[] getChangeListeners() {
        return this.changeListeners.toArray(new DiagramChangeListener[0]);
    }

    public void addChangeListener(DiagramChangeListener listener) {
        if (listener != null) {
            this.changeListeners.add(listener);
        }
    }

    public void removeChangeListener(DiagramChangeListener listener) {
        if (listener != null) {
            this.changeListeners.remove(listener);
        }
    }

    public void dispose() {
        this.changeListeners.clear();
        this.removeAllGraphs();
        if (this.xAxis != null) {
            this.xAxis.setDiagram(null);
            this.xAxis = null;
        }
        if (this.yAxis != null) {
            this.yAxis.setDiagram(null);
            this.yAxis = null;
        }
    }

    public static class RectTransform {
        private AffineTransform transformA2B;
        private AffineTransform transformB2A;

        public RectTransform(Range ax, Range ay, Range bx, Range by) {
            double ax1 = ax.getMin();
            double ax2 = ax.getMax();
            double ay1 = ay.getMin();
            double ay2 = ay.getMax();
            double bx1 = bx.getMin();
            double bx2 = bx.getMax();
            double by1 = by.getMin();
            double by2 = by.getMax();
            this.transformA2B = new AffineTransform();
            this.transformA2B.translate(bx1 - ax1 * (bx2 - bx1) / (ax2 - ax1), by1 - ay1 * (by2 - by1) / (ay2 - ay1));
            this.transformA2B.scale((bx2 - bx1) / (ax2 - ax1), (by2 - by1) / (ay2 - ay1));
            try {
                this.transformB2A = this.transformA2B.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                throw new IllegalArgumentException();
            }
        }

        public Point2D transformA2B(Point2D a, Point2D b) {
            return this.transformA2B.transform(a, b);
        }

        public Point2D transformB2A(Point2D b, Point2D a) {
            return this.transformB2A.transform(b, a);
        }
    }
}

