/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.crs;

import com.bc.ceres.swing.TableLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.ui.crs.CrsForm;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CrsSelectionPanel
extends JPanel {
    private CrsChangeListener crsChangeListener;
    private final CrsForm[] crsForms;

    public CrsSelectionPanel(CrsForm ... crsForms) {
        this.crsForms = crsForms;
        this.createUI();
        this.crsChangeListener = new CrsChangeListener();
        this.addPropertyChangeListener("enabled", new EnabledChangeListener());
    }

    public void setReferenceProduct(Product product) {
        for (CrsForm crsForm : this.crsForms) {
            crsForm.setReferenceProduct(product);
        }
    }

    public CoordinateReferenceSystem getCrs(GeoPos referencePos) throws FactoryException {
        for (CrsForm crsForm : this.crsForms) {
            if (!crsForm.getRadioButton().isSelected()) continue;
            return crsForm.getCRS(referencePos);
        }
        return null;
    }

    public void prepareShow() {
        for (CrsForm crsForm : this.crsForms) {
            crsForm.prepareShow();
            crsForm.addCrsChangeListener(this.crsChangeListener);
        }
        this.updateUIState();
    }

    public void prepareHide() {
        for (CrsForm crsForm : this.crsForms) {
            crsForm.prepareHide();
            crsForm.removeCrsChangeListener(this.crsChangeListener);
        }
    }

    private void updateUIState() {
        for (CrsForm crsForm : this.crsForms) {
            crsForm.getCrsUI().setEnabled(crsForm.getRadioButton().isSelected());
        }
    }

    private void createUI() {
        ButtonGroup buttonGroup = new ButtonGroup();
        TableLayout tableLayout = new TableLayout(2);
        tableLayout.setTablePadding(4, 4);
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTableWeightY(Double.valueOf(0.0));
        this.setLayout((LayoutManager)tableLayout);
        this.setBorder(BorderFactory.createTitledBorder("Coordinate Reference System (CRS)"));
        UpdateStateListener updateStateListener = new UpdateStateListener();
        int rowCount = 0;
        int crsFormsLength = this.crsForms.length;
        for (int i = 0; i < crsFormsLength; ++i) {
            CrsForm crsForm = this.crsForms[i];
            JRadioButton crsRadioButton = crsForm.getRadioButton();
            crsRadioButton.setSelected(i == 0);
            crsRadioButton.addActionListener(updateStateListener);
            JComponent crsComponent = crsForm.getCrsUI();
            crsComponent.setEnabled(i == 0);
            buttonGroup.add(crsRadioButton);
            if (crsForm.wrapAfterButton()) {
                tableLayout.setCellColspan(rowCount, 0, Integer.valueOf(2));
                tableLayout.setCellColspan(++rowCount, 0, Integer.valueOf(2));
                tableLayout.setCellPadding(rowCount, 0, new Insets(4, 24, 4, 4));
                ++rowCount;
            } else {
                tableLayout.setCellWeightX(rowCount, 0, Double.valueOf(0.0));
                ++rowCount;
            }
            this.add(crsRadioButton);
            this.add(crsComponent);
        }
    }

    private void fireCrsChanged() {
        this.firePropertyChange("crs", null, null);
    }

    private class EnabledChangeListener
    implements PropertyChangeListener {
        private EnabledChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Boolean enabled = (Boolean)evt.getNewValue();
            for (CrsForm crsForm : CrsSelectionPanel.this.crsForms) {
                JRadioButton button = crsForm.getRadioButton();
                button.setEnabled(enabled);
                boolean selected = button.isSelected();
                crsForm.getCrsUI().setEnabled(selected && enabled != false);
            }
        }
    }

    private class CrsChangeListener
    implements PropertyChangeListener {
        private CrsChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CrsSelectionPanel.this.fireCrsChanged();
        }
    }

    private class UpdateStateListener
    implements ActionListener {
        private UpdateStateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CrsSelectionPanel.this.updateUIState();
            CrsSelectionPanel.this.fireCrsChanged();
        }
    }
}

