/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.crs;

import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.esa.snap.core.datamodel.GeoPos;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.FallbackAuthorityFactory;
import org.geotools.referencing.factory.wms.AutoCRSFactory;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.ProjectedCRS;

class CrsInfo
implements Comparable<CrsInfo> {
    private static final String AUTHORITY = "EPSG";
    private final String crsCode;
    private final CRSAuthorityFactory factory;

    CrsInfo(String crsCode, CRSAuthorityFactory factory) {
        this.crsCode = crsCode;
        this.factory = factory;
    }

    public CoordinateReferenceSystem getCrs(GeoPos referencePos) throws FactoryException {
        return this.factory.createCoordinateReferenceSystem(this.crsCode);
    }

    @Override
    public int compareTo(CrsInfo o) {
        return this.crsCode.compareTo(o.crsCode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CrsInfo)) {
            return false;
        }
        CrsInfo crsInfo = (CrsInfo)o;
        return !(this.crsCode == null ? crsInfo.crsCode != null : !this.crsCode.equals(crsInfo.crsCode));
    }

    public int hashCode() {
        return this.crsCode != null ? this.crsCode.hashCode() : 0;
    }

    public String toString() {
        String crsDescription = this.crsCode + " - ";
        try {
            crsDescription = crsDescription + this.factory.getDescriptionText(this.crsCode).toString();
        }
        catch (Exception e) {
            crsDescription = crsDescription + e.getLocalizedMessage();
        }
        return crsDescription;
    }

    public String getDescription() {
        try {
            return this.getCrs(null).toString();
        }
        catch (FactoryException e) {
            return e.getMessage();
        }
    }

    static List<CrsInfo> generateCRSList() {
        Hints hints = new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)true);
        Set factories = ReferencingFactoryFinder.getCRSAuthorityFactories((Hints)hints);
        ArrayList<CRSAuthorityFactory> filtered = new ArrayList<CRSAuthorityFactory>();
        for (CRSAuthorityFactory factory : factories) {
            if (!Citations.identifierMatches((Citation)factory.getAuthority(), (String)AUTHORITY)) continue;
            filtered.add(factory);
        }
        CRSAuthorityFactory crsAuthorityFactory = (CRSAuthorityFactory)FallbackAuthorityFactory.create(CRSAuthorityFactory.class, filtered);
        HashSet<String> codes = new HashSet<String>();
        ArrayList<CrsInfo> crsList = new ArrayList<CrsInfo>(1024);
        CrsInfo.retrieveCodes(codes, GeodeticCRS.class, crsAuthorityFactory);
        CrsInfo.retrieveCodes(codes, ProjectedCRS.class, crsAuthorityFactory);
        for (String code : codes) {
            String authCode = String.format("%s:%s", AUTHORITY, code);
            crsList.add(new CrsInfo(authCode, crsAuthorityFactory));
        }
        codes.clear();
        AutoCRSFactory autoCRSFactory = new AutoCRSFactory();
        CrsInfo.retrieveCodes(codes, ProjectedCRS.class, (CRSAuthorityFactory)autoCRSFactory);
        for (String code : codes) {
            String authCode = String.format("AUTO:%s", code);
            crsList.add(new AutoCrsInfo(authCode, (CRSAuthorityFactory)autoCRSFactory));
        }
        Collections.sort(crsList);
        return crsList;
    }

    private static void retrieveCodes(Set<String> codes, Class<? extends CoordinateReferenceSystem> crsType, CRSAuthorityFactory factory) {
        Set localCodes;
        try {
            localCodes = factory.getAuthorityCodes(crsType);
        }
        catch (FactoryException ignore) {
            return;
        }
        codes.addAll(localCodes);
    }

    private static class AutoCrsInfo
    extends CrsInfo {
        AutoCrsInfo(String epsgCode, CRSAuthorityFactory factory) {
            super(epsgCode, factory);
        }

        @Override
        public CoordinateReferenceSystem getCrs(GeoPos referencePos) throws FactoryException {
            if (referencePos == null) {
                referencePos = new GeoPos(0.0, 0.0);
            }
            String code = String.format("%s,%s,%s", ((CrsInfo)this).crsCode, referencePos.lon, referencePos.lat);
            return ((CrsInfo)this).factory.createCoordinateReferenceSystem(code);
        }

        @Override
        public String toString() {
            String crsDescription = ((CrsInfo)this).crsCode + " - ";
            try {
                String code = ((CrsInfo)this).crsCode + ",0,0";
                crsDescription = crsDescription + ((CrsInfo)this).factory.getDescriptionText(code).toString();
            }
            catch (Exception e) {
                crsDescription = crsDescription + e.getLocalizedMessage();
            }
            return crsDescription;
        }

        @Override
        public String getDescription() {
            return this.toString();
        }
    }
}

