/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.color;

import com.bc.ceres.core.Assert;
import java.awt.Color;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.ui.color.ColorComboBox;

public class ColorCodes {
    private List<String> nameList = new ArrayList<String>(512);
    private Map<Color, String> nameMap = new HashMap<Color, String>(512);
    private Map<String, Color> colorMap = new HashMap<String, Color>(512);
    static final ColorCodes instance = new ColorCodes();

    private ColorCodes() {
        try {
            Path path = FileUtils.getPathFromURI((URI)ColorComboBox.class.getResource("color-codes.txt").toURI());
            List<String> lines = Files.readAllLines(path);
            for (String line : lines) {
                int i = line.indexOf(9);
                Color color = Color.decode(line.substring(0, i).trim());
                String name = line.substring(i).trim();
                Assert.state((!this.nameMap.containsKey(color) ? 1 : 0) != 0, (String)String.format("color '%s' already added", color));
                Assert.state((!this.colorMap.containsKey(name) ? 1 : 0) != 0, (String)String.format("color '%s' already added", name));
                this.nameList.add(name);
                this.nameMap.put(color, name);
                this.colorMap.put(name, color);
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> getNames() {
        return Collections.unmodifiableList(ColorCodes.instance.nameList);
    }

    public static int indexOf(String name) {
        return ColorCodes.instance.nameList.indexOf(name);
    }

    public static int indexOf(Color color) {
        String name = ColorCodes.getName(color);
        if (name != null) {
            return ColorCodes.indexOf(name);
        }
        return -1;
    }

    public static Color getColor(String name) {
        return ColorCodes.instance.colorMap.get(name);
    }

    public static String getName(Color color) {
        return ColorCodes.instance.nameMap.get(color);
    }

    public static Color getColor(int index) {
        return ColorCodes.getColor(ColorCodes.getName(index));
    }

    public static String getName(int index) {
        return ColorCodes.instance.nameList.get(index);
    }
}

