/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui;

import com.bc.ceres.core.Assert;
import java.awt.Color;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.ui.AbstractImageInfoEditorModel;

public class DefaultImageInfoEditorModel
extends AbstractImageInfoEditorModel {
    public DefaultImageInfoEditorModel(ImageInfo imageInfo) {
        super(imageInfo);
        Assert.argument((imageInfo.getColorPaletteDef() != null ? 1 : 0) != 0, (String)"imageInfo");
    }

    @Override
    public boolean isColorEditable() {
        return true;
    }

    @Override
    public int getSliderCount() {
        return this.getImageInfo().getColorPaletteDef().getNumPoints();
    }

    @Override
    public double getSliderSample(int index) {
        return this.getImageInfo().getColorPaletteDef().getPointAt(index).getSample();
    }

    @Override
    public void setSliderSample(int index, double sample) {
        this.getImageInfo().getColorPaletteDef().getPointAt(index).setSample(sample);
        this.fireStateChanged();
    }

    @Override
    public Color getSliderColor(int index) {
        return this.getImageInfo().getColorPaletteDef().getPointAt(index).getColor();
    }

    @Override
    public void setSliderColor(int index, Color color) {
        this.getImageInfo().getColorPaletteDef().getPointAt(index).setColor(color);
        this.fireStateChanged();
    }

    @Override
    public void createSliderAfter(int index) {
        boolean b = this.getImageInfo().getColorPaletteDef().createPointAfter(index, this.getSampleScaling());
        if (b) {
            this.fireStateChanged();
        }
    }

    @Override
    public void removeSlider(int index) {
        this.getImageInfo().getColorPaletteDef().removePointAt(index);
        this.fireStateChanged();
    }

    @Override
    public Color[] createColorPalette() {
        return ImageManager.createColorPalette((ImageInfo)this.getImageInfo());
    }

    @Override
    public boolean isGammaUsed() {
        return false;
    }

    @Override
    public double getGamma() {
        return 1.0;
    }

    @Override
    public void setGamma(double gamma) {
    }

    @Override
    public byte[] getGammaCurve() {
        return null;
    }
}

