/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import com.bc.ceres.binding.BindingException;
import com.vividsolutions.jts.geom.Geometry;
import java.lang.reflect.Constructor;
import org.esa.snap.binning.Aggregator;
import org.esa.snap.binning.AggregatorConfig;
import org.esa.snap.binning.AggregatorDescriptor;
import org.esa.snap.binning.BinManager;
import org.esa.snap.binning.BinningContext;
import org.esa.snap.binning.CellProcessorConfig;
import org.esa.snap.binning.CompositingType;
import org.esa.snap.binning.DataPeriod;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.TemporalDataPeriod;
import org.esa.snap.binning.TypedDescriptorsRegistry;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.operator.AggregatorConfigDomConverter;
import org.esa.snap.binning.operator.BinningOp;
import org.esa.snap.binning.operator.CellProcessorConfigDomConverter;
import org.esa.snap.binning.operator.VariableConfig;
import org.esa.snap.binning.support.BinTracer;
import org.esa.snap.binning.support.BinningContextImpl;
import org.esa.snap.binning.support.SEAGrid;
import org.esa.snap.binning.support.SpatialDataPeriod;
import org.esa.snap.binning.support.VariableContextImpl;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.ParameterBlockConverter;
import org.esa.snap.core.util.converters.JtsGeometryConverter;

public class BinningConfig {
    private static final int MAX_DISTANCE_ON_EARTH_DEFAULT = -1;
    private static final int SUPER_SAMPLING_DEFAULT = 1;
    private String planetaryGrid = "org.esa.snap.binning.support.SEAGrid";
    @Parameter(description="Number of rows in the (global) planetary grid. Must be even.", defaultValue="2160")
    private int numRows;
    private CompositingType compositingType = CompositingType.BINNING;
    @Parameter(description="The square of the number of pixels used for super-sampling an input pixel into multiple sub-pixels", defaultValue="1")
    private Integer superSampling;
    @Parameter(description="Skips binning of sub-pixel if distance on earth to the center of the main-pixel is larger as this value. A value <=0 disables this check", defaultValue="-1")
    private Integer maxDistanceOnEarth;
    @Parameter(description="The band maths expression used to filter input pixels")
    private String maskExpr;
    @Parameter(alias="variables", itemAlias="variable", description="List of variables. A variable will generate a virtual band in each source data product, so that it can be used as input for the binning.")
    private VariableConfig[] variableConfigs;
    @Parameter(alias="aggregators", domConverter=AggregatorConfigDomConverter.class, description="List of aggregators. Aggregators generate the bands in the binned output products")
    private AggregatorConfig[] aggregatorConfigs;
    @Parameter(alias="postProcessor", domConverter=CellProcessorConfigDomConverter.class)
    private CellProcessorConfig postProcessorConfig;
    @Parameter(description="The time in hours of a day (0 to 24) at which a given sensor has a minimum number of observations at the date line (the 180 degree meridian). Only used if parameter 'startDate' is set.")
    private Double minDataHour;
    @Parameter(description="The type of metadata aggregation to be used. Possible values are:\n'NAME': aggregate the name of each input product\n'FIRST_HISTORY': aggregates all input product names and the processing history of the first product\n'ALL_HISTORIES': aggregates all input product names and processing histories", valueSet={"NAME", "FIRST_HISTORY", "ALL_HISTORIES"}, defaultValue="FIRST_HISTORY")
    private String metadataAggregatorName;
    @Parameter(pattern="\\d{4}-\\d{2}-\\d{2}(\\s\\d{2}:\\d{2}:\\d{2})?", description="The UTC start date of the binning period. The format is either 'yyyy-MM-dd HH:mm:ss' or 'yyyy-MM-dd'. If only the date part is given, the time 00:00:00 is assumed.")
    private String startDateTime;
    @Parameter(description="Duration of the binning period in days.")
    private Double periodDuration;
    @Parameter(description="The method that is used to decide which source pixels are used with respect to their observation time. 'NONE': ignore pixel observation time, use all source pixels. 'TIME_RANGE': use all pixels that have been acquired in the given binning period. 'SPATIOTEMPORAL_DATA_DAY': use a sensor-dependent, spatial \"data-day\" definition with the goal to minimise the time between the first and last observation contributing to the same bin in the given binning period. The decision, whether a source pixel contributes to a bin or not, is a function of the pixel's observation longitude and time. Requires the parameter 'minDataHour'.", defaultValue="NONE")
    private BinningOp.TimeFilterMethod timeFilterMethod;
    @Parameter
    private String outputFile;
    @Parameter(converter=JtsGeometryConverter.class, description="The considered geographical region as a geometry in well-known text format (WKT).\nIf not given, the geographical region will be computed according to the extents of the input products.")
    Geometry region;

    public String getPlanetaryGrid() {
        return this.planetaryGrid;
    }

    public void setPlanetaryGrid(String planetaryGrid) {
        this.planetaryGrid = planetaryGrid;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    public Double getMinDataHour() {
        return this.minDataHour;
    }

    public void setMinDataHour(Double minDataHour) {
        this.minDataHour = minDataHour;
    }

    public String getMaskExpr() {
        return this.maskExpr;
    }

    public void setMaskExpr(String maskExpr) {
        this.maskExpr = maskExpr;
    }

    public Integer getSuperSampling() {
        return this.superSampling;
    }

    public void setSuperSampling(Integer superSampling) {
        this.superSampling = superSampling;
    }

    public Integer getMaxDistanceOnEarth() {
        return this.maxDistanceOnEarth;
    }

    public void setMaxDistanceOnEarth(Integer maxDistanceOnEarth) {
        this.maxDistanceOnEarth = maxDistanceOnEarth;
    }

    public CompositingType getCompositingType() {
        return this.compositingType;
    }

    public void setCompositingType(CompositingType type) {
        this.compositingType = type;
    }

    public VariableConfig[] getVariableConfigs() {
        return this.variableConfigs;
    }

    public void setVariableConfigs(VariableConfig ... variableConfigs) {
        this.variableConfigs = variableConfigs;
    }

    public AggregatorConfig[] getAggregatorConfigs() {
        return this.aggregatorConfigs;
    }

    public void setAggregatorConfigs(AggregatorConfig ... aggregatorConfigs) {
        this.aggregatorConfigs = aggregatorConfigs;
    }

    public CellProcessorConfig getPostProcessorConfig() {
        return this.postProcessorConfig;
    }

    public void setPostProcessorConfig(CellProcessorConfig cellProcessorConfig) {
        this.postProcessorConfig = cellProcessorConfig;
    }

    public String getMetadataAggregatorName() {
        return this.metadataAggregatorName;
    }

    public void setMetadataAggregatorName(String metadataAggregatorName) {
        this.metadataAggregatorName = metadataAggregatorName;
    }

    public String getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(String startDateTime) {
        this.startDateTime = startDateTime;
    }

    public Double getPeriodDuration() {
        return this.periodDuration;
    }

    public void setPeriodDuration(Double periodDuration) {
        this.periodDuration = periodDuration;
    }

    public BinningOp.TimeFilterMethod getTimeFilterMethod() {
        return this.timeFilterMethod;
    }

    public void setTimeFilterMethod(BinningOp.TimeFilterMethod timeFilterMethod) {
        this.timeFilterMethod = timeFilterMethod;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public Geometry getRegion() {
        return this.region;
    }

    public void setRegion(Geometry region) {
        this.region = region;
    }

    public static BinningConfig fromXml(String xml) throws BindingException {
        return (BinningConfig)new ParameterBlockConverter().convertXmlToObject(xml, (Object)new BinningConfig());
    }

    public String toXml() {
        try {
            return new ParameterBlockConverter().convertObjectToXml((Object)this);
        }
        catch (BindingException e) {
            throw new RuntimeException(e);
        }
    }

    public BinningContext createBinningContext(Geometry region, ProductData.UTC startDate, Double periodDuration) {
        PlanetaryGrid planetaryGridInst = this.createPlanetaryGrid();
        VariableContext variableContext = this.createVariableContext();
        Aggregator[] aggregators = this.createAggregators(variableContext);
        BinManager binManager = this.createBinManager(variableContext, aggregators);
        binManager.setBinTracer(BinTracer.create(binManager, planetaryGridInst, this.outputFile));
        DataPeriod dataPeriod = BinningConfig.createDataPeriod(startDate, periodDuration, this.minDataHour);
        int effSuperSampling = this.getSuperSampling() != null ? this.getSuperSampling() : 1;
        int effMaxDistanceOnEarth = this.getMaxDistanceOnEarth() != null ? this.getMaxDistanceOnEarth() : -1;
        return new BinningContextImpl(planetaryGridInst, binManager, this.compositingType, effSuperSampling, effMaxDistanceOnEarth, dataPeriod, region);
    }

    public PlanetaryGrid createPlanetaryGrid() {
        if (this.planetaryGrid == null) {
            if (this.numRows > 0) {
                return new SEAGrid(this.numRows);
            }
            return new SEAGrid();
        }
        try {
            if (this.numRows > 0) {
                Constructor<?> constructor = Class.forName(this.planetaryGrid).getConstructor(Integer.TYPE);
                return (PlanetaryGrid)constructor.newInstance(this.numRows);
            }
            return (PlanetaryGrid)Class.forName(this.planetaryGrid).newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(this.planetaryGrid, e);
        }
    }

    public Aggregator[] createAggregators(VariableContext variableContext) {
        if (this.aggregatorConfigs == null) {
            return new Aggregator[0];
        }
        Aggregator[] aggregators = new Aggregator[this.aggregatorConfigs.length];
        TypedDescriptorsRegistry registry = TypedDescriptorsRegistry.getInstance();
        for (int i = 0; i < aggregators.length; ++i) {
            AggregatorConfig aggregatorConfig = this.aggregatorConfigs[i];
            AggregatorDescriptor descriptor = registry.getDescriptor(AggregatorDescriptor.class, aggregatorConfig.getName());
            if (descriptor == null) {
                throw new IllegalArgumentException("Unknown aggregator type: " + aggregatorConfig.getName());
            }
            aggregators[i] = descriptor.createAggregator(variableContext, aggregatorConfig);
        }
        return aggregators;
    }

    protected BinManager createBinManager(VariableContext variableContext, Aggregator[] aggregators) {
        return new BinManager(variableContext, this.postProcessorConfig, aggregators);
    }

    public VariableContext createVariableContext() {
        VariableContextImpl variableContext = new VariableContextImpl();
        variableContext.setMaskExpr(this.maskExpr);
        if (this.variableConfigs != null) {
            for (VariableConfig varConfig : this.variableConfigs) {
                variableContext.defineVariable(varConfig.getName(), varConfig.getExpr(), varConfig.getValidExpr());
            }
        }
        if (this.aggregatorConfigs != null) {
            TypedDescriptorsRegistry registry = TypedDescriptorsRegistry.getInstance();
            for (AggregatorConfig aggregatorConfig : this.aggregatorConfigs) {
                AggregatorDescriptor descriptor = registry.getDescriptor(AggregatorDescriptor.class, aggregatorConfig.getName());
                if (descriptor != null) {
                    String[] varNames;
                    for (String varName : varNames = descriptor.getSourceVarNames(aggregatorConfig)) {
                        variableContext.defineVariable(varName);
                    }
                    continue;
                }
                throw new IllegalArgumentException("Unknown aggregator type: " + aggregatorConfig.getName());
            }
        }
        if (BinTracer.isActive()) {
            variableContext.defineVariable("_TRACE_X", "X");
            variableContext.defineVariable("_TRACE_Y", "Y");
        }
        return variableContext;
    }

    public static DataPeriod createDataPeriod(ProductData.UTC startUtc, Double periodDuration, Double minDataHour) {
        if (startUtc != null) {
            if (minDataHour != null) {
                return new SpatialDataPeriod(startUtc.getMJD(), periodDuration, minDataHour);
            }
            return new TemporalDataPeriod(startUtc.getMJD(), periodDuration);
        }
        return null;
    }
}

