/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.media.jai.PlanarImage;

abstract class SamplePointer {
    SamplePointer() {
    }

    public static SamplePointer create(PlanarImage[] sourceImages, Rectangle[] bounds) {
        return new SamplePointerNoSuperSampling(sourceImages, bounds);
    }

    public static SamplePointer create(PlanarImage[] sourceImages, Rectangle[] bounds, Point2D.Float[] superSamplingPoints) {
        return new SamplePointerImpl(sourceImages, bounds, superSamplingPoints);
    }

    public static Point2D.Float[] createSamplingPoints(float[] samplingSteps) {
        int numSuperSamplingSteps = samplingSteps.length * samplingSteps.length;
        Point2D.Float[] superSamplingPoints = new Point2D.Float[numSuperSamplingSteps];
        int index = 0;
        for (float dy : samplingSteps) {
            for (float dx : samplingSteps) {
                superSamplingPoints[index++] = new Point2D.Float(dx, dy);
            }
        }
        return superSamplingPoints;
    }

    abstract void move();

    abstract boolean canMove();

    abstract int getX();

    abstract int getY();

    abstract Point2D.Float getSuperSamplingPoint();

    abstract float[] createSamples();

    private static final class SamplePointerNoSuperSampling
    extends SamplePointer {
        private static final Point2D.Float CENTER = new Point2D.Float(0.5f, 0.5f);
        private final PlanarImage[] sourceImages;
        private final List<Rectangle> boundsList;
        private int x1;
        private int x2;
        private int y2;
        private int x;
        private int y;
        private Raster[] sourceTiles;
        private Rectangle currentBounds;

        SamplePointerNoSuperSampling(PlanarImage[] sourceImages, Rectangle[] bounds) {
            this.sourceImages = sourceImages;
            this.sourceTiles = new Raster[sourceImages.length];
            this.boundsList = new LinkedList<Rectangle>();
            Collections.addAll(this.boundsList, bounds);
            this.updateBounds();
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        @Override
        public Point2D.Float getSuperSamplingPoint() {
            return CENTER;
        }

        @Override
        public void move() {
            if (!this.canMove()) {
                throw new IllegalStateException("End of Samples!");
            }
            ++this.x;
            if (this.x == this.x2) {
                this.x = this.x1;
                ++this.y;
                if (this.y == this.y2) {
                    this.updateBounds();
                    ++this.x;
                }
            }
        }

        @Override
        float[] createSamples() {
            float[] samples = new float[this.sourceTiles.length];
            for (int i = 0; i < samples.length; ++i) {
                samples[i] = this.sourceTiles[i].getSampleFloat(this.x, this.y, 0);
            }
            return samples;
        }

        @Override
        public boolean canMove() {
            boolean canMoveX = this.x < this.x2 - 1;
            boolean canMoveY = this.y < this.y2 - 1;
            return canMoveX || canMoveY || !this.boundsList.isEmpty();
        }

        private void updateBounds() {
            this.currentBounds = this.boundsList.remove(0);
            this.x1 = this.currentBounds.x;
            this.x2 = this.x1 + this.currentBounds.width;
            this.x = this.x1 - 1;
            this.y = this.currentBounds.y;
            this.y2 = this.currentBounds.y + this.currentBounds.height;
            for (int i = 0; i < this.sourceImages.length; ++i) {
                this.sourceTiles[i] = this.sourceImages[i].getData(this.currentBounds);
            }
        }
    }

    private static final class SamplePointerImpl
    extends SamplePointer {
        private final PlanarImage[] sourceImages;
        private final Raster[] sourceTiles;
        private final Point2D.Float[] superSamplingPoints;
        private final float[] lastSamples;
        private final List<Rectangle> boundsList;
        private int x1;
        private int x2;
        private int y2;
        private int x;
        private int y;
        private int lastX;
        private int lastY;
        private int superSamplingIndex;

        SamplePointerImpl(PlanarImage[] sourceImages, Rectangle[] bounds, Point2D.Float[] superSamplingPoints) {
            this.sourceImages = sourceImages;
            this.boundsList = new LinkedList<Rectangle>();
            Collections.addAll(this.boundsList, bounds);
            this.superSamplingPoints = superSamplingPoints;
            this.sourceTiles = new Raster[sourceImages.length];
            this.updateBounds();
            this.superSamplingIndex = -1;
            this.lastX = this.x - 1;
            this.lastY = this.y - 1;
            this.lastSamples = new float[sourceImages.length];
        }

        private void updateBounds() {
            Rectangle currentBounds = this.boundsList.remove(0);
            this.x1 = currentBounds.x;
            this.x2 = this.x1 + currentBounds.width;
            this.x = this.x1;
            this.y = currentBounds.y;
            this.y2 = currentBounds.y + currentBounds.height;
            for (int i = 0; i < this.sourceImages.length; ++i) {
                this.sourceTiles[i] = this.sourceImages[i].getData(currentBounds);
            }
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        @Override
        public Point2D.Float getSuperSamplingPoint() {
            return this.superSamplingPoints[this.superSamplingIndex];
        }

        @Override
        public void move() {
            if (!this.canMove()) {
                throw new IllegalStateException("End of Samples!");
            }
            ++this.superSamplingIndex;
            if (this.superSamplingIndex == this.superSamplingPoints.length) {
                this.superSamplingIndex = 0;
                ++this.x;
                if (this.x == this.x2) {
                    this.x = this.x1;
                    ++this.y;
                }
            }
        }

        @Override
        public boolean canMove() {
            boolean canMoveX = this.x < this.x2 - 1;
            boolean canMoveY = this.y < this.y2 - 1;
            boolean canMoveSamplePoint = this.superSamplingIndex < this.superSamplingPoints.length - 1;
            return canMoveX || canMoveY || canMoveSamplePoint;
        }

        @Override
        public float[] createSamples() {
            if (this.hasSampleLocationChanged(this.x, this.y)) {
                this.lastX = this.x;
                this.lastY = this.y;
                for (int i = 0; i < this.lastSamples.length; ++i) {
                    this.lastSamples[i] = this.sourceTiles[i].getSampleFloat(this.x, this.y, 0);
                }
            }
            return this.lastSamples;
        }

        private boolean hasSampleLocationChanged(int x, int y) {
            return x != this.lastX || y != this.lastY;
        }
    }
}

