/*
 * Decompiled with CFR 0.152.
 */
package com.bc.jnn.nnio;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;

public class NnaTokenizer {
    private StreamTokenizer tokenizer;

    public NnaTokenizer(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("reader == null");
        }
        this.tokenizer = new StreamTokenizer(reader);
        this.tokenizer.resetSyntax();
        this.tokenizer.whitespaceChars(32, 32);
        this.tokenizer.whitespaceChars(9, 9);
        this.tokenizer.whitespaceChars(13, 13);
        this.tokenizer.commentChar(59);
        this.tokenizer.wordChars(65, 90);
        this.tokenizer.wordChars(97, 122);
        this.tokenizer.wordChars(95, 95);
        this.tokenizer.wordChars(45, 45);
        this.tokenizer.wordChars(43, 43);
        this.tokenizer.wordChars(46, 46);
        this.tokenizer.wordChars(48, 57);
        this.tokenizer.eolIsSignificant(true);
    }

    public void nextToken() throws IOException {
        this.tokenizer.nextToken();
        if (this.isKeyword()) {
            try {
                double nval;
                this.tokenizer.nval = nval = Double.parseDouble(this.getKeyword());
                this.tokenizer.ttype = -2;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public char getCharacter() {
        return (char)this.tokenizer.ttype;
    }

    public String getKeyword() {
        return this.tokenizer.sval;
    }

    public double getNumber() {
        return this.tokenizer.nval;
    }

    public int getLineNumber() {
        return this.tokenizer.lineno();
    }

    public void pushBackToken() {
        this.tokenizer.pushBack();
    }

    public boolean isKeyword() {
        return this.tokenizer.ttype == -3;
    }

    public boolean isNumber() {
        return this.tokenizer.ttype == -2;
    }

    public boolean isEol() {
        return this.tokenizer.ttype == 10;
    }

    public boolean isEof() {
        return this.tokenizer.ttype == -1;
    }

    public boolean isCharacter() {
        return this.tokenizer.ttype >= 32;
    }
}

