/*
 * Decompiled with CFR 0.152.
 */
package com.bc.jnn.func;

import com.bc.jnn.func.ActFunctionIdentity;
import com.bc.jnn.func.ActFunctionLinear;
import com.bc.jnn.func.ActFunctionSemiLinear;
import com.bc.jnn.func.ActFunctionSigmoidOpt;
import com.bc.jnn.func.ActFunctionSigmoid_1;
import com.bc.jnn.func.ActFunctionTangentSigmoid;
import com.bc.jnn.func.ActFunctionThreshold;
import com.bc.jnn.func.IActivationFunction;
import com.bc.jnn.func.IInputFunction;
import com.bc.jnn.func.IOutputFunction;
import com.bc.jnn.func.InputFunctionSum_1;
import com.bc.jnn.func.InputFunctionSum_2;
import com.bc.jnn.func.InputFunctionZero;
import com.bc.jnn.func.OutputFunctionExponential;
import com.bc.jnn.func.OutputFunctionIdentity;
import com.bc.jnn.func.OutputFunctionLinear;
import com.bc.jnn.func.OutputFunctionLogarithmic;

public class JnnFunctionFactory {
    public static IInputFunction getInputFunction(int inpFuncId, boolean optimize) {
        switch (inpFuncId) {
            case 0: {
                return new InputFunctionZero();
            }
            case 40: {
                return new InputFunctionSum_1();
            }
            case 41: {
                return new InputFunctionSum_2();
            }
        }
        throw new IllegalArgumentException("illegal input function index '" + inpFuncId + "'");
    }

    public static IActivationFunction getActivationFunction(int actFuncId, boolean optimize) {
        switch (actFuncId) {
            case 1: {
                return new ActFunctionIdentity();
            }
            case 10: {
                return new ActFunctionThreshold();
            }
            case 11: {
                return new ActFunctionLinear();
            }
            case 12: {
                return new ActFunctionSemiLinear();
            }
            case 20: {
                if (optimize) {
                    return new ActFunctionSigmoidOpt();
                }
                return new ActFunctionSigmoid_1();
            }
            case 21: {
                throw new IllegalArgumentException("unsupported activation function: Sigmoid_2");
            }
            case 22: {
                return new ActFunctionTangentSigmoid();
            }
            case 30: {
                throw new IllegalArgumentException("unsupported activation function: Rbf_1");
            }
            case 31: {
                throw new IllegalArgumentException("unsupported activation function: Rbf_2");
            }
        }
        throw new IllegalArgumentException("illegal activation function index '" + actFuncId + "'");
    }

    public static IOutputFunction getOutputFunction(int outFuncId, boolean optimize) {
        switch (outFuncId) {
            case 1: {
                return new OutputFunctionIdentity();
            }
            case 11: {
                return new OutputFunctionLinear();
            }
            case 13: {
                return new OutputFunctionExponential();
            }
            case 14: {
                return new OutputFunctionLogarithmic();
            }
        }
        throw new IllegalArgumentException("illegal output function index '" + outFuncId + "'");
    }
}

