/*
 * Decompiled with CFR 0.152.
 */
package com.bc.jnn;

import com.bc.jnn.JnnConnection;
import com.bc.jnn.JnnLayer;
import com.bc.jnn.JnnUnit;
import java.text.MessageFormat;

public final class JnnNet
implements Cloneable {
    private int _versionMajor = 1;
    private int _versionMinor = 0;
    private int numLayers = 1;
    private int _inputLayerIndex = -1;
    private int _outputLayerIndex = -1;
    private int _precision = 8;
    private JnnLayer[] layers;

    public int getVersionMajor() {
        return this._versionMajor;
    }

    public void setVersionMajor(int vers) {
        this._versionMajor = vers;
    }

    public int getVersionMinor() {
        return this._versionMinor;
    }

    public void setVersionMinor(int vers) {
        this._versionMinor = vers;
    }

    public String getVersionString() {
        return new String(this._versionMajor + "." + this._versionMinor);
    }

    public int getNumLayers() {
        return this.numLayers;
    }

    public void setNumLayers(int numLayers) {
        if (numLayers < 0) {
            throw new IllegalArgumentException("invalid number of layers");
        }
        this.numLayers = numLayers;
        if (this.layers == null || this.layers.length != this.numLayers) {
            this.layers = new JnnLayer[this.numLayers];
        }
    }

    public int getPrecision() {
        return this._precision;
    }

    public void setPrecision(int prec) {
        if (prec != 4 && prec != 8) {
            throw new IllegalArgumentException("Invalid neural net precision value '" + prec + "'");
        }
        this._precision = prec;
    }

    public int getInputLayerIndex() {
        return this._inputLayerIndex;
    }

    public void setInputLayerIndex(int index) {
        this._inputLayerIndex = index;
    }

    public int getOutputLayerIndex() {
        return this._outputLayerIndex;
    }

    public void setOutputLayerIndex(int index) {
        this._outputLayerIndex = index;
    }

    public JnnLayer getLayerAt(int index) {
        return this.layers[index];
    }

    public void setLayerAt(int index, JnnLayer layer) {
        this.layers[index] = layer;
    }

    public boolean init() {
        StringBuffer msg = new StringBuffer(32);
        return this.init(false, msg);
    }

    public boolean init(StringBuffer report) {
        return this.init(false, report);
    }

    public boolean init(boolean optimizing, StringBuffer report) {
        return this.initLayerFunctions(optimizing, report) && this.initConnections(report);
    }

    public boolean verifyIntegrity() {
        return this.init();
    }

    public boolean verifyIntegrity(StringBuffer report) {
        return this.init(false, report);
    }

    public void process(double[] input, double[] output) {
        for (int i = 0; i < this.numLayers; ++i) {
            JnnLayer currentLayer = this.layers[i];
            currentLayer.calcInputFunction();
            if (this._inputLayerIndex == i) {
                currentLayer.setInputData(input);
            }
            currentLayer.calcActivationFunction();
            currentLayer.calcOutputFunction();
            if (this._outputLayerIndex != i) continue;
            currentLayer.getOutputData(output);
        }
    }

    public JnnNet clone() {
        try {
            JnnNet clonedNet = (JnnNet)super.clone();
            JnnLayer[] clonedLayers = (JnnLayer[])this.layers.clone();
            for (int i = 0; i < clonedLayers.length; ++i) {
                clonedLayers[i] = clonedLayers[i].clone();
            }
            clonedNet.layers = clonedLayers;
            StringBuffer report = new StringBuffer();
            if (!clonedNet.initConnections(report)) {
                throw new IllegalStateException(report.toString());
            }
            return clonedNet;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean initLayerFunctions(boolean optimizing, StringBuffer msg) {
        if (this.numLayers < 1) {
            msg.append(MessageFormat.format("invalid number of layers: ''{0}'' (should be > 0)", this.numLayers));
            return false;
        }
        if (this.layers == null) {
            msg.append("no layers defined");
            return false;
        }
        if (this._inputLayerIndex < 0 || this._inputLayerIndex >= this.numLayers) {
            msg.append(MessageFormat.format("invalid input 0-based layer index: ''{0}'' (should be >= 0 and < {1})", this._inputLayerIndex, this.numLayers));
            return false;
        }
        if (this._outputLayerIndex < 0 || this._outputLayerIndex >= this.numLayers) {
            msg.append(MessageFormat.format("invalid output 0-based layer index: ''{0}'' (should be >= 0 and < {1})", this._outputLayerIndex, this.numLayers));
            return false;
        }
        for (int i = 0; i < this.layers.length; ++i) {
            if (this.layers[i] != null) {
                if (this.layers[i].initFunctions(optimizing, msg)) continue;
                return false;
            }
            msg.append(MessageFormat.format("no layer defined at 0-based index: ''{0}''", i));
            return false;
        }
        return true;
    }

    private boolean initConnections(StringBuffer msg) {
        JnnLayer[] arr$ = this.layers;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            JnnLayer layer;
            JnnLayer currentLayer = layer = arr$[i$];
            for (int j = 0; j < currentLayer.getNumUnits(); ++j) {
                JnnUnit currentUnit = currentLayer.getUnitAt(j);
                for (int k = 0; k < currentUnit.getNumConnections(); ++k) {
                    JnnConnection currentConnection = currentUnit.getConnectionAt(k);
                    int layerIndex = currentConnection.getSourceLayerIndex();
                    if (layerIndex < 0 || layerIndex >= this.numLayers) {
                        msg.append(MessageFormat.format("invalid 0-based connection source layer index: ''{0}''", layerIndex));
                        return false;
                    }
                    JnnLayer testLayer = this.layers[layerIndex];
                    int unitIndex = currentConnection.getSourceUnitIndex();
                    if (unitIndex < 0 || unitIndex >= testLayer.getNumUnits()) {
                        msg.append(MessageFormat.format("invalid 0-based connection source unit index: ''{0}''", unitIndex));
                        return false;
                    }
                    JnnUnit testUnit = testLayer.getUnitAt(unitIndex);
                    if (testUnit == null) {
                        msg.append(MessageFormat.format("invalid 0-based connection source unit index: ''{0}''", unitIndex));
                        return false;
                    }
                    currentConnection.setInputUnit(testUnit);
                }
            }
        }
        return true;
    }
}

