/*
 * Decompiled with CFR 0.152.
 */
package com.bc.jnn;

import com.bc.jnn.JnnUnit;
import com.bc.jnn.func.IActivationFunction;
import com.bc.jnn.func.IInputFunction;
import com.bc.jnn.func.IOutputFunction;
import com.bc.jnn.func.JnnFunctionFactory;
import java.text.MessageFormat;

public final class JnnLayer
implements Cloneable {
    private int numUnits = 1;
    private int inpFuncID = 40;
    private int actFuncID = 20;
    private int outFuncID = 1;
    private double[] actParams = new double[2];
    private JnnUnit[] units;
    private IInputFunction inpFunction;
    private IActivationFunction actFunction;
    private IOutputFunction outFunction;

    public JnnLayer() {
        this.actParams[0] = 0.0;
        this.actParams[1] = 1.0;
    }

    public int getNumUnits() {
        return this.numUnits;
    }

    public void setNumUnits(int numUnits) {
        this.units = new JnnUnit[numUnits];
        this.numUnits = numUnits;
    }

    public void setUnitAt(int index, JnnUnit unit) {
        this.units[index] = unit;
    }

    public JnnUnit getUnitAt(int index) {
        return this.units[index];
    }

    public int getInputFunction() {
        return this.inpFuncID;
    }

    public void setInputFunction(int inpFunc) {
        this.inpFuncID = inpFunc;
    }

    public int getActivationFunction() {
        return this.actFuncID;
    }

    public void setActivationFunction(int actFunc) {
        this.actFuncID = actFunc;
    }

    public int getOutputFunction() {
        return this.outFuncID;
    }

    public void setOutputFunction(int outFunc) {
        this.outFuncID = outFunc;
    }

    public double getActivationThreshold() {
        return this.actParams[0];
    }

    public void setActivationThreshold(double thresh) {
        this.actParams[0] = thresh;
    }

    public double getActivationSlope() {
        return this.actParams[1];
    }

    public void setActivationSlope(double slope) {
        this.actParams[1] = slope;
    }

    public boolean initFunctions() {
        return this.initFunctions(false, new StringBuffer());
    }

    public boolean initFunctions(boolean optimizing, StringBuffer msg) {
        if (this.numUnits < 1) {
            msg.append("Invalid number of units: '" + this.numUnits + "' (should be > 0)");
            return false;
        }
        if (this.units == null) {
            msg.append("No units defined");
            return false;
        }
        switch (this.inpFuncID) {
            case 0: 
            case 40: 
            case 41: {
                this.inpFunction = JnnFunctionFactory.getInputFunction(this.inpFuncID, optimizing);
                break;
            }
            default: {
                msg.append("Invalid input function ID '" + this.inpFuncID + "'");
                return false;
            }
        }
        switch (this.actFuncID) {
            case 1: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 30: 
            case 31: {
                this.actFunction = JnnFunctionFactory.getActivationFunction(this.actFuncID, optimizing);
                this.actFunction.setParameter(this.actParams);
                break;
            }
            default: {
                msg.append("Invalid activation function ID '" + this.actFuncID + "'");
                return false;
            }
        }
        switch (this.outFuncID) {
            case 1: 
            case 11: 
            case 13: 
            case 14: {
                this.outFunction = JnnFunctionFactory.getOutputFunction(this.outFuncID, optimizing);
                break;
            }
            default: {
                msg.append(MessageFormat.format("Invalid output function ID ''{0}''", this.outFuncID));
                return false;
            }
        }
        for (int i = 0; i < this.units.length; ++i) {
            if (this.units[i] != null) {
                if (this.units[i].verifyIntegrity(msg)) continue;
                return false;
            }
            msg.append(MessageFormat.format("No unit at 0-based index: ''{0}''", i));
            return false;
        }
        return true;
    }

    public void calcInputFunction() {
        for (int i = 0; i < this.numUnits; ++i) {
            this.inpFunction.evaluate(this.units[i]);
        }
    }

    public void calcActivationFunction() {
        for (int i = 0; i < this.numUnits; ++i) {
            this.actFunction.evaluate(this.units[i]);
        }
    }

    public void calcOutputFunction() {
        for (int i = 0; i < this.numUnits; ++i) {
            this.outFunction.evaluate(this.units[i]);
        }
    }

    public void setInputData(double[] input) {
        if (input.length != this.numUnits) {
            throw new IllegalArgumentException(MessageFormat.format("Invalid number of input data ''{0}'' expected ''{1}''", input.length, this.numUnits));
        }
        for (int i = 0; i < this.numUnits; ++i) {
            double temp = this.units[i].getInput();
            this.units[i].setInput(temp += input[i]);
        }
    }

    public double[] getOutputData(double[] out) {
        if (out.length != this.numUnits) {
            throw new IllegalArgumentException(MessageFormat.format("Invalid number of output data ''{0}'' expected ''{1}''", out.length, this.numUnits));
        }
        for (int i = 0; i < this.numUnits; ++i) {
            out[i] = this.units[i].getOutput();
        }
        return out;
    }

    public JnnLayer clone() {
        try {
            JnnLayer clonedLayer = (JnnLayer)super.clone();
            JnnUnit[] clonedUnits = (JnnUnit[])this.units.clone();
            for (int i = 0; i < clonedUnits.length; ++i) {
                clonedUnits[i] = clonedUnits[i].clone();
            }
            clonedLayer.units = clonedUnits;
            clonedLayer.actParams = (double[])this.actParams.clone();
            return clonedLayer;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }
}

