/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.interactions;

import com.bc.ceres.grender.Viewport;
import com.bc.ceres.swing.figure.ViewportInteractor;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class ZoomInteractor
extends ViewportInteractor {
    private int viewportX;
    private int viewportY;
    private Graphics graphics;
    private final Rectangle zoomRect = new Rectangle();

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(1);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.viewportX = event.getX();
        this.viewportY = event.getY();
        this.setZoomRect(event);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.graphics = event.getComponent().getGraphics();
        this.graphics.setXORMode(Color.white);
        if (!this.zoomRect.isEmpty()) {
            this.drawZoomRect();
        }
        this.setZoomRect(event);
        this.drawZoomRect();
        this.graphics.setPaintMode();
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.graphics == null) {
            return;
        }
        Viewport viewport = this.getViewport(event);
        if (!this.zoomRect.isEmpty()) {
            AffineTransform v2m = viewport.getViewToModelTransform();
            Shape transformedShape = v2m.createTransformedShape(this.zoomRect);
            Rectangle2D bounds2D = transformedShape.getBounds2D();
            viewport.zoom(bounds2D);
        } else {
            boolean zoomOut = event.isControlDown() || event.getButton() != 1;
            double viewScaleOld = viewport.getZoomFactor();
            double viewScaleNew = zoomOut ? viewScaleOld / 1.6 : viewScaleOld * 1.6;
            viewport.setZoomFactor(viewScaleNew);
        }
        this.graphics.dispose();
        this.graphics = null;
        this.zoomRect.setBounds(0, 0, 0, 0);
    }

    private void setZoomRect(MouseEvent e) {
        int x = this.viewportX;
        int y = this.viewportY;
        int w = e.getX() - x;
        int h = e.getY() - y;
        if (w < 0) {
            w = -w;
            x -= w;
        }
        if (h < 0) {
            h = -h;
            y -= h;
        }
        this.zoomRect.setBounds(x, y, w, h);
    }

    private void drawZoomRect() {
        this.graphics.drawRect(this.zoomRect.x, this.zoomRect.y, this.zoomRect.width, this.zoomRect.height);
    }
}

