/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover.dataio.glc2000;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.engine_utilities.util.Settings;
import org.esa.snap.landcover.dataio.AbstractLandCoverModelDescriptor;
import org.esa.snap.landcover.dataio.FileLandCoverModel;
import org.esa.snap.landcover.dataio.LandCoverModel;

public class GLC2000ModelDescriptor
extends AbstractLandCoverModelDescriptor {
    public static final String NAME = "GLC2000";
    private static final File INSTALL_DIR = new File(Settings.instance().getAuxDataFolder().getAbsolutePath(), "LandCover" + File.separator + "GLC2000");
    private static final File file = new File(INSTALL_DIR, "glc2000_v1_1.zip");

    public GLC2000ModelDescriptor() {
        this.remotePath = "http://step.esa.int/auxdata/landcover/glc2000/";
        this.name = NAME;
        this.installDir = INSTALL_DIR;
        this.NO_DATA_VALUE = 23.0;
        Path moduleBasePath = ResourceInstaller.findModuleCodeBasePath(this.getClass());
        this.colourIndexFile = moduleBasePath.resolve("org/esa/snap/landcover/auxdata/glc2000/glc2000_index.col");
    }

    @Override
    public LandCoverModel createLandCoverModel(Resampling resampling) throws IOException {
        return new FileLandCoverModel(this, new File[]{file}, resampling);
    }

    @Override
    public String createTileFilename(int minLat, int minLon) {
        return file.getName();
    }

    @Override
    public boolean isInstalled() {
        return true;
    }
}

