/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover.dataio;

import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.util.CachingObjectArray;
import org.esa.snap.engine_utilities.datamodel.DownloadableContentImpl;
import org.esa.snap.engine_utilities.datamodel.DownloadableFile;
import org.esa.snap.landcover.dataio.BaseLandCoverTile;
import org.esa.snap.landcover.dataio.LandCoverModel;

class FileLandCoverTile
extends DownloadableContentImpl
implements Resampling.Raster {
    private CachingObjectArray linesCache;
    private Product product = null;
    private static final int maxLines = 500;
    private final List<Integer> indexList = new ArrayList<Integer>(500);
    private final GeoCoding tileGeocoding;
    private final int width;
    private final int height;
    private Double noDataValue;
    private final LandCoverModel model;
    private final ProductReader reader;

    public FileLandCoverTile(LandCoverModel model, File localFile, ProductReader reader) throws IOException {
        this(model, localFile, reader, ".zip");
    }

    public FileLandCoverTile(LandCoverModel model, File localFile, ProductReader reader, String archiveExt) throws IOException {
        super(localFile, model.getDescriptor().getArchiveUrl(), archiveExt);
        this.model = model;
        this.reader = reader;
        this.noDataValue = model.getDescriptor().getNoDataValue();
        DownloadableFile downloadableFile = this.getContentFile();
        if (downloadableFile != null && this.product != null) {
            this.width = this.product.getBandAt(0).getRasterWidth();
            this.height = this.product.getBandAt(0).getRasterHeight();
            this.tileGeocoding = this.product.getSceneGeoCoding();
            if (this.noDataValue == 0.0) {
                this.noDataValue = this.product.getBandAt(0).getNoDataValue();
            }
            this.linesCache = new CachingObjectArray(this.getLineFactory());
            this.linesCache.setCachedRange(0, this.product.getBandAt(0).getRasterHeight());
        } else {
            this.tileGeocoding = null;
            this.width = 0;
            this.height = 0;
        }
    }

    protected DownloadableFile createContentFile(File file) {
        try {
            this.product = this.reader.readProductNodes((Object)file, null);
            return new BaseLandCoverTile(this.model, this.product);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public GeoCoding getTileGeocoding() {
        return this.tileGeocoding;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public double getNoDataValue() {
        return this.noDataValue;
    }

    public void dispose() {
        this.clearCache();
        this.linesCache = null;
        if (this.product != null) {
            this.product.dispose();
            this.product = null;
        }
    }

    public void clearCache() {
        this.linesCache.clear();
    }

    private CachingObjectArray.ObjectFactory getLineFactory() {
        final Band band = this.product.getBandAt(0);
        final int width = this.product.getSceneRasterWidth();
        return new CachingObjectArray.ObjectFactory(){

            public Object createObject(int index) throws Exception {
                FileLandCoverTile.this.updateCache(index);
                return band.getSourceImage().getData(new Rectangle(0, index, width, 1)).getPixels(0, index, width, 1, new float[width]);
            }
        };
    }

    private void updateCache(int index) {
        this.indexList.remove((Object)index);
        this.indexList.add(0, index);
        if (this.indexList.size() > 500) {
            int i = this.indexList.size() - 1;
            this.linesCache.setObject(i, null);
            this.indexList.remove(i);
        }
    }

    public boolean getSamples(int[] x, int[] y, double[][] samples) throws Exception {
        boolean allValid = true;
        for (int i = 0; i < y.length; ++i) {
            float[] line = (float[])this.linesCache.getObject(y[i]);
            for (int j = 0; j < x.length; ++j) {
                samples[i][j] = line[x[j]];
                if (!this.noDataValue.equals(samples[i][j])) continue;
                samples[i][j] = Double.NaN;
                allValid = false;
            }
        }
        return allValid;
    }
}

