/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover.dataio;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.landcover.dataio.FileLandCoverTile;
import org.esa.snap.landcover.dataio.LandCoverModel;
import org.esa.snap.landcover.dataio.LandCoverModelDescriptor;

public class FileLandCoverModel
implements LandCoverModel {
    protected final Resampling resampling;
    protected final Resampling.Index resamplingIndex;
    protected final File[] fileList;
    private final String archiveExt;
    protected final LandCoverModelDescriptor descriptor;
    protected FileLandCoverTile[] tileList = null;
    protected static final ProductReaderPlugIn productReaderPlugIn = FileLandCoverModel.getReaderPlugIn("GeoTIFF");

    public FileLandCoverModel(LandCoverModelDescriptor descriptor, File[] files, Resampling resamplingMethod) throws IOException {
        this(descriptor, files, resamplingMethod, ".zip");
    }

    public FileLandCoverModel(LandCoverModelDescriptor descriptor, File[] files, Resampling resamplingMethod, String archiveExt) throws IOException {
        this.descriptor = descriptor;
        this.resampling = resamplingMethod;
        this.resamplingIndex = this.resampling.createIndex();
        this.fileList = files;
        this.archiveExt = archiveExt;
    }

    @Override
    public void dispose() {
        for (FileLandCoverTile tile : this.tileList) {
            if (tile == null) continue;
            tile.dispose();
        }
    }

    @Override
    public LandCoverModelDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Resampling getResampling() {
        return this.resampling;
    }

    @Override
    public synchronized double getLandCover(GeoPos geoPos) throws Exception {
        try {
            if (this.tileList == null) {
                this.loadProducts();
            }
            for (FileLandCoverTile tile : this.tileList) {
                PixelPos pix;
                if (tile.getTileGeocoding() == null || !(pix = tile.getTileGeocoding().getPixelPos(geoPos, null)).isValid() || pix.x < 0.0 || pix.y < 0.0 || pix.x >= (double)tile.getWidth() || pix.y >= (double)tile.getHeight()) continue;
                this.resampling.computeIndex(pix.x, pix.y, tile.getWidth(), tile.getHeight(), this.resamplingIndex);
                double value = this.resampling.resample((Resampling.Raster)tile, this.resamplingIndex);
                if (Double.isNaN(value)) {
                    return tile.getNoDataValue();
                }
                return value;
            }
            return this.tileList[0].getNoDataValue();
        }
        catch (Exception e) {
            throw new Exception("Problem reading : " + e.getMessage());
        }
    }

    private void loadProducts() throws Exception {
        this.tileList = new FileLandCoverTile[this.fileList.length];
        for (int i = 0; i < this.fileList.length; ++i) {
            try {
                String ext = FileUtils.getExtension((File)this.fileList[i]).toLowerCase();
                if (ext != null && ext.contains("tif") || ext.contains("zip")) {
                    this.tileList[i] = new FileLandCoverTile(this, this.fileList[i], productReaderPlugIn.createReaderInstance(), this.archiveExt);
                    continue;
                }
                ProductReader reader = ProductIO.getProductReaderForInput((Object)this.fileList[i]);
                this.tileList[i] = new FileLandCoverTile(this, this.fileList[i], reader, this.archiveExt);
                continue;
            }
            catch (IOException e) {
                this.tileList[i] = null;
            }
        }
    }

    @Override
    public PixelPos getIndex(GeoPos geoPos) {
        return null;
    }

    @Override
    public GeoPos getGeoPos(PixelPos pixelPos) {
        return null;
    }

    @Override
    public float getSample(double pixelX, double pixelY) throws IOException {
        return 0.0f;
    }

    @Override
    public boolean getSamples(int[] x, int[] y, double[][] samples) throws IOException {
        return false;
    }

    protected static ProductReaderPlugIn getReaderPlugIn(String formatName) {
        Iterator readerPlugIns = ProductIOPlugInManager.getInstance().getReaderPlugIns(formatName);
        return (ProductReaderPlugIn)readerPlugIns.next();
    }
}

