/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover.dataio.AAFC;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.engine_utilities.util.Settings;
import org.esa.snap.landcover.dataio.AbstractLandCoverModelDescriptor;
import org.esa.snap.landcover.dataio.FileLandCoverModel;
import org.esa.snap.landcover.dataio.LandCoverModel;

public class AAFCSandHRModelDescriptor
extends AbstractLandCoverModelDescriptor {
    public static final String NAME = "AAFC Canada Sand Pct";
    private static final File INSTALL_DIR = new File(Settings.instance().getAuxDataFolder().getAbsolutePath(), "LandCover" + File.separator + "AAFC");
    private static final File file = new File(INSTALL_DIR, "AAFC_Canada_SAND_HR_pct.zip");

    public AAFCSandHRModelDescriptor() {
        this.remotePath = "http://step.esa.int/auxdata/landcover/AAFC/";
        this.name = NAME;
        this.installDir = INSTALL_DIR;
        this.metadataFileName = "soil_landscapes_canada_readme.txt";
        Path moduleBasePath = ResourceInstaller.findModuleCodeBasePath(this.getClass());
        this.metadataSrcPath = moduleBasePath.resolve("org/esa/snap/landcover/auxdata/aafc/soil_landscapes_canada/");
        this.NO_DATA_VALUE = -9999.0;
    }

    @Override
    public LandCoverModel createLandCoverModel(Resampling resampling) throws IOException {
        return new FileLandCoverModel(this, new File[]{file}, resampling);
    }

    @Override
    public String createTileFilename(int minLat, int minLon) {
        return file.getName();
    }

    @Override
    public int getDataType() {
        return 30;
    }
}

