/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.raster.rcp.actions;

import java.awt.event.ActionEvent;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.graphbuilder.rcp.dialogs.PromptDialog;
import org.esa.snap.raster.rcp.actions.Bundle;
import org.esa.snap.raster.rcp.actions.SearchMetadataAction;
import org.esa.snap.rcp.util.Dialogs;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class SearchMetadataValueAction
extends AbstractAction
implements ContextAwareAction,
LookupListener {
    private final Lookup lkp;
    private Product product;

    public SearchMetadataValueAction() {
        this(Utilities.actionsGlobalContext());
    }

    public SearchMetadataValueAction(Lookup lkp) {
        super(Bundle.CTL_SearchMetadataValueAction_MenuText());
        this.lkp = lkp;
        Lookup.Result lkpContext = lkp.lookupResult(ProductNode.class);
        lkpContext.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)lkpContext));
        this.setEnableState();
        this.putValue("ShortDescription", Bundle.CTL_SearchMetadataValueAction_ShortDescription());
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new SearchMetadataValueAction(actionContext);
    }

    public void resultChanged(LookupEvent ev) {
        this.setEnableState();
    }

    private void setEnableState() {
        ProductNode productNode = (ProductNode)this.lkp.lookup(ProductNode.class);
        boolean state = false;
        if (productNode != null) {
            this.product = productNode.getProduct();
            state = this.product.getMetadataRoot() != null;
        }
        this.setEnabled(state);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        PromptDialog dlg = new PromptDialog("Search Metadata", "Value", "", false);
        dlg.show();
        if (dlg.IsOK()) {
            String value = dlg.getValue().toUpperCase();
            MetadataElement resultElem = new MetadataElement("Search result (" + dlg.getValue() + ')');
            boolean isModified = this.product.isModified();
            MetadataElement root = this.product.getMetadataRoot();
            resultElem.setOwner((ProductNode)this.product);
            SearchMetadataValueAction.searchMetadataValue(resultElem, root, value);
            this.product.setModified(isModified);
            if (resultElem.getNumElements() > 0 || resultElem.getNumAttributes() > 0) {
                SearchMetadataAction.openMetadataWindow(resultElem);
            } else {
                Dialogs.showError((String)"Search Metadata", (String)(dlg.getValue() + " not found in the Metadata"));
            }
        }
    }

    private static void searchMetadataValue(MetadataElement resultElem, MetadataElement elem, String value) {
        MetadataAttribute[] attribList;
        MetadataElement[] elemList;
        for (MetadataElement e : elemList = elem.getElements()) {
            SearchMetadataValueAction.searchMetadataValue(resultElem, e, value);
        }
        for (MetadataAttribute attrib : attribList = elem.getAttributes()) {
            if (!attrib.getData().getElemString().toUpperCase().contains(value)) continue;
            MetadataAttribute newAttrib = attrib.createDeepClone();
            newAttrib.setDescription(SearchMetadataAction.getAttributePath(attrib));
            resultElem.addAttribute(newAttrib);
        }
    }
}

