/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.raster.gpf.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUIUtils;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.ui.AppContext;

public class CreateLandMaskOpUI
extends BaseOperatorUI {
    private final JList bandList = new JList();
    private final JComboBox<String> geometries = new JComboBox();
    private final JRadioButton landMask = new JRadioButton("Mask out the Land");
    private final JRadioButton seaMask = new JRadioButton("Mask out the Sea");
    private final JCheckBox useSRTMCheckBox = new JCheckBox("Use SRTM 3sec");
    private final JRadioButton geometryMask = new JRadioButton("Use Vector as Mask");
    private final JCheckBox invertGeometryCheckBox = new JCheckBox("Invert Vector");
    private final JTextField shorelineExtensionTextField = new JTextField();
    private boolean invertGeometry = false;
    private boolean useSRTM = true;

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        this.useSRTMCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CreateLandMaskOpUI.this.useSRTM = e.getStateChange() == 1;
            }
        });
        this.invertGeometryCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CreateLandMaskOpUI.this.invertGeometry = e.getStateChange() == 1;
            }
        });
        RadioListener myListener = new RadioListener();
        this.landMask.addActionListener(myListener);
        this.seaMask.addActionListener(myListener);
        this.geometryMask.addActionListener(myListener);
        return new JScrollPane(panel);
    }

    public void initParameters() {
        String[] geometryNames;
        OperatorUIUtils.initParamList((JList)this.bandList, (String[])this.getBandNames());
        Boolean doLandMask = (Boolean)this.paramMap.get("landMask");
        if (doLandMask != null && doLandMask.booleanValue()) {
            this.landMask.setSelected(true);
        } else {
            this.seaMask.setSelected(true);
        }
        this.geometries.removeAllItems();
        for (String g : geometryNames = this.getGeometries()) {
            this.geometries.addItem(g);
        }
        String selectedGeometry = (String)this.paramMap.get("geometry");
        if (selectedGeometry != null) {
            this.geometryMask.setSelected(true);
            this.geometries.setSelectedItem(selectedGeometry);
        }
        this.useSRTM = (Boolean)this.paramMap.get("useSRTM");
        this.useSRTMCheckBox.setSelected(this.useSRTM);
        Integer shorelineExtension = (Integer)this.paramMap.get("shorelineExtension");
        this.shorelineExtensionTextField.setText(shorelineExtension == null ? "0" : shorelineExtension.toString());
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        OperatorUIUtils.updateParamList((JList)this.bandList, (Map)this.paramMap, (String)"sourceBandNames");
        this.paramMap.put("landMask", this.landMask.isSelected());
        if (this.geometryMask.isSelected()) {
            this.paramMap.put("geometry", this.geometries.getSelectedItem());
            this.paramMap.put("invertGeometry", this.invertGeometry);
        }
        Integer shorelineExtension = 0;
        try {
            shorelineExtension = Integer.parseInt(this.shorelineExtensionTextField.getText());
        }
        catch (Exception e) {
            shorelineExtension = 0;
        }
        this.paramMap.put("shorelineExtension", shorelineExtension);
        this.paramMap.put("useSRTM", this.useSRTM);
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Source Bands:", (JComponent)new JScrollPane(this.bandList));
        gbc.fill = 2;
        gbc.gridx = 0;
        ++gbc.gridy;
        contentPane.add((Component)this.landMask, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.seaMask, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.useSRTMCheckBox, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.geometryMask, gbc);
        ++gbc.gridy;
        gbc.gridx = 1;
        contentPane.add(this.geometries, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.invertGeometryCheckBox, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Extend shoreline by [pixels]:", (JComponent)this.shorelineExtensionTextField);
        ButtonGroup group = new ButtonGroup();
        group.add(this.landMask);
        group.add(this.seaMask);
        group.add(this.geometryMask);
        this.geometries.setEnabled(false);
        this.invertGeometryCheckBox.setEnabled(false);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }

    private class RadioListener
    implements ActionListener {
        private RadioListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean b = CreateLandMaskOpUI.this.geometryMask.isSelected();
            CreateLandMaskOpUI.this.geometries.setEnabled(b);
            CreateLandMaskOpUI.this.invertGeometryCheckBox.setEnabled(b);
        }
    }
}

