/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.math;

import org.esa.snap.core.util.math.Array;
import org.esa.snap.core.util.math.FracIndex;
import org.esa.snap.core.util.math.IntervalPartition;
import org.esa.snap.core.util.math.LookupTable;

public class VectorLookupTable {
    private final Array values;
    private final IntervalPartition[] dimensions;
    private final int[] strides;
    private final int[] o;
    private final double[][] v;
    private final FracIndex[] fracIndexes;

    public VectorLookupTable(int length, double[] values, IntervalPartition ... dimensions) {
        this(length, new Array.Double(values), dimensions);
    }

    public VectorLookupTable(int length, float[] values, IntervalPartition ... dimensions) {
        this(length, new Array.Float(values), dimensions);
    }

    public VectorLookupTable(int length, double[] values, double[] ... dimensions) {
        this(length, values, IntervalPartition.createArray(dimensions));
    }

    public VectorLookupTable(int length, float[] values, float[] ... dimensions) {
        this(length, values, IntervalPartition.createArray(dimensions));
    }

    VectorLookupTable(int length, Array values, IntervalPartition ... dimensions) {
        if (length < 1) {
            throw new IllegalArgumentException("length < 1");
        }
        LookupTable.ensureLegalArray(dimensions);
        LookupTable.ensureLegalArray(values, length * LookupTable.getVertexCount(dimensions));
        this.values = values;
        this.dimensions = dimensions;
        int n = dimensions.length;
        this.strides = new int[n];
        int i = n;
        int stride = length;
        while (i-- > 0) {
            this.strides[i] = stride;
            stride *= dimensions[i].getCardinal();
        }
        this.o = new int[1 << n];
        LookupTable.computeVertexOffsets(this.strides, this.o);
        this.v = new double[1 << n][length];
        this.fracIndexes = FracIndex.createArray(n);
    }

    public final int getDimensionCount() {
        return this.dimensions.length;
    }

    public final IntervalPartition[] getDimensions() {
        return this.dimensions;
    }

    public final IntervalPartition getDimension(int i) {
        return this.dimensions[i];
    }

    public final double[] getValues(double ... coordinates) throws IllegalArgumentException {
        LookupTable.ensureLegalArray(coordinates, this.dimensions.length);
        for (int i = 0; i < this.dimensions.length; ++i) {
            LookupTable.computeFracIndex(this.dimensions[i], coordinates[i], this.fracIndexes[i]);
        }
        return this.getValues(this.fracIndexes);
    }

    double[] getValues(FracIndex ... fracIndexes) {
        int i;
        int origin = 0;
        for (i = 0; i < this.dimensions.length; ++i) {
            origin += fracIndexes[i].i * this.strides[i];
        }
        for (i = 0; i < this.v.length; ++i) {
            this.values.copyTo(origin + this.o[i], this.v[i], 0, this.v[i].length);
        }
        i = this.dimensions.length;
        while (i-- > 0) {
            int m = 1 << i;
            double f = fracIndexes[i].f;
            for (int j = 0; j < m; ++j) {
                for (int k = 0; k < this.v[j].length; ++k) {
                    double[] dArray = this.v[j];
                    int n = k;
                    dArray[n] = dArray[n] + f * (this.v[m + j][k] - this.v[j][k]);
                }
            }
        }
        return this.v[0];
    }
}

