/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.io;

import com.bc.ceres.core.Assert;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.StringUtils;

public class FileUtils {
    public static String getExtension(File file) {
        Guardian.assertNotNull("file", file);
        return FileUtils.getExtension(file.getPath());
    }

    public static String getExtension(String path) {
        Guardian.assertNotNull("path", path);
        int index = FileUtils.getExtensionDotPos(path);
        if (index <= 0) {
            return null;
        }
        return path.substring(index);
    }

    public static String getFilenameWithoutExtension(File file) {
        return FileUtils.getFilenameWithoutExtension(file.getName());
    }

    public static String getFilenameWithoutExtension(String fileName) {
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            return fileName.substring(0, i);
        }
        return fileName;
    }

    public static String exchangeExtension(String path, String extension) {
        Guardian.assertNotNullOrEmpty("path", path);
        Guardian.assertNotNull("extension", extension);
        if (extension.length() > 0 && path.endsWith(extension)) {
            return path;
        }
        int extensionDotPos = FileUtils.getExtensionDotPos(path);
        if (extensionDotPos > 0) {
            return path.substring(0, extensionDotPos) + extension;
        }
        return path + extension;
    }

    public static File exchangeExtension(File file, String extension) {
        Guardian.assertNotNull("file", file);
        String path = file.getPath();
        if (path.endsWith(extension)) {
            return file;
        }
        return new File(FileUtils.exchangeExtension(path, extension));
    }

    public static String ensureExtension(String path, String extension) {
        Guardian.assertNotNullOrEmpty("path", path);
        Guardian.assertNotNullOrEmpty("extension", extension);
        if (path.endsWith(extension)) {
            return path;
        }
        if (path.length() > 1 && path.endsWith(".")) {
            path = path.substring(0, path.length() - 1);
        }
        return path + extension;
    }

    public static File ensureExtension(File file, String extension) {
        Guardian.assertNotNull("file", file);
        String path = file.getPath();
        if (path.endsWith(extension)) {
            return file;
        }
        return new File(FileUtils.ensureExtension(path, extension));
    }

    public static int getExtensionDotPos(String path) {
        Guardian.assertNotNullOrEmpty("path", path);
        int extensionDotPos = path.lastIndexOf(46);
        if (extensionDotPos > 0) {
            int lastSeparatorPos = path.lastIndexOf(47);
            lastSeparatorPos = Math.max(lastSeparatorPos, path.lastIndexOf(92));
            if ((lastSeparatorPos = Math.max(lastSeparatorPos, path.lastIndexOf(58))) < extensionDotPos - 1) {
                return extensionDotPos;
            }
        }
        return -1;
    }

    public static String getFileNameFromPath(String path) {
        Guardian.assertNotNullOrEmpty("path", path);
        int lastChar = path.lastIndexOf(File.separator);
        String fileName = lastChar >= 0 ? path.substring(lastChar + 1, path.length()) : path;
        return fileName;
    }

    public static File[] listFilesWithExtension(File dir, String extension) {
        if (dir == null) {
            return null;
        }
        if (extension != null && extension.length() > 0) {
            return dir.listFiles(FileUtils.createExtensionFilenameFilter(extension));
        }
        return dir.listFiles();
    }

    public static String[] listFilePathsWithExtension(File dir, String extension) {
        if (dir == null) {
            return null;
        }
        if (extension != null && extension.length() > 0) {
            return dir.list(FileUtils.createExtensionFilenameFilter(extension));
        }
        return dir.list();
    }

    public static FilenameFilter createExtensionFilenameFilter(String extension) {
        String extensionLC = extension.toLowerCase();
        return (dir, name) -> name.length() > extensionLC.length() && name.toLowerCase().endsWith(extensionLC);
    }

    public static String createValidFilename(String name) {
        Guardian.assertNotNull("name", name);
        return StringUtils.createValidName(name, new char[]{'_', '-', '.'}, '_');
    }

    public static URL getFileAsUrl(File file) throws MalformedURLException {
        URI uri = file.toURI();
        return uri.toURL();
    }

    public static File getUrlAsFile(URL url) throws URISyntaxException {
        return new File(url.toURI());
    }

    public static String getDisplayText(File file, int maxLength) {
        Assert.notNull((Object)file, (String)"file");
        Assert.argument((maxLength >= 4 ? 1 : 0) != 0, (String)"maxLength >= 4");
        String text = file.getPath();
        if (text.length() <= maxLength) {
            return text;
        }
        while (text.length() + 3 > maxLength) {
            int pos = text.indexOf(File.separator, text.startsWith(File.separator) ? 1 : 0);
            if (pos == -1) {
                return "..." + text.substring(text.length() - maxLength + 3);
            }
            text = text.substring(pos);
        }
        return "..." + text;
    }

    public static String readText(File file) throws IOException {
        try (FileReader reader1 = new FileReader(file);){
            String string = FileUtils.readText(reader1);
            return string;
        }
    }

    public static String readText(Reader reader) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(reader);
        StringBuilder text = new StringBuilder();
        while ((line = br.readLine()) != null) {
            text.append(line);
            text.append("\n");
        }
        return text.toString();
    }

    public static boolean deleteTree(File tree) {
        Guardian.assertNotNull("tree", tree);
        File[] files = tree.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    FileUtils.deleteTree(file);
                    continue;
                }
                file.delete();
            }
        }
        return tree.delete();
    }

    public static URI getRelativeUri(URI rootURI, File file) {
        if (file == null) {
            return null;
        }
        URI uri = file.toURI();
        if (rootURI == null) {
            return uri;
        }
        return rootURI.relativize(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path getPathFromURI(URI uri) throws IOException {
        Class<FileUtils> clazz = FileUtils.class;
        synchronized (FileUtils.class) {
            try {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return Paths.get(uri);
            }
            catch (FileSystemNotFoundException exp) {
                FileSystems.newFileSystem(uri, Collections.emptyMap());
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return Paths.get(uri);
            }
        }
    }

    public static File toFile(Path path) {
        String schemeSpecificPart;
        URI uri = path.toUri();
        if ("jar".equals(uri.getScheme()) && (schemeSpecificPart = uri.getSchemeSpecificPart()) != null && schemeSpecificPart.startsWith("file:")) {
            int pos = schemeSpecificPart.lastIndexOf(33);
            if (pos > 0) {
                String fileUriString;
                if ("/".equals(schemeSpecificPart.substring(pos + 1)) && (fileUriString = schemeSpecificPart.substring(0, pos)).startsWith("file:")) {
                    return new File(URI.create(fileUriString));
                }
            } else {
                return new File(URI.create(schemeSpecificPart));
            }
        }
        return path.toFile();
    }

    public static URI ensureJarURI(URI uri) throws IOException {
        Path basePath = FileUtils.getPathFromURI(uri);
        String baseUri = uri.toString();
        if (baseUri.startsWith("file:") && baseUri.endsWith(".jar") && basePath.toFile().isFile()) {
            uri = URI.create("jar:" + baseUri + "!/");
        }
        return uri;
    }
}

