/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.io;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.ProgressMonitor;
import org.esa.snap.core.util.io.IOUtils;
import org.esa.snap.core.util.io.ObservableInputStream;
import org.esa.snap.core.util.io.ProgressMonitorInputStreamObserver;

public class FileDownloader {
    public static File downloadFile(URL fileUrl, File targetDir, Component parentComponent) throws IOException {
        BufferedOutputStream os;
        File outputFile = new File(targetDir, new File(fileUrl.getFile()).getName());
        URLConnection urlConnection = fileUrl.openConnection();
        int contentLength = urlConnection.getContentLength();
        String message = "Downloading data from " + fileUrl + " to " + outputFile;
        ProgressMonitor progressMonitor = new ProgressMonitor(parentComponent, message, "", 0, 100);
        BufferedInputStream is = new BufferedInputStream(new ObservableInputStream(urlConnection.getInputStream(), contentLength, new ProgressMonitorInputStreamObserver(progressMonitor)));
        try {
            os = new BufferedOutputStream(new FileOutputStream(outputFile));
        }
        catch (IOException e) {
            ((InputStream)is).close();
            throw e;
        }
        try {
            IOUtils.copyBytesAndClose(is, os);
        }
        catch (IOException e) {
            outputFile.delete();
            throw e;
        }
        finally {
            progressMonitor.close();
        }
        return outputFile;
    }
}

