/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import com.bc.ceres.core.Assert;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import org.esa.snap.core.util.AbstractPropertyMap;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.ObjectUtils;

public class DefaultPropertyMap
extends AbstractPropertyMap {
    private final Properties properties;
    private PropertyChangeSupport propertyChangeSupport;

    public DefaultPropertyMap() {
        this(null);
    }

    public DefaultPropertyMap(Properties properties) {
        this.properties = properties != null ? properties : new Properties();
    }

    @Override
    public void load(Path file) throws IOException {
        Guardian.assertNotNull("file", file);
        try (BufferedReader reader = Files.newBufferedReader(file);){
            this.getProperties().load(reader);
        }
    }

    @Override
    public void store(Path file, String header) throws IOException {
        Guardian.assertNotNull("file", file);
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            this.getProperties().store(writer, header);
        }
        ArrayList<String> lines = new ArrayList<String>(Files.readAllLines(file));
        Collections.sort(lines);
        Files.write(file, lines, new OpenOption[0]);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public Set<String> getPropertyKeys() {
        return this.properties.stringPropertyNames();
    }

    @Override
    protected String get(String key) {
        Assert.notNull((Object)key, (String)"key");
        return this.properties.getProperty(key);
    }

    @Override
    protected String get(String key, String defaultValue) {
        Assert.notNull((Object)key, (String)"key");
        return this.properties.getProperty(key, defaultValue);
    }

    @Override
    protected String set(String key, String value) {
        Assert.notNull((Object)key, (String)"key");
        String oldValue = this.properties.getProperty(key);
        if (value != null) {
            this.properties.put(key, value);
        } else {
            this.properties.remove(key);
        }
        if (!ObjectUtils.equalObjects(value, oldValue)) {
            this.firePropertyChange(key, value, oldValue);
        }
        return oldValue;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.addPropertyChangeListener(null, listener);
    }

    @Override
    public void addPropertyChangeListener(String key, PropertyChangeListener listener) {
        if (listener != null) {
            if (this.propertyChangeSupport == null) {
                this.propertyChangeSupport = new PropertyChangeSupport(this);
            }
            if (key == null) {
                this.propertyChangeSupport.addPropertyChangeListener(listener);
            } else {
                this.propertyChangeSupport.addPropertyChangeListener(key, listener);
            }
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.removePropertyChangeListener(null, listener);
    }

    @Override
    public void removePropertyChangeListener(String key, PropertyChangeListener listener) {
        if (listener != null && this.propertyChangeSupport != null) {
            if (key == null) {
                this.propertyChangeSupport.removePropertyChangeListener(listener);
            } else {
                this.propertyChangeSupport.removePropertyChangeListener(key, listener);
            }
        }
    }

    @Override
    protected void firePropertyChange(String key, String oldValue, String newValue) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(key, oldValue, newValue);
        }
    }
}

