/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import java.awt.geom.Rectangle2D;
import javax.measure.quantity.Length;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class AreaCalculator {
    private final GeoCoding gc;
    private double earthRadius;

    public AreaCalculator(GeoCoding gc) {
        this.gc = gc;
        Unit axisUnit = CRS.getEllipsoid((CoordinateReferenceSystem)gc.getMapCRS()).getAxisUnit();
        this.initEarthRadius(gc, (Unit<Length>)axisUnit);
    }

    public double getEarthRadius() {
        return this.earthRadius;
    }

    public double calculatePixelSize(int x, int y) {
        Rectangle2D geoRectangleForPixel = this.createGeoRectangleForPixel(x, y);
        return this.calculateRectangleSize(geoRectangleForPixel);
    }

    public double calculateRectangleSize(Rectangle2D rectangle) {
        double deltaLon = rectangle.getWidth();
        double deltaLat = rectangle.getHeight();
        double centerLat = rectangle.getCenterY();
        double a = this.earthRadius * Math.cos(centerLat * (Math.PI / 180)) * deltaLon * (Math.PI / 180);
        double b = this.earthRadius * deltaLat * (Math.PI / 180);
        return a * b;
    }

    Rectangle2D createGeoRectangleForPixel(int x, int y) {
        Rectangle2D.Double rect = new Rectangle2D.Double();
        GeoPos geoPosUL = this.gc.getGeoPos(new PixelPos(x, y), null);
        GeoPos geoPosLR = this.gc.getGeoPos(new PixelPos(x + 1, y + 1), null);
        rect.setFrameFromDiagonal(geoPosUL.getLon(), geoPosUL.getLat(), geoPosLR.getLon(), geoPosLR.getLat());
        return rect;
    }

    private void initEarthRadius(GeoCoding gc, Unit<Length> axisUnit) {
        this.earthRadius = axisUnit.equals((Object)SI.METER) ? CRS.getEllipsoid((CoordinateReferenceSystem)gc.getMapCRS()).getSemiMajorAxis() * 1.0 : (axisUnit.equals((Object)SI.KILOMETER) ? CRS.getEllipsoid((CoordinateReferenceSystem)gc.getMapCRS()).getSemiMajorAxis() * 1000.0 : 6370997.0);
    }
}

