/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.image;

import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.Interpolation;
import javax.media.jai.operator.BorderDescriptor;
import javax.media.jai.operator.CropDescriptor;
import javax.media.jai.operator.ScaleDescriptor;
import javax.media.jai.operator.TranslateDescriptor;
import org.apache.commons.math3.util.Precision;

public class SourceImageScaler {
    public static MultiLevelImage scaleMultiLevelImage(MultiLevelImage masterImage, MultiLevelImage sourceImage, float[] scalings, float[] offsets, RenderingHints renderingHints, double noDataValue, Interpolation interpolation) {
        ScaledMultiLevelSource multiLevelSource = new ScaledMultiLevelSource(masterImage, sourceImage, scalings, offsets, renderingHints, noDataValue, interpolation);
        return new DefaultMultiLevelImage((MultiLevelSource)multiLevelSource);
    }

    private static class ScaledMultiLevelSource
    extends AbstractMultiLevelSource {
        private final MultiLevelImage sourceImage;
        private final float[] scalings;
        private final RenderingHints renderingHints;
        private final double noDataValue;
        private final float[] offsets;
        private final MultiLevelImage masterImage;
        private Interpolation interpolation;
        private static double EPSILON = 1.0E-12;

        private ScaledMultiLevelSource(MultiLevelImage masterImage, MultiLevelImage sourceImage, float[] scalings, float[] offsets, RenderingHints renderingHints, double noDataValue, Interpolation interpolation) {
            super(masterImage.getModel());
            this.masterImage = masterImage;
            this.sourceImage = sourceImage;
            this.scalings = scalings;
            this.renderingHints = renderingHints;
            this.noDataValue = noDataValue;
            this.offsets = offsets;
            this.interpolation = interpolation;
        }

        protected RenderedImage createImage(int targetLevel) {
            float scaledYOffset;
            int masterWidth = this.masterImage.getImage(targetLevel).getWidth();
            int masterHeight = this.masterImage.getImage(targetLevel).getHeight();
            MultiLevelModel sourceModel = this.sourceImage.getModel();
            MultiLevelModel targetModel = this.getModel();
            double targetScale = targetModel.getScale(targetLevel);
            int sourceLevel = this.findBestSourceLevel(targetScale);
            double sourceScale = sourceModel.getScale(sourceLevel);
            RenderedImage image = this.sourceImage.getImage(sourceLevel);
            float scaleRatio = (float)(sourceScale / targetScale);
            RenderedImage renderedImage = image;
            float xScale = this.scalings[0] * scaleRatio;
            float yScale = this.scalings[1] * scaleRatio;
            if (Precision.compareTo((double)xScale, (double)1.0, (double)EPSILON) != 0 || Precision.compareTo((double)yScale, (double)1.0, (double)EPSILON) != 0) {
                renderedImage = ScaleDescriptor.create((RenderedImage)image, (Float)Float.valueOf(xScale), (Float)Float.valueOf(yScale), (Float)Float.valueOf(0.5f), (Float)Float.valueOf(0.5f), (Interpolation)this.interpolation, (RenderingHints)this.renderingHints);
            }
            float scaledXOffset = this.offsets != null ? (float)((double)this.offsets[0] / targetScale) : 0.0f;
            float f = scaledYOffset = this.offsets != null ? (float)((double)this.offsets[1] / targetScale) : 0.0f;
            if (masterWidth != renderedImage.getWidth() || masterHeight != renderedImage.getHeight() || Precision.compareTo((double)scaledXOffset, (double)0.0, (double)EPSILON) != 0 || Precision.compareTo((double)scaledYOffset, (double)0.0, (double)EPSILON) != 0) {
                int padX = Math.round(scaledXOffset);
                int padY = Math.round(scaledYOffset);
                int borderCorrectorX = scaledXOffset - (float)padX < 0.0f ? 1 : 0;
                int borderCorrectorY = scaledYOffset - (float)padY < 0.0f ? 1 : 0;
                BorderExtenderConstant borderExtender = new BorderExtenderConstant(new double[]{this.noDataValue});
                int rightPadX = Math.max(0, masterWidth - padX - renderedImage.getWidth() + borderCorrectorX);
                int lowerPadY = Math.max(0, masterHeight - padY - renderedImage.getHeight() + borderCorrectorY);
                renderedImage = BorderDescriptor.create((RenderedImage)renderedImage, (Integer)padX, (Integer)rightPadX, (Integer)padY, (Integer)lowerPadY, (BorderExtender)borderExtender, (RenderingHints)this.renderingHints);
            }
            if (Precision.compareTo((double)scaledXOffset, (double)0.0, (double)EPSILON) != 0 || Precision.compareTo((double)scaledYOffset, (double)0.0, (double)EPSILON) != 0) {
                renderedImage = TranslateDescriptor.create((RenderedImage)renderedImage, (Float)Float.valueOf(scaledXOffset), (Float)Float.valueOf(scaledYOffset), null, (RenderingHints)this.renderingHints);
            }
            renderedImage = CropDescriptor.create((RenderedImage)renderedImage, (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(masterWidth), (Float)Float.valueOf(masterHeight), (RenderingHints)this.renderingHints);
            return renderedImage;
        }

        private int findBestSourceLevel(double targetScale) {
            MultiLevelModel sourceModel = this.sourceImage.getModel();
            float optimizedScaling = 0.0f;
            int optimizedSourceLevel = 0;
            boolean initialized = false;
            for (int sourceLevel = 0; sourceLevel < sourceModel.getLevelCount(); ++sourceLevel) {
                double sourceScale = sourceModel.getScale(sourceLevel);
                float scaleRatio = (float)(sourceScale / targetScale);
                if (!initialized) {
                    optimizedScaling = this.scalings[0] * scaleRatio;
                    optimizedSourceLevel = sourceLevel;
                    initialized = true;
                    continue;
                }
                if (!(Math.abs(1.0f - this.scalings[0] * scaleRatio) < Math.abs(1.0f - optimizedScaling))) continue;
                optimizedScaling = this.scalings[0] * scaleRatio;
                optimizedSourceLevel = sourceLevel;
            }
            return optimizedSourceLevel;
        }
    }
}

