/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataop.downloadable;

import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.dataop.downloadable.StatusProgressMonitor;

public class ProgressMonitorList {
    private static ProgressMonitorList _instance = null;
    private List<StatusProgressMonitor> list = new ArrayList<StatusProgressMonitor>();
    private final List<Listener> listenerList = new ArrayList<Listener>();

    public static ProgressMonitorList instance() {
        if (_instance == null) {
            _instance = new ProgressMonitorList();
        }
        return _instance;
    }

    private ProgressMonitorList() {
    }

    public void add(StatusProgressMonitor pm) {
        this.list.add(pm);
        this.fireNotification(Notification.ADD, pm);
    }

    public void remove(StatusProgressMonitor pm) {
        if (this.list.contains(pm)) {
            this.list.remove(pm);
            this.fireNotification(Notification.REMOVE, pm);
        }
    }

    public StatusProgressMonitor[] getList() {
        return this.list.toArray(new StatusProgressMonitor[this.list.size()]);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void addListener(Listener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    private void fireNotification(Notification msg, StatusProgressMonitor pm) {
        for (Listener listener : this.listenerList) {
            listener.notifyMsg(msg, pm);
        }
    }

    public static interface Listener {
        public void notifyMsg(Notification var1, StatusProgressMonitor var2);
    }

    public static enum Notification {
        ADD,
        REMOVE;

    }
}

