/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.TimeCoding;

public class PixelTimeCoding
implements TimeCoding {
    private final int rasterWidth;
    private final double[] timeMJD;
    private final int rasterHeight;

    public PixelTimeCoding(double[] timeMJD, int rasterWidth, int rasterHeight) {
        this.rasterWidth = rasterWidth;
        this.rasterHeight = rasterHeight;
        this.timeMJD = timeMJD;
    }

    @Override
    public double getMJD(PixelPos pixelPos) {
        int index;
        double x = pixelPos.x;
        double y = pixelPos.y;
        if (x < 0.0 || x > (double)this.rasterWidth || y < 0.0 || y > (double)this.rasterHeight) {
            return Double.NaN;
        }
        int indexX = (int)x;
        int indexY = (int)y;
        if (indexX == this.rasterWidth) {
            --indexX;
        }
        if (indexY == this.rasterHeight) {
            --indexY;
        }
        if ((index = this.rasterWidth * indexY + indexX) >= this.timeMJD.length) {
            return Double.NaN;
        }
        return this.timeMJD[index];
    }
}

