/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.ProductVisitor;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.Guardian;

public class IndexCoding
extends SampleCoding {
    public IndexCoding(String name) {
        super(name);
    }

    public MetadataAttribute getIndex(String name) {
        return this.getAttribute(name);
    }

    public String[] getIndexNames() {
        return this.getAttributeNames();
    }

    public MetadataAttribute addIndex(String name, int value, String description) {
        return this.addSample(name, value, description);
    }

    public int getIndexValue(String name) {
        Guardian.assertNotNull("name", name);
        MetadataAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            throw new IllegalArgumentException("index '" + name + "' not found");
        }
        Debug.assertTrue(attribute.getData().isInt());
        Debug.assertTrue(attribute.getData().isScalar());
        return attribute.getData().getElemInt();
    }

    @Override
    public void acceptVisitor(ProductVisitor visitor) {
        Guardian.assertNotNull("visitor", visitor);
        visitor.visit(this);
    }
}

