/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.internal;

import com.bc.ceres.binio.CollectionData;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.internal.AbstractCompound;
import com.bc.ceres.binio.internal.InstanceFactory;
import com.bc.ceres.binio.internal.Segment;

final class FixCompound
extends AbstractCompound {
    FixCompound(DataContext context, CollectionData parent, CompoundType compoundType, long position) {
        this(context, parent, compoundType, new Segment(position, compoundType.getSize()), 0);
    }

    FixCompound(DataContext context, CollectionData parent, CompoundType compoundType, Segment segment, int bufferOffset) {
        super(context, parent, compoundType, segment.getPosition() + (long)bufferOffset);
        for (int i = 0; i < compoundType.getMemberCount(); ++i) {
            Type memberType = compoundType.getMember(i).getType();
            this.setMemberInstance(i, InstanceFactory.createFixMember(context, this, memberType, segment, bufferOffset));
            bufferOffset += memberType.getSize();
        }
    }

    @Override
    public long getSize() {
        return this.getType().getSize();
    }

    @Override
    public boolean isSizeResolved() {
        return true;
    }

    @Override
    public boolean isSizeResolved(int index) {
        return true;
    }

    @Override
    public void resolveSize() {
    }

    @Override
    public void resolveSize(int index) {
    }

    static int getMemberIndexWithinSizeLimit(CompoundType compoundType, long sizeLimit) {
        Type memberType;
        int index = -1;
        int segmentSize = 0;
        int i = 0;
        while (i < compoundType.getMemberCount() && (memberType = compoundType.getMember(i).getType()).isSizeKnown() && (long)(segmentSize + memberType.getSize()) <= sizeLimit) {
            index = i++;
            segmentSize += memberType.getSize();
        }
        return index;
    }

    static boolean isCompoundTypeWithinSizeLimit(CompoundType compoundType, long sizeLimit) {
        return FixCompound.getMemberIndexWithinSizeLimit(compoundType, sizeLimit) == compoundType.getMemberCount() - 1;
    }
}

