/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.expr;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.expr.AbstractExpression;
import com.bc.ceres.binio.expr.Expression;
import com.bc.ceres.binio.internal.SequenceTypeImpl;
import java.io.IOException;

public class SequenceExpr
extends AbstractExpression {
    private final Expression elementType;
    private final Expression elementCount;

    public SequenceExpr(Expression elementType, Expression elementCount) {
        this.elementType = elementType;
        this.elementType.setParent(this);
        this.elementCount = elementCount;
        this.elementCount.setParent(this);
    }

    @Override
    public boolean isConstant() {
        return this.elementType.isConstant() && this.elementCount.isConstant();
    }

    @Override
    public Object evaluate(CompoundData context) throws IOException {
        if (this.elementType.isConstant() && this.elementCount.isConstant() || this.elementType.isConstant() || this.elementCount.isConstant()) {
            // empty if block
        }
        Type elementType = (Type)this.elementType.evaluate(context);
        int elementCount = ((Number)this.elementCount.evaluate(context)).intValue();
        return new SequenceTypeImpl(elementType, elementCount);
    }
}

