/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.expr;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.TypeBuilder;
import com.bc.ceres.binio.expr.AbstractExpression;
import com.bc.ceres.binio.expr.Expression;
import java.io.IOException;

public class CompoundExpr
extends AbstractExpression {
    private final String name;
    private final Member[] members;
    private final boolean constant;

    public CompoundExpr(String name, Member[] members) {
        this.name = name;
        this.members = members;
        for (Member member : members) {
            member.type.setParent(this);
        }
        this.constant = CompoundExpr.isConstant(members);
    }

    @Override
    public boolean isConstant() {
        return this.constant;
    }

    @Override
    public Object evaluate(CompoundData context) throws IOException {
        CompoundMember[] typeMembers = new CompoundMember[this.members.length];
        for (int i = 0; i < this.members.length; ++i) {
            Member member = this.members[i];
            Type memberType = (Type)member.type.evaluate(context);
            typeMembers[i] = TypeBuilder.MEMBER(member.name, memberType);
        }
        return TypeBuilder.COMPOUND(this.name, typeMembers);
    }

    public static boolean isConstant(Member[] members) {
        for (Member member : members) {
            if (member.type.isConstant()) continue;
            return false;
        }
        return true;
    }

    public static class Member {
        private final String name;
        private final Expression type;

        public Member(String name, Expression type) {
            this.name = name;
            this.type = type;
        }
    }
}

