/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.worldwind;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwindx.examples.util.LayerManagerLayer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;

public class LayerPanelLayer
extends LayerManagerLayer {
    private Layer virtualEarthAerialLayer = null;
    private Layer virtualEarthRoadsLayer = null;
    private Layer virtualEarthHybridLayer = null;

    public LayerPanelLayer(WorldWindow wwd) {
        super(wwd);
    }

    private LayerList getValidLayers() {
        LayerList validLayers = new LayerList();
        LayerList allLayers = this.wwd.getModel().getLayers();
        for (Layer l : allLayers) {
            if (l.getName().equalsIgnoreCase("Atmosphere") || l.getName().equalsIgnoreCase("World Map") || l.getName().equalsIgnoreCase("Scale bar") || l.getName().equalsIgnoreCase("Compass") || l.getName().equalsIgnoreCase("NASA Blue Marble Image")) continue;
            if (l.getName().equalsIgnoreCase("MS Bing Aerial")) {
                this.virtualEarthAerialLayer = l;
            } else if (l.getName().equalsIgnoreCase("MS Bing Roads")) {
                this.virtualEarthRoadsLayer = l;
            } else if (l.getName().equalsIgnoreCase("MS Bing Hybrid")) {
                this.virtualEarthHybridLayer = l;
            }
            validLayers.add(l);
        }
        return validLayers;
    }

    public void selected(SelectEvent event) {
        ScreenAnnotation annotation = this.getAnnotation();
        if (event.hasObjects() && event.getTopObject() == annotation) {
            boolean update = false;
            if (event.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover") || event.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick")) {
                PickedObject po;
                if (!annotation.getAttributes().isHighlighted()) {
                    annotation.getAttributes().setHighlighted(true);
                    update = true;
                }
                if ((po = event.getTopPickedObject()).getValue("gov.nasa.worldwind.avkey.URL") != null) {
                    ((Component)((Object)this.wwd)).setCursor(Cursor.getPredefinedCursor(12));
                    int i = Integer.parseInt((String)po.getValue("gov.nasa.worldwind.avkey.URL"));
                    if (this.getSelectedIndex() != i) {
                        this.setSelectedIndex(i);
                        update = true;
                    }
                    if (event.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick")) {
                        LayerList layers = this.getValidLayers();
                        if (i >= 0 && i < layers.size()) {
                            Layer layer = (Layer)layers.get(i);
                            boolean enable = !layer.isEnabled();
                            layer.setEnabled(enable);
                            this.updateVirtualEarthLayers(layer, enable);
                            update = true;
                        }
                    }
                } else {
                    if (this.getSelectedIndex() != -1) {
                        this.setSelectedIndex(-1);
                        update = true;
                    }
                    if (this.isComponentDragEnabled()) {
                        ((Component)((Object)this.wwd)).setCursor(Cursor.getPredefinedCursor(13));
                    } else {
                        ((Component)((Object)this.wwd)).setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
            if ((event.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag") || event.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd")) && (this.isComponentDragEnabled() || this.isLayerDragEnabled())) {
                boolean wasDraggingLayer = this.draggingLayer;
                this.drag(event);
                if (this.draggingLayer || wasDraggingLayer) {
                    update = true;
                } else {
                    this.wwd.redraw();
                }
            }
            if (update) {
                this.update();
            }
        } else if (event.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover") && annotation.getAttributes().isHighlighted()) {
            annotation.getAttributes().setHighlighted(false);
            ((Component)((Object)this.wwd)).setCursor(Cursor.getDefaultCursor());
            this.update();
        }
    }

    private void updateVirtualEarthLayers(Layer layer, boolean enable) {
        if (enable && (layer == this.virtualEarthAerialLayer || layer == this.virtualEarthRoadsLayer || layer == this.virtualEarthHybridLayer)) {
            this.virtualEarthAerialLayer.setEnabled(layer == this.virtualEarthAerialLayer);
            this.virtualEarthRoadsLayer.setEnabled(layer == this.virtualEarthRoadsLayer);
            this.virtualEarthHybridLayer.setEnabled(layer == this.virtualEarthHybridLayer);
        }
    }

    protected void drag(SelectEvent event) {
        if (event.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag")) {
            if (this.isComponentDragEnabled() && this.getSelectedIndex() == -1 && this.dragRefIndex == -1 || this.draggingComponent) {
                if (!this.draggingComponent) {
                    this.dragRefCursorPoint = event.getMouseEvent().getPoint();
                    this.dragRefPoint = this.getAnnotation().getScreenPoint();
                    this.draggingComponent = true;
                }
                Point cursorOffset = new Point(event.getMouseEvent().getPoint().x - this.dragRefCursorPoint.x, event.getMouseEvent().getPoint().y - this.dragRefCursorPoint.y);
                Point targetPoint = new Point(this.dragRefPoint.x + cursorOffset.x, this.dragRefPoint.y - cursorOffset.y);
                this.moveTo(targetPoint);
            } else if (this.isLayerDragEnabled()) {
                if (!this.draggingLayer) {
                    this.dragRefIndex = this.getSelectedIndex();
                    this.draggingLayer = true;
                }
                if (this.getSelectedIndex() != -1 && this.dragRefIndex != -1 && this.dragRefIndex != this.getSelectedIndex()) {
                    LayerList layers = this.getValidLayers();
                    int insertIndex = this.dragRefIndex > this.getSelectedIndex() ? this.getSelectedIndex() : this.getSelectedIndex() + 1;
                    int removeIndex = this.dragRefIndex > this.getSelectedIndex() ? this.dragRefIndex + 1 : this.dragRefIndex;
                    layers.add(insertIndex, (Layer)layers.get(this.dragRefIndex));
                    layers.remove(removeIndex);
                    this.dragRefIndex = this.getSelectedIndex();
                }
            }
        } else if (event.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd")) {
            this.draggingComponent = false;
            this.draggingLayer = false;
            this.dragRefIndex = -1;
        }
    }

    protected String makeAnnotationText(LayerList layers) {
        StringBuilder text = new StringBuilder(255);
        int i = 0;
        LayerList validLayers = this.getValidLayers();
        for (Layer layer : validLayers) {
            if (!this.isMinimized() || layer == this) {
                Color color = i == this.getSelectedIndex() ? this.getHighlightColor() : this.getColor();
                color = i == this.dragRefIndex ? this.dragColor : color;
                text.append("<a href=\"");
                text.append(i);
                text.append("\"><font color=\"");
                text.append(LayerPanelLayer.encodeHTMLColor((Color)color));
                text.append("\">");
                text.append(layer.isEnabled() ? this.getLayerEnabledSymbol() : this.getLayerDisabledSymbol());
                text.append(' ');
                text.append(layer.isEnabled() ? "<b>" : "<i>");
                text.append(layer.getName());
                text.append(layer.isEnabled() ? "</b>" : "</i>");
                text.append(layer.isMultiResolution() && layer.isAtMaxResolution() ? "*" : "");
                text.append("</a><br />");
            }
            ++i;
        }
        return text.toString();
    }
}

