/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson;

import java.io.IOException;
import org.codehaus.jackson.JsonLocation;

public class JsonProcessingException
extends IOException {
    static final long serialVersionUID = 123L;
    protected JsonLocation mLocation;

    protected JsonProcessingException(String string, JsonLocation jsonLocation, Throwable throwable) {
        super(string);
        if (throwable != null) {
            this.initCause(throwable);
        }
        this.mLocation = jsonLocation;
    }

    protected JsonProcessingException(String string) {
        super(string);
    }

    protected JsonProcessingException(String string, JsonLocation jsonLocation) {
        this(string, jsonLocation, null);
    }

    protected JsonProcessingException(String string, Throwable throwable) {
        this(string, null, throwable);
    }

    protected JsonProcessingException(Throwable throwable) {
        this(null, null, throwable);
    }

    public JsonLocation getLocation() {
        return this.mLocation;
    }

    @Override
    public String getMessage() {
        JsonLocation jsonLocation;
        String string = super.getMessage();
        if (string == null) {
            string = "N/A";
        }
        if ((jsonLocation = this.getLocation()) != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append('\n');
            stringBuilder.append(" at ");
            stringBuilder.append(jsonLocation.toString());
            return stringBuilder.toString();
        }
        return string;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": " + this.getMessage();
    }
}

