/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view.orbit;

import gov.nasa.worldwind.animation.MoveToDoubleAnimator;
import gov.nasa.worldwind.util.PropertyAccessor;
import gov.nasa.worldwind.view.orbit.BasicOrbitView;

public class OrbitViewMoveToZoomAnimator
extends MoveToDoubleAnimator {
    BasicOrbitView orbitView;
    boolean endCenterOnSurface;

    OrbitViewMoveToZoomAnimator(BasicOrbitView basicOrbitView, Double d, double d2, PropertyAccessor.DoubleAccessor doubleAccessor, boolean bl) {
        super(d, d2, doubleAccessor);
        this.orbitView = basicOrbitView;
        this.endCenterOnSurface = bl;
    }

    @Override
    protected void setImpl(double d) {
        Double d2 = this.nextDouble(d);
        if (d2 == null) {
            return;
        }
        this.propertyAccessor.setDouble(d2);
    }

    @Override
    public Double nextDouble(double d) {
        double d2 = (1.0 - d) * this.propertyAccessor.getDouble() + d * this.end;
        if (Math.abs(d2 - this.propertyAccessor.getDouble()) < this.minEpsilon) {
            this.stop();
            if (this.endCenterOnSurface) {
                this.orbitView.setViewOutOfFocus(true);
            }
            return null;
        }
        return d2;
    }
}

