/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view.orbit;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.animation.AngleAnimator;
import gov.nasa.worldwind.animation.AnimationController;
import gov.nasa.worldwind.animation.AnimationSupport;
import gov.nasa.worldwind.animation.Animator;
import gov.nasa.worldwind.animation.CompoundAnimator;
import gov.nasa.worldwind.animation.DoubleAnimator;
import gov.nasa.worldwind.animation.PositionAnimator;
import gov.nasa.worldwind.animation.RotateToAngleAnimator;
import gov.nasa.worldwind.animation.ScheduledInterpolator;
import gov.nasa.worldwind.animation.SmoothInterpolator;
import gov.nasa.worldwind.awt.AbstractViewInputHandler;
import gov.nasa.worldwind.awt.BasicViewInputHandler;
import gov.nasa.worldwind.awt.ViewInputActionHandler;
import gov.nasa.worldwind.awt.ViewInputAttributes;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.PropertyAccessor;
import gov.nasa.worldwind.view.ViewPropertyAccessor;
import gov.nasa.worldwind.view.ViewUtil;
import gov.nasa.worldwind.view.orbit.BasicOrbitView;
import gov.nasa.worldwind.view.orbit.BasicOrbitViewLimits;
import gov.nasa.worldwind.view.orbit.FlyToOrbitViewAnimator;
import gov.nasa.worldwind.view.orbit.OrbitView;
import gov.nasa.worldwind.view.orbit.OrbitViewCenterAnimator;
import gov.nasa.worldwind.view.orbit.OrbitViewLimits;
import gov.nasa.worldwind.view.orbit.OrbitViewMoveToZoomAnimator;
import gov.nasa.worldwind.view.orbit.OrbitViewPropertyAccessor;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.Date;
import java.util.logging.Level;

public class OrbitViewInputHandler
extends BasicViewInputHandler {
    protected AnimationController gotoAnimControl = new AnimationController();
    protected AnimationController uiAnimControl = new AnimationController();
    protected static final String VIEW_ANIM_HEADING = "ViewAnimHeading";
    protected static final String VIEW_ANIM_PITCH = "ViewAnimPitch";
    protected static final String VIEW_ANIM_ROLL = "ViewAnimRoll";
    protected static final String VIEW_ANIM_HEADING_PITCH = "ViewAnimHeadingPitch";
    protected static final String VIEW_ANIM_POSITION = "ViewAnimPosition";
    protected static final String VIEW_ANIM_CENTER = "ViewAnimCenter";
    protected static final String VIEW_ANIM_ZOOM = "ViewAnimZoom";
    protected static final String VIEW_ANIM_PAN = "ViewAnimPan";
    protected static final String VIEW_ANIM_APP = "ViewAnimApp";
    public static final String ORBITVIEW_RESET_ROLL = "gov.nasa.worldwind.ViewResetRoll";

    public OrbitViewInputHandler() {
        this.initializeInputHandlers();
    }

    protected void initializeInputHandlers() {
        ViewInputAttributes.ActionAttributes.MouseAction[] mouseActionArray = new ViewInputAttributes.ActionAttributes.MouseAction[]{new ViewInputAttributes.ActionAttributes.MouseAction(1024)};
        this.getAttributes().setMouseActionAttributes(ORBITVIEW_RESET_ROLL, 0, ViewInputAttributes.ActionAttributes.ActionTrigger.ON_PRESS, mouseActionArray, 2.0, 2.2, false, 0.0);
        ViewInputAttributes.ActionAttributes actionAttributes = this.getAttributes().getActionMap("gov.nasa.worldwind.DeviceMouse").getActionAttributes(ORBITVIEW_RESET_ROLL);
        actionAttributes.setMouseActionListener(new ResetRollActionListener());
    }

    @Override
    protected void onMoveTo(Position position, ViewInputAttributes.ActionAttributes actionAttributes) {
    }

    @Override
    protected void onMoveTo(Position position, ViewInputAttributes.DeviceAttributes deviceAttributes, ViewInputAttributes.ActionAttributes actionAttributes) {
        this.stopAllAnimators();
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (view instanceof OrbitView) {
            double d = this.getScaleValueZoom(actionAttributes);
            if (!actionAttributes.isEnableSmoothing()) {
                d = 0.0;
            }
            OrbitViewCenterAnimator orbitViewCenterAnimator = new OrbitViewCenterAnimator((BasicOrbitView)this.getView(), view.getEyePosition(), position, d, OrbitViewPropertyAccessor.createCenterPositionAccessor((OrbitView)view), true);
            this.gotoAnimControl.put(VIEW_ANIM_CENTER, orbitViewCenterAnimator);
            view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
        }
    }

    @Override
    protected void onHorizontalTranslateAbs(Angle angle, Angle angle2, ViewInputAttributes.ActionAttributes actionAttributes) {
        this.stopGoToAnimators();
        this.stopUserInputAnimators(VIEW_ANIM_HEADING, VIEW_ANIM_PITCH, VIEW_ANIM_ZOOM);
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (angle.equals(Angle.ZERO) && angle2.equals(Angle.ZERO)) {
            return;
        }
        if (view instanceof OrbitView) {
            Position position = ((OrbitView)view).getCenterPosition().add(new Position(angle, angle2, 0.0));
            this.setCenterPosition((BasicOrbitView)view, this.uiAnimControl, position, actionAttributes);
        }
    }

    @Override
    protected void onHorizontalTranslateRel(double d, double d2, double d3, double d4, ViewInputAttributes.DeviceAttributes deviceAttributes, ViewInputAttributes.ActionAttributes actionAttributes) {
        this.stopGoToAnimators();
        this.stopUserInputAnimators(VIEW_ANIM_HEADING, VIEW_ANIM_PITCH, VIEW_ANIM_ZOOM);
        if (actionAttributes.getMouseActions() != null) {
            double d5 = Math.sqrt(d * d + d2 * d2);
            if (d5 > 0.0) {
                d /= d5;
                d2 /= d5;
            }
            Point point = OrbitViewInputHandler.constrainToSourceBounds(this.getMousePoint(), this.getWorldWindow());
            Point point2 = OrbitViewInputHandler.constrainToSourceBounds(this.getLastMousePoint(), this.getWorldWindow());
            if (this.getSelectedPosition() == null) {
                this.setSelectedPosition(this.computeSelectedPosition());
            } else if (this.computeSelectedPosition() == null) {
                this.setSelectedPosition(null);
            } else if (this.computeSelectedPointAt(point) == null || this.computeSelectedPointAt(point2) == null) {
                this.setSelectedPosition(null);
            }
            Vec4 vec4 = this.computeSelectedPointAt(point);
            Vec4 vec42 = this.computeSelectedPointAt(point2);
            if (vec4 != null && vec42 != null) {
                LatLon latLon = this.getChangeInLocation(point2, point, vec42, vec4);
                this.onHorizontalTranslateAbs(latLon.getLatitude(), latLon.getLongitude(), actionAttributes);
                return;
            }
            Point point3 = ViewUtil.subtract(point, point2);
            d = point3.y;
            d2 = -point3.x;
        }
        Angle angle = Angle.fromDegrees(d * this.getScaleValueHorizTransRel(deviceAttributes, actionAttributes));
        Angle angle2 = Angle.fromDegrees(d2 * this.getScaleValueHorizTransRel(deviceAttributes, actionAttributes));
        this.onHorizontalTranslateRel(angle, angle2, actionAttributes);
    }

    @Override
    protected void onHorizontalTranslateRel(Angle angle, Angle angle2, ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (angle.equals(Angle.ZERO) && angle2.equals(Angle.ZERO)) {
            return;
        }
        if (view instanceof OrbitView) {
            double d = view.getHeading().sin();
            double d2 = view.getHeading().cos();
            double d3 = d2 * angle.getDegrees() - d * angle2.getDegrees();
            double d4 = d * angle.getDegrees() + d2 * angle2.getDegrees();
            Position position = ((OrbitView)view).getCenterPosition().add(Position.fromDegrees(d3, d4, 0.0));
            this.setCenterPosition((BasicOrbitView)view, this.uiAnimControl, position, actionAttributes);
        }
    }

    @Override
    protected void onResetHeading(ViewInputAttributes.ActionAttributes actionAttributes) {
        this.stopAllAnimators();
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.addHeadingAnimator(view.getHeading(), Angle.ZERO);
    }

    protected void onResetRoll(ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (Angle.ZERO.equals(view.getRoll())) {
            return;
        }
        this.addRollAnimator(view.getRoll(), Angle.ZERO);
    }

    @Override
    protected void onResetHeadingPitchRoll(ViewInputAttributes.ActionAttributes actionAttributes) {
        this.stopAllAnimators();
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.addHeadingPitchRollAnimator(view.getHeading(), Angle.ZERO, view.getPitch(), Angle.ZERO, view.getRoll(), Angle.ZERO);
    }

    @Override
    protected void onRotateView(double d, double d2, double d3, double d4, ViewInputAttributes.DeviceAttributes deviceAttributes, ViewInputAttributes.ActionAttributes actionAttributes) {
        this.stopGoToAnimators();
        this.stopUserInputAnimators(VIEW_ANIM_CENTER, VIEW_ANIM_ZOOM);
        if (actionAttributes.getMouseActions() != null) {
            if (this.getWorldWindow() instanceof Component && this.getMousePoint().y < ((Component)((Object)this.getWorldWindow())).getHeight() / 2) {
                d = -d;
            }
        } else {
            double d5 = Math.sqrt(d * d + d2 * d2);
            if (d5 > 0.0) {
                d /= d5;
                d2 /= d5;
            }
        }
        Angle angle = Angle.fromDegrees(d * this.getScaleValueRotate(actionAttributes));
        Angle angle2 = Angle.fromDegrees(d2 * this.getScaleValueRotate(actionAttributes));
        this.onRotateView(angle, angle2, actionAttributes);
    }

    @Override
    protected void onRotateView(Angle angle, Angle angle2, ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (view instanceof BasicOrbitView) {
            if (!angle.equals(Angle.ZERO)) {
                this.changeHeading((BasicOrbitView)view, this.uiAnimControl, angle, actionAttributes);
            }
            if (!angle2.equals(Angle.ZERO)) {
                this.changePitch((BasicOrbitView)view, this.uiAnimControl, angle2, actionAttributes);
            }
        }
    }

    @Override
    protected void onVerticalTranslate(double d, double d2, ViewInputAttributes.DeviceAttributes deviceAttributes, ViewInputAttributes.ActionAttributes actionAttributes) {
        this.stopGoToAnimators();
        this.stopUserInputAnimators(VIEW_ANIM_CENTER, VIEW_ANIM_HEADING, VIEW_ANIM_PITCH);
        double d3 = d * this.getScaleValueRotate(actionAttributes);
        this.onVerticalTranslate(d3, actionAttributes);
    }

    @Override
    protected void onVerticalTranslate(double d, ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (d == 0.0) {
            return;
        }
        if (view instanceof BasicOrbitView) {
            this.changeZoom((BasicOrbitView)view, this.uiAnimControl, d, actionAttributes);
        }
    }

    @Override
    public void apply() {
        super.apply();
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (this.gotoAnimControl.stepAnimators()) {
            view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
        } else {
            this.gotoAnimControl.clear();
        }
        if (this.uiAnimControl.stepAnimators()) {
            view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
        } else {
            this.uiAnimControl.clear();
        }
    }

    @Override
    protected void handlePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.handlePropertyChange(propertyChangeEvent);
        if (propertyChangeEvent.getPropertyName() == "gov.nasa.worldwind.view.orbit.OrbitView.CenterStopped") {
            this.handleOrbitViewCenterStopped();
        }
    }

    protected void stopAllAnimators() {
        this.uiAnimControl.stopAnimations();
        this.gotoAnimControl.stopAnimations();
        this.uiAnimControl.clear();
        this.gotoAnimControl.clear();
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (view instanceof BasicOrbitView) {
            ((BasicOrbitView)view).setViewOutOfFocus(true);
        }
    }

    protected void stopGoToAnimators() {
        this.gotoAnimControl.stopAnimations();
        this.gotoAnimControl.clear();
    }

    protected void stopUserInputAnimators(Object ... objectArray) {
        for (Object object : objectArray) {
            if (this.uiAnimControl.get(object) == null) continue;
            ((Animator)this.uiAnimControl.get(object)).stop();
            this.uiAnimControl.remove(object);
        }
    }

    @Override
    protected void handleViewStopped() {
        this.stopAllAnimators();
    }

    protected void handleOrbitViewCenterStopped() {
        this.stopUserInputAnimators(VIEW_ANIM_CENTER);
    }

    protected void setCenterPosition(BasicOrbitView basicOrbitView, AnimationController animationController, Position position, ViewInputAttributes.ActionAttributes actionAttributes) {
        double d = actionAttributes.getSmoothingValue();
        if (!actionAttributes.isEnableSmoothing() || !this.isEnableSmoothing()) {
            d = 0.0;
        }
        if (d == 0.0) {
            if (animationController.get(VIEW_ANIM_CENTER) != null) {
                animationController.remove(VIEW_ANIM_CENTER);
            }
            Position position2 = BasicOrbitViewLimits.limitCenterPosition(position, basicOrbitView.getOrbitViewLimits());
            basicOrbitView.setCenterPosition(position2);
            basicOrbitView.setViewOutOfFocus(true);
        } else {
            OrbitViewCenterAnimator orbitViewCenterAnimator = (OrbitViewCenterAnimator)animationController.get(VIEW_ANIM_CENTER);
            Position position3 = basicOrbitView.getCenterPosition();
            if (orbitViewCenterAnimator == null || !orbitViewCenterAnimator.hasNext()) {
                Position position4 = OrbitViewInputHandler.computeNewPosition(position, basicOrbitView.getOrbitViewLimits());
                orbitViewCenterAnimator = new OrbitViewCenterAnimator((BasicOrbitView)this.getView(), position3, position4, d, OrbitViewPropertyAccessor.createCenterPositionAccessor(basicOrbitView), true);
                animationController.put(VIEW_ANIM_CENTER, orbitViewCenterAnimator);
            } else {
                Position position5 = new Position(orbitViewCenterAnimator.getEnd().getLatitude().add(position.getLatitude()).subtract(position3.getLatitude()), orbitViewCenterAnimator.getEnd().getLongitude().add(position.getLongitude()).subtract(position3.getLongitude()), orbitViewCenterAnimator.getEnd().getElevation() + position.getElevation() - position3.getElevation());
                position5 = OrbitViewInputHandler.computeNewPosition(position5, basicOrbitView.getOrbitViewLimits());
                orbitViewCenterAnimator.setEnd(position5);
            }
            orbitViewCenterAnimator.start();
        }
        basicOrbitView.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, basicOrbitView);
    }

    protected void changeHeading(BasicOrbitView basicOrbitView, AnimationController animationController, Angle angle, ViewInputAttributes.ActionAttributes actionAttributes) {
        basicOrbitView.computeAndSetViewCenterIfNeeded();
        double d = actionAttributes.getSmoothingValue();
        if (!actionAttributes.isEnableSmoothing() || !this.isEnableSmoothing()) {
            d = 0.0;
        }
        if (d == 0.0) {
            if (animationController.get(VIEW_ANIM_HEADING) != null) {
                animationController.remove(VIEW_ANIM_HEADING);
            }
            Angle angle2 = OrbitViewInputHandler.computeNewHeading(basicOrbitView.getHeading().add(angle), basicOrbitView.getOrbitViewLimits());
            basicOrbitView.setHeading(angle2);
        } else {
            RotateToAngleAnimator rotateToAngleAnimator = (RotateToAngleAnimator)animationController.get(VIEW_ANIM_HEADING);
            if (rotateToAngleAnimator == null || !rotateToAngleAnimator.hasNext()) {
                Angle angle3 = OrbitViewInputHandler.computeNewHeading(basicOrbitView.getHeading().add(angle), basicOrbitView.getOrbitViewLimits());
                rotateToAngleAnimator = new RotateToAngleAnimator(basicOrbitView.getHeading(), angle3, d, ViewPropertyAccessor.createHeadingAccessor(basicOrbitView));
                animationController.put(VIEW_ANIM_HEADING, rotateToAngleAnimator);
            } else {
                Angle angle4 = OrbitViewInputHandler.computeNewHeading(rotateToAngleAnimator.getEnd().add(angle), basicOrbitView.getOrbitViewLimits());
                rotateToAngleAnimator.setEnd(angle4);
            }
            rotateToAngleAnimator.start();
        }
        basicOrbitView.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, basicOrbitView);
    }

    protected void changePitch(BasicOrbitView basicOrbitView, AnimationController animationController, Angle angle, ViewInputAttributes.ActionAttributes actionAttributes) {
        basicOrbitView.computeAndSetViewCenterIfNeeded();
        double d = actionAttributes.getSmoothingValue();
        if (!actionAttributes.isEnableSmoothing() || !this.isEnableSmoothing()) {
            d = 0.0;
        }
        if (d == 0.0) {
            if (animationController.get(VIEW_ANIM_PITCH) != null) {
                animationController.remove(VIEW_ANIM_PITCH);
            }
            Angle angle2 = OrbitViewInputHandler.computeNewPitch(basicOrbitView.getPitch().add(angle), basicOrbitView.getOrbitViewLimits());
            basicOrbitView.setPitch(angle2);
        } else {
            RotateToAngleAnimator rotateToAngleAnimator = (RotateToAngleAnimator)animationController.get(VIEW_ANIM_PITCH);
            if (rotateToAngleAnimator == null || !rotateToAngleAnimator.hasNext()) {
                Angle angle3 = OrbitViewInputHandler.computeNewPitch(basicOrbitView.getPitch().add(angle), basicOrbitView.getOrbitViewLimits());
                rotateToAngleAnimator = new RotateToAngleAnimator(basicOrbitView.getPitch(), angle3, d, (PropertyAccessor.AngleAccessor)new CollisionAwarePitchAccessor(basicOrbitView));
                rotateToAngleAnimator.setStopOnInvalidState(true);
                animationController.put(VIEW_ANIM_PITCH, rotateToAngleAnimator);
            } else {
                Angle angle4 = OrbitViewInputHandler.computeNewPitch(rotateToAngleAnimator.getEnd().add(angle), basicOrbitView.getOrbitViewLimits());
                rotateToAngleAnimator.setEnd(angle4);
            }
            rotateToAngleAnimator.start();
        }
        basicOrbitView.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, basicOrbitView);
    }

    protected void changeZoom(BasicOrbitView basicOrbitView, AnimationController animationController, double d, ViewInputAttributes.ActionAttributes actionAttributes) {
        basicOrbitView.computeAndSetViewCenterIfNeeded();
        double d2 = actionAttributes.getSmoothingValue();
        if (!actionAttributes.isEnableSmoothing() || !this.isEnableSmoothing()) {
            d2 = 0.0;
        }
        if (d2 == 0.0) {
            if (animationController.get(VIEW_ANIM_ZOOM) != null) {
                animationController.remove(VIEW_ANIM_ZOOM);
            }
            basicOrbitView.setZoom(OrbitViewInputHandler.computeNewZoom(basicOrbitView.getZoom(), d, basicOrbitView.getOrbitViewLimits()));
        } else {
            OrbitViewMoveToZoomAnimator orbitViewMoveToZoomAnimator = (OrbitViewMoveToZoomAnimator)animationController.get(VIEW_ANIM_ZOOM);
            if (orbitViewMoveToZoomAnimator == null || !orbitViewMoveToZoomAnimator.hasNext()) {
                double d3 = OrbitViewInputHandler.computeNewZoom(basicOrbitView.getZoom(), d, basicOrbitView.getOrbitViewLimits());
                orbitViewMoveToZoomAnimator = new OrbitViewMoveToZoomAnimator(basicOrbitView, d3, d2, OrbitViewPropertyAccessor.createZoomAccessor(basicOrbitView), false);
                animationController.put(VIEW_ANIM_ZOOM, orbitViewMoveToZoomAnimator);
            } else {
                double d4 = OrbitViewInputHandler.computeNewZoom(orbitViewMoveToZoomAnimator.getEnd(), d, basicOrbitView.getOrbitViewLimits());
                orbitViewMoveToZoomAnimator.setEnd(d4);
            }
            orbitViewMoveToZoomAnimator.start();
        }
        basicOrbitView.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, basicOrbitView);
    }

    protected static Position computeNewPosition(Position position, OrbitViewLimits orbitViewLimits) {
        Position position2 = new Position(Angle.normalizedLatitude(position.getLatitude()), Angle.normalizedLongitude(position.getLongitude()), position.getElevation());
        return BasicOrbitViewLimits.limitCenterPosition(position2, orbitViewLimits);
    }

    protected static Angle computeNewHeading(Angle angle, OrbitViewLimits orbitViewLimits) {
        Angle angle2 = BasicOrbitView.normalizedHeading(angle);
        return BasicOrbitViewLimits.limitHeading(angle2, orbitViewLimits);
    }

    protected static Angle computeNewPitch(Angle angle, OrbitViewLimits orbitViewLimits) {
        Angle angle2 = BasicOrbitView.normalizedPitch(angle);
        return BasicOrbitViewLimits.limitPitch(angle2, orbitViewLimits);
    }

    protected static double computeNewZoom(double d, double d2, OrbitViewLimits orbitViewLimits) {
        double d3 = d != 0.0 ? Math.log(d) : 0.0;
        double d4 = Math.exp(d3 + d2);
        return BasicOrbitViewLimits.limitZoom(d4, orbitViewLimits);
    }

    protected double getScaleValueHorizTransRel(ViewInputAttributes.DeviceAttributes deviceAttributes, ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null) {
            return 0.0;
        }
        if (view instanceof OrbitView) {
            double[] dArray = actionAttributes.getValues();
            double d = this.getWorldWindow().getModel().getGlobe().getRadius();
            double d2 = this.getScaleValue(dArray[0], dArray[1], ((OrbitView)view).getZoom(), 3.0 * d, true);
            return d2;
        }
        return super.getScaleValueElevation(deviceAttributes, actionAttributes);
    }

    protected double getScaleValueRotate(ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null) {
            return 0.0;
        }
        if (view instanceof OrbitView) {
            double[] dArray = actionAttributes.getValues();
            double d = this.getWorldWindow().getModel().getGlobe().getRadius();
            double d2 = this.getScaleValue(dArray[0], dArray[1], ((OrbitView)view).getZoom(), 3.0 * d, false);
            return d2;
        }
        return 1.0;
    }

    protected double getScaleValueZoom(ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null) {
            return 0.0;
        }
        if (view instanceof OrbitView) {
            double[] dArray = actionAttributes.getValues();
            double d = this.getWorldWindow().getModel().getGlobe().getRadius();
            double d2 = ((OrbitView)view).getZoom() / (3.0 * d);
            d2 = d2 < 0.0 ? 0.0 : (d2 > 1.0 ? 1.0 : d2);
            return dArray[0] * (1.0 - d2) + dArray[1] * d2;
        }
        return 1.0;
    }

    public void addPanToAnimator(Position position, Position position2, Angle angle, Angle angle2, Angle angle3, Angle angle4, double d, double d2, long l, boolean bl) {
        int n = bl ? 1 : 0;
        OrbitView orbitView = (OrbitView)this.getView();
        FlyToOrbitViewAnimator flyToOrbitViewAnimator = FlyToOrbitViewAnimator.createFlyToOrbitViewAnimator(orbitView, position, position2, angle, angle2, angle3, angle4, d, d2, l, n);
        this.gotoAnimControl.put(VIEW_ANIM_PAN, flyToOrbitViewAnimator);
        this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
    }

    public void addPanToAnimator(Position position, Position position2, Angle angle, Angle angle2, Angle angle3, Angle angle4, double d, double d2, boolean bl) {
        int n = bl ? 1 : 0;
        long l = AnimationSupport.getScaledTimeMillisecs(position, position2, 2000L, 10000L);
        OrbitView orbitView = (OrbitView)this.getView();
        FlyToOrbitViewAnimator flyToOrbitViewAnimator = FlyToOrbitViewAnimator.createFlyToOrbitViewAnimator(orbitView, position, position2, angle, angle2, angle3, angle4, d, d2, l, n);
        this.gotoAnimControl.put(VIEW_ANIM_PAN, flyToOrbitViewAnimator);
        this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
    }

    public void addPanToAnimator(Position position, Angle angle, Angle angle2, double d, long l, boolean bl) {
        OrbitView orbitView = (OrbitView)this.getView();
        this.addPanToAnimator(orbitView.getCenterPosition(), position, orbitView.getHeading(), angle, orbitView.getPitch(), angle2, orbitView.getZoom(), d, l, bl);
        this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
    }

    public void addPanToAnimator(Position position, Angle angle, Angle angle2, double d, boolean bl) {
        OrbitView orbitView = (OrbitView)this.getView();
        this.addPanToAnimator(orbitView.getCenterPosition(), position, orbitView.getHeading(), angle, orbitView.getPitch(), angle2, orbitView.getZoom(), d, bl);
        this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
    }

    public void addPanToAnimator(Position position, Angle angle, Angle angle2, double d) {
        OrbitView orbitView = (OrbitView)this.getView();
        this.addPanToAnimator(orbitView.getCenterPosition(), position, orbitView.getHeading(), angle, orbitView.getPitch(), angle2, orbitView.getZoom(), d, false);
        this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
    }

    public void addEyePositionAnimator(long l, Position position, Position position2) {
        PositionAnimator positionAnimator = ViewUtil.createEyePositionAnimator(this.getView(), l, position, position2);
        this.gotoAnimControl.put(VIEW_ANIM_POSITION, positionAnimator);
        this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
    }

    public void addHeadingAnimator(Angle angle, Angle angle2) {
        this.gotoAnimControl.remove(VIEW_ANIM_HEADING_PITCH);
        AngleAnimator angleAnimator = ViewUtil.createHeadingAnimator(this.getView(), angle, angle2);
        this.gotoAnimControl.put(VIEW_ANIM_HEADING, angleAnimator);
        this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
    }

    public void addPitchAnimator(Angle angle, Angle angle2) {
        this.gotoAnimControl.remove(VIEW_ANIM_HEADING_PITCH);
        AngleAnimator angleAnimator = ViewUtil.createPitchAnimator(this.getView(), angle, angle2);
        this.gotoAnimControl.put(VIEW_ANIM_PITCH, angleAnimator);
        this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
    }

    public void addRollAnimator(Angle angle, Angle angle2) {
        this.gotoAnimControl.remove(VIEW_ANIM_ROLL);
        AngleAnimator angleAnimator = ViewUtil.createRollAnimator(this.getView(), angle, angle2);
        this.gotoAnimControl.put(VIEW_ANIM_ROLL, angleAnimator);
        this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
    }

    public void addHeadingPitchRollAnimator(Angle angle, Angle angle2, Angle angle3, Angle angle4, Angle angle5, Angle angle6) {
        this.gotoAnimControl.remove(VIEW_ANIM_PITCH);
        this.gotoAnimControl.remove(VIEW_ANIM_HEADING);
        CompoundAnimator compoundAnimator = ViewUtil.createHeadingPitchRollAnimator(this.getView(), angle, angle2, angle3, angle4, angle5, angle6);
        this.gotoAnimControl.put(VIEW_ANIM_HEADING_PITCH, compoundAnimator);
        this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
    }

    public void addZoomAnimator(double d, double d2) {
        DoubleAnimator doubleAnimator = new DoubleAnimator(new ScheduledInterpolator(4000L), d, d2, OrbitViewPropertyAccessor.createZoomAccessor((OrbitView)this.getView()));
        this.gotoAnimControl.put(VIEW_ANIM_ZOOM, doubleAnimator);
        this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
    }

    public void addFlyToZoomAnimator(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        View view = this.getView();
        if (view instanceof OrbitView) {
            OrbitView orbitView = (OrbitView)view;
            Angle angle3 = orbitView.getHeading();
            Angle angle4 = orbitView.getPitch();
            double d2 = orbitView.getZoom();
            long l = AnimationSupport.getScaledTimeMillisecs(d2, d, 1000L, 8000L);
            DoubleAnimator doubleAnimator = new DoubleAnimator(new ScheduledInterpolator(l), d2, d, OrbitViewPropertyAccessor.createZoomAccessor(orbitView));
            AngleAnimator angleAnimator = new AngleAnimator(new ScheduledInterpolator(l), angle3, angle, ViewPropertyAccessor.createHeadingAccessor(orbitView));
            AngleAnimator angleAnimator2 = new AngleAnimator(new ScheduledInterpolator(l), angle4, angle2, ViewPropertyAccessor.createPitchAccessor(orbitView));
            this.gotoAnimControl.put(VIEW_ANIM_ZOOM, doubleAnimator);
            this.gotoAnimControl.put(VIEW_ANIM_HEADING, angleAnimator);
            this.gotoAnimControl.put(VIEW_ANIM_PITCH, angleAnimator2);
            orbitView.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, orbitView);
        }
    }

    public void addCenterAnimator(Position position, Position position2, boolean bl) {
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        View view = this.getView();
        if (view instanceof OrbitView) {
            this.addCenterAnimator(position, position2, 4000L, bl);
        }
    }

    public void addCenterAnimator(Position position, Position position2, long l, boolean bl) {
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        View view = this.getView();
        if (view instanceof OrbitView) {
            OrbitView orbitView = (OrbitView)view;
            ScheduledInterpolator scheduledInterpolator = bl ? new SmoothInterpolator(l) : new ScheduledInterpolator(l);
            PositionAnimator positionAnimator = new PositionAnimator(scheduledInterpolator, position, position2, OrbitViewPropertyAccessor.createCenterPositionAccessor(orbitView));
            this.gotoAnimControl.put(VIEW_ANIM_CENTER, positionAnimator);
            orbitView.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, orbitView);
        }
    }

    @Override
    public void goTo(Position position, double d) {
        OrbitView orbitView = (OrbitView)this.getView();
        this.stopAnimators();
        this.addPanToAnimator(position, orbitView.getHeading(), orbitView.getPitch(), d, true);
        this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
    }

    @Override
    public void stopAnimators() {
        this.uiAnimControl.stopAnimations();
        this.gotoAnimControl.stopAnimations();
    }

    @Override
    public boolean isAnimating() {
        return this.uiAnimControl.hasActiveAnimation() || this.gotoAnimControl.hasActiveAnimation();
    }

    @Override
    public void addAnimator(Animator animator) {
        long l = new Date().getTime();
        this.gotoAnimControl.put(VIEW_ANIM_APP + l, animator);
    }

    protected static class CollisionAwarePitchAccessor
    implements PropertyAccessor.AngleAccessor {
        protected OrbitView orbitView;

        public CollisionAwarePitchAccessor(OrbitView orbitView) {
            if (orbitView == null) {
                String string = Logging.getMessage("nullValue.OrbitViewIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.orbitView = orbitView;
        }

        @Override
        public Angle getAngle() {
            return this.orbitView.getPitch();
        }

        @Override
        public boolean setAngle(Angle angle) {
            if (angle == null) {
                return false;
            }
            if (this.orbitView.isDetectCollisions()) {
                this.orbitView.hadCollisions();
            }
            try {
                this.orbitView.setPitch(angle);
            }
            catch (Exception exception) {
                String string = Logging.getMessage("generic.ExceptionWhileChangingView");
                Logging.logger().log(Level.SEVERE, string, exception);
                return false;
            }
            return !this.orbitView.isDetectCollisions() || !this.orbitView.hadCollisions();
        }
    }

    public class ResetRollActionListener
    extends ViewInputActionHandler {
        @Override
        public boolean inputActionPerformed(AbstractViewInputHandler abstractViewInputHandler, MouseEvent mouseEvent, ViewInputAttributes.ActionAttributes actionAttributes) {
            OrbitViewInputHandler.this.onResetRoll(actionAttributes);
            return true;
        }
    }
}

