/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view.orbit;

import gov.nasa.worldwind.animation.MoveToPositionAnimator;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.util.PropertyAccessor;
import gov.nasa.worldwind.view.orbit.BasicOrbitView;

public class OrbitViewCenterAnimator
extends MoveToPositionAnimator {
    private BasicOrbitView orbitView;
    boolean endCenterOnSurface;

    public OrbitViewCenterAnimator(BasicOrbitView basicOrbitView, Position position, Position position2, double d, PropertyAccessor.PositionAccessor positionAccessor, boolean bl) {
        super(position, position2, d, positionAccessor);
        this.endCenterOnSurface = bl;
        this.orbitView = basicOrbitView;
    }

    @Override
    public Position nextPosition(double d) {
        boolean bl;
        Position position = this.end;
        Position position2 = this.propertyAccessor.getPosition();
        double d2 = LatLon.greatCircleDistance((LatLon)position, (LatLon)position2).degrees;
        double d3 = Math.abs(position.getElevation() - position2.getElevation());
        boolean bl2 = bl = Math.max(d2, d3) < this.positionMinEpsilon;
        if (!bl) {
            d = 1.0 - this.smoothing;
            position = new Position(Angle.mix(d, position2.getLatitude(), this.end.getLatitude()), Angle.mix(d, position2.getLongitude(), this.end.getLongitude()), (1.0 - d) * position2.getElevation() + d * this.end.getElevation());
        }
        if (bl) {
            this.stop();
            this.propertyAccessor.setPosition(position);
            if (this.endCenterOnSurface) {
                this.orbitView.setViewOutOfFocus(true);
            }
            return null;
        }
        return position;
    }

    @Override
    protected void setImpl(double d) {
        Position position = this.nextPosition(d);
        if (position == null) {
            return;
        }
        this.propertyAccessor.setPosition(position);
        this.orbitView.setViewOutOfFocus(true);
    }

    @Override
    public void stop() {
        super.stop();
    }
}

