/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.webview;

import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.webview.WebView;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import javax.swing.SwingUtilities;

public abstract class AbstractWebView
extends WWObjectImpl
implements WebView,
Disposable {
    protected Dimension frameSize;
    protected WWTexture textureRep;
    protected boolean active;

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    @Override
    public Dimension getFrameSize() {
        return this.frameSize;
    }

    @Override
    public void setFrameSize(Dimension dimension) {
        if (dimension == null) {
            String string = Logging.getMessage("nullValue.SizeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.frameSize.equals(dimension)) {
            return;
        }
        this.frameSize = dimension;
        this.textureRep = null;
        this.doSetFrameSize(this.frameSize);
    }

    protected abstract void doSetFrameSize(Dimension var1);

    @Override
    public WWTexture getTextureRepresentation(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.textureRep == null) {
            this.textureRep = this.createTextureRepresentation(drawContext);
        }
        return this.textureRep;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    protected abstract WWTexture createTextureRepresentation(DrawContext var1);

    @Override
    public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractWebView.this.propertyChange(propertyChangeEvent);
                }
            });
        } else {
            this.firePropertyChange("gov.nasa.worldwind.avkey.Repaint", null, this);
        }
    }
}

