/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.tree;

import gov.nasa.worldwind.util.WWUtil;
import java.util.ArrayList;
import java.util.List;

public class TreePath
extends ArrayList<String> {
    public TreePath() {
    }

    public TreePath(TreePath treePath, String ... stringArray) {
        this.addAll(treePath);
        for (String string : stringArray) {
            if (WWUtil.isEmpty(string)) continue;
            this.add(string);
        }
    }

    public TreePath(String string, String ... stringArray) {
        this.add(string);
        for (String string2 : stringArray) {
            if (WWUtil.isEmpty(string2)) continue;
            this.add(string2);
        }
    }

    public TreePath(List<String> list) {
        this.addAll(list);
    }

    public TreePath lastButOne() {
        return this.subPath(0, this.size() - 1);
    }

    public TreePath subPath(int n, int n2) {
        return new TreePath(this.subList(n, n2));
    }

    public static boolean isEmptyPath(TreePath treePath) {
        return treePath == null || treePath.size() == 0 || WWUtil.isEmpty(treePath.get(0));
    }

    @Override
    public String toString() {
        if (this.size() == 0) {
            return "<empty path>";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this) {
            if (WWUtil.isEmpty(string)) {
                string = "<empty>";
            }
            if (stringBuilder.length() == 0) {
                stringBuilder.append(string);
                continue;
            }
            stringBuilder.append("/").append(string);
        }
        return stringBuilder.toString();
    }
}

