/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.layertree;

import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.ogc.kml.KMLAbstractContainer;
import gov.nasa.worldwind.ogc.kml.KMLAbstractFeature;
import gov.nasa.worldwind.ogc.kml.KMLAbstractObject;
import gov.nasa.worldwind.ogc.kml.KMLDocument;
import gov.nasa.worldwind.ogc.kml.KMLNetworkLink;
import gov.nasa.worldwind.ogc.kml.KMLRoot;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.layertree.KMLFeatureTreeNode;
import gov.nasa.worldwind.util.layertree.LayerTreeNode;
import gov.nasa.worldwind.util.tree.Tree;
import gov.nasa.worldwind.util.tree.TreeNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;

public class KMLLayerTreeNode
extends LayerTreeNode {
    protected KMLRoot kmlRoot;

    public KMLLayerTreeNode(Layer layer, KMLRoot kMLRoot) {
        super(layer);
        if (kMLRoot == null) {
            String string = Logging.getMessage("nullValue.KMLRootIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.kmlRoot = kMLRoot;
        this.addChildFeatures();
        this.kmlRoot.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent != null ? propertyChangeEvent.getPropertyName() : null;
                Object object = propertyChangeEvent != null ? propertyChangeEvent.getNewValue() : null;
                KMLAbstractFeature kMLAbstractFeature = KMLLayerTreeNode.this.kmlRoot.getFeature();
                if ("gov.nasa.worldwind.avkey.Updated".equals(string) || "gov.nasa.worldwind.avkey.RetrievalStateSuccessful".equals(string) && kMLAbstractFeature == object) {
                    if (SwingUtilities.isEventDispatchThread()) {
                        KMLLayerTreeNode.this.refresh();
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                KMLLayerTreeNode.this.refresh();
                            }
                        });
                    }
                }
            }
        });
        this.setValue("gov.nasa.worldwind.avkey.Context", kMLRoot.getFeature());
    }

    @Override
    public void setSelected(boolean bl) {
        super.setSelected(bl);
        KMLAbstractFeature kMLAbstractFeature = this.kmlRoot.getFeature();
        if (kMLAbstractFeature instanceof KMLAbstractContainer) {
            kMLAbstractFeature.setVisibility(bl);
        }
    }

    protected void addChildFeatures() {
        KMLAbstractObject kMLAbstractObject;
        KMLAbstractFeature kMLAbstractFeature = this.kmlRoot.getFeature();
        if (kMLAbstractFeature == null) {
            return;
        }
        KMLFeatureTreeNode kMLFeatureTreeNode = KMLFeatureTreeNode.fromKMLFeature(kMLAbstractFeature);
        this.setDescription(kMLFeatureTreeNode.getDescription());
        Boolean bl = kMLAbstractFeature.getVisibility();
        this.setSelected(bl == null || bl != false);
        if (kMLAbstractFeature instanceof KMLAbstractContainer) {
            kMLAbstractObject = (KMLAbstractContainer)kMLAbstractFeature;
            for (KMLAbstractFeature object : ((KMLAbstractContainer)kMLAbstractObject).getFeatures()) {
                if (object == null) continue;
                this.addFeatureNode(object);
            }
        }
        if (kMLAbstractFeature instanceof KMLNetworkLink && (kMLAbstractObject = ((KMLNetworkLink)kMLAbstractFeature).getNetworkResource()) != null && ((KMLRoot)kMLAbstractObject).getFeature() != null) {
            kMLAbstractFeature = ((KMLRoot)kMLAbstractObject).getFeature();
            if (kMLAbstractFeature instanceof KMLDocument) {
                KMLAbstractContainer kMLAbstractContainer = (KMLAbstractContainer)kMLAbstractFeature;
                for (KMLAbstractFeature kMLAbstractFeature2 : kMLAbstractContainer.getFeatures()) {
                    if (kMLAbstractFeature2 == null) continue;
                    this.addFeatureNode(kMLAbstractFeature2);
                }
            } else if (kMLAbstractFeature != null) {
                this.addFeatureNode(kMLAbstractFeature);
            }
        }
    }

    protected void addFeatureNode(KMLAbstractFeature kMLAbstractFeature) {
        KMLFeatureTreeNode kMLFeatureTreeNode = KMLFeatureTreeNode.fromKMLFeature(kMLAbstractFeature);
        if (kMLFeatureTreeNode != null) {
            this.addChild(kMLFeatureTreeNode);
        }
    }

    public void expandOpenContainers(Tree tree) {
        if (tree == null) {
            String string = Logging.getMessage("nullValue.TreeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.mustExpandNode()) {
            tree.expandPath(this.getPath());
        }
        for (TreeNode treeNode : this.getChildren()) {
            if (!(treeNode instanceof KMLFeatureTreeNode)) continue;
            ((KMLFeatureTreeNode)treeNode).expandOpenContainers(tree);
        }
    }

    protected boolean mustExpandNode() {
        if (this.kmlRoot.getFeature() instanceof KMLAbstractContainer) {
            return Boolean.TRUE.equals(this.kmlRoot.getFeature().getOpen());
        }
        return this.kmlRoot.getFeature() != null;
    }

    protected void refresh() {
        this.removeAllChildren();
        this.addChildFeatures();
    }
}

