/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import java.util.HashSet;
import java.util.Set;

public class PerformanceStatistic
implements Comparable<PerformanceStatistic> {
    public static final String ALL = "gov.nasa.worldwind.perfstat.All";
    public static final String AIRSPACE_GEOMETRY_COUNT = "gov.nasa.worldwind.perfstat.AirspaceGeometryCount";
    public static final String AIRSPACE_VERTEX_COUNT = "gov.nasa.worldwind.perfstat.AirspaceVertexCount";
    public static final String FRAME_RATE = "gov.nasa.worldwind.perfstat.FrameRate";
    public static final String FRAME_TIME = "gov.nasa.worldwind.perfstat.FrameTime";
    public static final String IMAGE_TILE_COUNT = "gov.nasa.worldwind.perfstat.ImageTileCount";
    public static final String TERRAIN_TILE_COUNT = "gov.nasa.worldwind.perfstat.TerrainTileCount";
    public static final String MEMORY_CACHE = "gov.nasa.worldwind.perfstat.MemoryCache";
    public static final String PICK_TIME = "gov.nasa.worldwind.perfstat.PickTime";
    public static final String JVM_HEAP = "gov.nasa.worldwind.perfstat.JvmHeap";
    public static final String JVM_HEAP_USED = "gov.nasa.worldwind.perfstat.JvmHeapUsed";
    public static final String TEXTURE_CACHE = "gov.nasa.worldwind.perfstat.TextureCache";
    public static final Set<String> ALL_STATISTICS_SET = new HashSet<String>(1);
    private final String key;
    private final String displayString;
    private final Object value;

    public PerformanceStatistic(String string, String string2, Object object) {
        this.key = string;
        this.displayString = string2;
        this.value = object;
    }

    public String getKey() {
        return this.key;
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public int compareTo(PerformanceStatistic performanceStatistic) {
        if (this.displayString == performanceStatistic.displayString) {
            return 0;
        }
        if (this.displayString != null && performanceStatistic.displayString != null) {
            return this.displayString.compareTo(performanceStatistic.displayString);
        }
        return this.displayString == null ? -1 : 1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PerformanceStatistic performanceStatistic = (PerformanceStatistic)object;
        if (this.displayString != null ? !this.displayString.equals(performanceStatistic.displayString) : performanceStatistic.displayString != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(performanceStatistic.key) : performanceStatistic.key != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(performanceStatistic.value) : performanceStatistic.value != null);
    }

    public int hashCode() {
        int n = this.key != null ? this.key.hashCode() : 0;
        n = 31 * n + (this.displayString != null ? this.displayString.hashCode() : 0);
        n = 31 * n + (this.value != null ? this.value.hashCode() : 0);
        return n;
    }

    public String toString() {
        return this.displayString + " " + this.value.toString();
    }

    static {
        ALL_STATISTICS_SET.add(ALL);
    }
}

