/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import com.jogamp.opengl.util.texture.awt.AWTTextureIO;
import com.jogamp.opengl.util.texture.spi.DDSImage;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWMath;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.media.opengl.GL2;
import javax.media.opengl.GLProfile;

public class OGLUtil {
    public static final int DEFAULT_TEX_ENV_MODE = 8448;
    public static final int DEFAULT_TEXTURE_GEN_MODE = 9216;
    public static final double[] DEFAULT_TEXTURE_GEN_S_OBJECT_PLANE = new double[]{1.0, 0.0, 0.0, 0.0};
    public static final double[] DEFAULT_TEXTURE_GEN_T_OBJECT_PLANE = new double[]{0.0, 1.0, 0.0, 0.0};
    public static final int DEFAULT_SRC0_RGB = 5890;
    public static final int DEFAULT_SRC1_RGB = 34168;
    public static final int DEFAULT_SRC2_RGB = 34166;
    public static final int DEFAULT_SRC0_ALPHA = 5890;
    public static final int DEFAULT_SRC1_ALPHA = 34168;
    public static final int DEFAULT_SRC2_ALPHA = 34166;
    public static final int DEFAULT_COMBINE_ALPHA = 8448;
    public static final int DEFAULT_COMBINE_RGB = 8448;
    protected static final String GL_EXT_BLEND_FUNC_SEPARATE = "GL_EXT_blend_func_separate";
    protected static final Vec4 DEFAULT_LIGHT_DIRECTION = new Vec4(0.0, 0.0, -1.0, 0.0);

    public static void applyBlending(GL2 gL2, boolean bl) {
        if (gL2 == null) {
            String string = Logging.getMessage("nullValue.GLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        gL2.glEnable(3008);
        gL2.glAlphaFunc(516, 0.0f);
        if (bl) {
            gL2.glBlendFunc(1, 771);
        } else {
            boolean bl2 = gL2.isExtensionAvailable(GL_EXT_BLEND_FUNC_SEPARATE);
            if (bl2) {
                gL2.glBlendFuncSeparate(770, 771, 1, 771);
            } else {
                gL2.glBlendFunc(770, 771);
            }
        }
    }

    public static void applyColor(GL2 gL2, Color color, double d, boolean bl) {
        if (gL2 == null) {
            String string = Logging.getMessage("nullValue.GLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.OpacityOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float[] fArray = new float[4];
        color.getRGBComponents(fArray);
        fArray[3] = (float)d;
        if (bl) {
            fArray[0] = fArray[0] * fArray[3];
            fArray[1] = fArray[1] * fArray[3];
            fArray[2] = fArray[2] * fArray[3];
        }
        gL2.glColor4fv(fArray, 0);
    }

    public static void applyColor(GL2 gL2, Color color, boolean bl) {
        if (gL2 == null) {
            String string = Logging.getMessage("nullValue.GLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float[] fArray = new float[4];
        color.getRGBComponents(fArray);
        if (bl) {
            fArray[0] = fArray[0] * fArray[3];
            fArray[1] = fArray[1] * fArray[3];
            fArray[2] = fArray[2] * fArray[3];
        }
        gL2.glColor4fv(fArray, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyLightingDirectionalFromViewer(GL2 gL2, int n, Vec4 vec4) {
        if (gL2 == null) {
            String string = Logging.getMessage("nullValue.GLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4 == null) {
            vec4 = DEFAULT_LIGHT_DIRECTION;
        }
        float[] fArray = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
        float[] fArray2 = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
        float[] fArray3 = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
        float[] fArray4 = new float[]{(float)vec4.x, (float)vec4.y, (float)vec4.z, 0.0f};
        gL2.glLightfv(n, 4608, fArray, 0);
        gL2.glLightfv(n, 4609, fArray2, 0);
        gL2.glLightfv(n, 4610, fArray3, 0);
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        oGLStackHandler.pushModelviewIdentity(gL2);
        try {
            gL2.glLightfv(n, 4611, fArray4, 0);
        }
        finally {
            oGLStackHandler.pop(gL2);
        }
    }

    public static int computeTexturePixelFormat(int n) {
        switch (n) {
            case 6406: 
            case 32827: 
            case 32828: 
            case 32829: 
            case 32830: 
            case 34025: {
                return 6406;
            }
            case 6409: 
            case 32831: 
            case 32832: 
            case 32833: 
            case 32834: 
            case 34026: 
            case 35910: 
            case 35911: {
                return 6409;
            }
            case 6410: 
            case 32835: 
            case 32836: 
            case 32837: 
            case 32838: 
            case 32839: 
            case 32840: 
            case 34027: 
            case 35908: 
            case 35909: {
                return 6410;
            }
            case 6402: 
            case 32841: 
            case 32842: 
            case 32843: 
            case 32844: 
            case 32845: 
            case 33189: 
            case 33190: 
            case 33191: 
            case 34028: {
                return 6403;
            }
            case 6407: 
            case 10768: 
            case 32847: 
            case 32848: 
            case 32849: 
            case 32850: 
            case 32851: 
            case 32852: 
            case 34029: 
            case 35904: 
            case 35905: {
                return 6407;
            }
            case 6408: 
            case 32853: 
            case 32854: 
            case 32855: 
            case 32856: 
            case 32857: 
            case 32858: 
            case 32859: 
            case 34030: 
            case 35906: 
            case 35907: {
                return 6408;
            }
        }
        return 0;
    }

    public static int estimateTextureMemorySize(int n, int n2, int n3, boolean bl) {
        if (n2 < 0) {
            String string = Logging.getMessage("Geom.WidthInvalid", n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n3 < 0) {
            String string = Logging.getMessage("Geom.HeightInvalid", n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n4 = n2 * n3;
        if (bl) {
            int n5 = Math.max((int)WWMath.logBase2(n2), (int)WWMath.logBase2(n3));
            for (int i = 1; i <= n5; ++i) {
                int n6 = Math.max(n2 >> i, 1);
                int n7 = Math.max(n3 >> i, 1);
                n4 += n6 * n7;
            }
        }
        switch (n) {
            case 32827: 
            case 32831: 
            case 32842: {
                return n4 / 2;
            }
            case 6406: 
            case 6409: 
            case 10768: 
            case 32828: 
            case 32832: 
            case 32835: 
            case 32836: 
            case 32841: 
            case 32843: 
            case 32853: 
            case 35910: 
            case 35911: {
                return n4;
            }
            case 32829: 
            case 32833: 
            case 32844: 
            case 32847: {
                return 12 * n4 / 8;
            }
            case 6410: 
            case 32830: 
            case 32834: 
            case 32837: 
            case 32838: 
            case 32845: 
            case 32848: 
            case 32854: 
            case 32855: 
            case 33189: 
            case 35908: 
            case 35909: {
                return 2 * n4;
            }
            case 6402: 
            case 6407: 
            case 32839: 
            case 32849: 
            case 33190: 
            case 35904: 
            case 35905: {
                return 3 * n4;
            }
            case 6408: 
            case 32840: 
            case 32850: 
            case 32856: 
            case 32857: 
            case 33191: 
            case 35906: 
            case 35907: {
                return 4 * n4;
            }
            case 32851: {
                return 36 * n4 / 8;
            }
            case 32852: 
            case 32858: {
                return 6 * n4;
            }
            case 32859: {
                return 8 * n4;
            }
            case 34025: 
            case 34026: 
            case 34027: 
            case 34028: 
            case 34029: 
            case 34030: {
                return 0;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TextureData newTextureData(GLProfile gLProfile, URL uRL, boolean bl) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
        try {
            TextureData textureData = OGLUtil.newTextureData(gLProfile, bufferedInputStream, bl);
            return textureData;
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    public static TextureData newTextureData(GLProfile gLProfile, InputStream inputStream, boolean bl) throws IOException {
        BufferedImage bufferedImage;
        boolean bl2;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (!(bl2 = DDSImage.isDDSImage((InputStream)inputStream)) && (bufferedImage = ImageIO.read(inputStream)) != null) {
            return AWTTextureIO.newTextureData((GLProfile)gLProfile, (BufferedImage)bufferedImage, (boolean)bl);
        }
        return TextureIO.newTextureData((GLProfile)gLProfile, (InputStream)inputStream, (boolean)bl, null);
    }

    public static TextureData newTextureData(GLProfile gLProfile, File file, boolean bl) throws IOException {
        BufferedImage bufferedImage;
        boolean bl2 = "dds".equalsIgnoreCase(WWIO.getSuffix(file.getPath()));
        if (!bl2 && (bufferedImage = ImageIO.read(file)) != null) {
            return AWTTextureIO.newTextureData((GLProfile)gLProfile, (BufferedImage)bufferedImage, (boolean)bl);
        }
        return TextureIO.newTextureData((GLProfile)gLProfile, (File)file, (boolean)bl, null);
    }
}

