/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.ScheduledTaskService;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class BasicScheduledTaskService
extends WWObjectImpl
implements ScheduledTaskService,
Thread.UncaughtExceptionHandler {
    protected static final int DEFAULT_POOL_SIZE = 1;
    protected static final String RUNNING_THREAD_NAME_PREFIX = Logging.getMessage("ThreadedTaskService.RunningThreadNamePrefix");
    protected static final String IDLE_THREAD_NAME_PREFIX = Logging.getMessage("ThreadedTaskService.IdleThreadNamePrefix");
    protected ConcurrentLinkedQueue<Runnable> activeTasks;
    protected ScheduledTaskExecutor executor;

    public BasicScheduledTaskService() {
        Integer n = Configuration.getIntegerValue("gov.nasa.worldwind.avkey.TaskPoolSize", 1);
        this.executor = new ScheduledTaskExecutor(n);
        this.activeTasks = new ConcurrentLinkedQueue();
    }

    @Override
    public void shutdown(boolean bl) {
        if (bl) {
            this.executor.shutdownNow();
        } else {
            this.executor.shutdown();
        }
        this.activeTasks.clear();
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        String string = Logging.getMessage("ThreadedTaskService.UncaughtExceptionDuringTask", thread.getName());
        Logging.logger().fine(string);
        Thread.currentThread().getThreadGroup().uncaughtException(thread, throwable);
    }

    @Override
    public synchronized void addTask(Runnable runnable) {
        if (runnable == null) {
            String string = Logging.getMessage("nullValue.RunnableIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        if (this.activeTasks.contains(runnable) || this.executor.getQueue().contains(runnable)) {
            return;
        }
        this.executor.execute(runnable);
    }

    @Override
    public synchronized ScheduledFuture<?> addScheduledTask(Runnable runnable, long l, TimeUnit timeUnit) {
        if (runnable == null) {
            String string = Logging.getMessage("nullValue.RunnableIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        if (this.activeTasks.contains(runnable) || this.executor.getQueue().contains(runnable)) {
            return null;
        }
        return this.executor.schedule(runnable, l, timeUnit);
    }

    @Override
    public synchronized ScheduledFuture<?> addRepeatingTask(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        if (runnable == null) {
            String string = Logging.getMessage("nullValue.RunnableIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        if (this.activeTasks.contains(runnable) || this.executor.getQueue().contains(runnable)) {
            return null;
        }
        return this.executor.scheduleAtFixedRate(runnable, l, l2, timeUnit);
    }

    protected class ScheduledTaskExecutor
    extends ScheduledThreadPoolExecutor {
        protected ScheduledTaskExecutor(int n) {
            super(n, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable);
                    thread.setDaemon(true);
                    thread.setPriority(1);
                    thread.setUncaughtExceptionHandler(BasicScheduledTaskService.this);
                    return thread;
                }
            }, new ThreadPoolExecutor.DiscardPolicy(){

                public void rejectedExecution(Runnable runnable, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
                    String string = Logging.getMessage("ThreadedTaskService.ResourceRejected", runnable);
                    Logging.logger().fine(string);
                    super.rejectedExecution(runnable, scheduledThreadPoolExecutor);
                }
            });
        }

        @Override
        protected void beforeExecute(Thread thread, Runnable runnable) {
            if (thread == null) {
                String string = Logging.getMessage("nullValue.ThreadIsNull");
                Logging.logger().fine(string);
                throw new IllegalArgumentException(string);
            }
            if (runnable == null) {
                String string = Logging.getMessage("nullValue.RunnableIsNull");
                Logging.logger().fine(string);
                throw new IllegalArgumentException(string);
            }
            if (BasicScheduledTaskService.this.activeTasks.contains(runnable)) {
                String string = Logging.getMessage("ThreadedTaskService.CancellingDuplicateTask", runnable);
                Logging.logger().finer(string);
                thread.interrupt();
                return;
            }
            BasicScheduledTaskService.this.activeTasks.add(runnable);
            if (RUNNING_THREAD_NAME_PREFIX != null) {
                thread.setName(RUNNING_THREAD_NAME_PREFIX + runnable);
            }
            thread.setPriority(1);
            thread.setUncaughtExceptionHandler(BasicScheduledTaskService.this);
            super.beforeExecute(thread, runnable);
        }

        @Override
        protected void afterExecute(Runnable runnable, Throwable throwable) {
            if (runnable == null) {
                String string = Logging.getMessage("nullValue.RunnableIsNull");
                Logging.logger().fine(string);
                throw new IllegalArgumentException(string);
            }
            super.afterExecute(runnable, throwable);
            BasicScheduledTaskService.this.activeTasks.remove(runnable);
            if (throwable == null && IDLE_THREAD_NAME_PREFIX != null) {
                Thread.currentThread().setName(IDLE_THREAD_NAME_PREFIX);
            }
        }
    }
}

