/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.NetworkStatus;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class BasicNetworkStatus
extends AVListImpl
implements NetworkStatus {
    protected static final long DEFAULT_TRY_AGAIN_INTERVAL = 60000L;
    protected static final int DEFAULT_ATTEMPT_LIMIT = 7;
    protected static final long NETWORK_STATUS_REPORT_INTERVAL = 120000L;
    protected static final String[] DEFAULT_NETWORK_TEST_SITES = new String[]{"www.nasa.gov", "worldwind.arc.nasa.gov", "google.com", "microsoft.com", "yahoo.com"};
    private CopyOnWriteArrayList<String> networkTestSites = new CopyOnWriteArrayList();
    private AtomicLong tryAgainInterval = new AtomicLong(60000L);
    private AtomicInteger attemptLimit = new AtomicInteger(7);
    private boolean offlineMode;
    protected ConcurrentHashMap<String, HostInfo> hostMap = new ConcurrentHashMap();
    protected AtomicLong lastUnavailableLogTime = new AtomicLong(System.currentTimeMillis());
    protected AtomicLong lastAvailableLogTime = new AtomicLong(System.currentTimeMillis() + 1L);
    protected AtomicLong lastNetworkCheckTime = new AtomicLong(System.currentTimeMillis());
    protected AtomicLong lastNetworkStatusReportTime = new AtomicLong(0L);
    protected AtomicBoolean lastNetworkUnavailableResult = new AtomicBoolean(false);

    public BasicNetworkStatus() {
        String string = Configuration.getStringValue("gov.nasa.worldwind.avkey.OfflineMode", "false");
        this.offlineMode = string.startsWith("t") || string.startsWith("T");
        this.establishNetworkTestSites();
    }

    protected void establishNetworkTestSites() {
        String string = System.getProperty("gov.nasa.worldwind.avkey.NetworkStatusTestSites");
        if (string == null) {
            string = Configuration.getStringValue("gov.nasa.worldwind.avkey.NetworkStatusTestSites");
        }
        if (string == null) {
            this.networkTestSites.addAll(Arrays.asList(DEFAULT_NETWORK_TEST_SITES));
        } else {
            String[] stringArray = string.split(",");
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = WWUtil.removeWhiteSpace(stringArray[i]);
                if (WWUtil.isEmpty(string2)) continue;
                arrayList.add(string2);
            }
            this.setNetworkTestSites(arrayList);
        }
    }

    @Override
    public boolean isOfflineMode() {
        return this.offlineMode;
    }

    @Override
    public void setOfflineMode(boolean bl) {
        this.offlineMode = bl;
    }

    @Override
    public void setAttemptLimit(int n) {
        if (n < 1) {
            String string = Logging.getMessage("NetworkStatus.InvalidAttemptLimit");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.attemptLimit.set(n);
    }

    @Override
    public void setTryAgainInterval(long l) {
        if (l < 0L) {
            String string = Logging.getMessage("NetworkStatus.InvalidTryAgainInterval");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.tryAgainInterval.set(l);
    }

    @Override
    public int getAttemptLimit() {
        return this.attemptLimit.get();
    }

    @Override
    public long getTryAgainInterval() {
        return this.tryAgainInterval.get();
    }

    @Override
    public List<String> getNetworkTestSites() {
        return new ArrayList<String>(this.networkTestSites);
    }

    @Override
    public void setNetworkTestSites(List<String> list) {
        this.networkTestSites.clear();
        if (list != null) {
            this.networkTestSites.addAll(list);
        }
    }

    @Override
    public synchronized void logUnavailableHost(URL uRL) {
        if (this.offlineMode) {
            return;
        }
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = uRL.getHost();
        HostInfo hostInfo = this.hostMap.get(string);
        if (hostInfo != null) {
            if (!hostInfo.isUnavailable()) {
                hostInfo.logCount.incrementAndGet();
                if (hostInfo.isUnavailable()) {
                    this.firePropertyChange("gov.nasa.worldwind.util.NetworkStatus.HostUnavailable", null, uRL);
                }
            }
            hostInfo.lastLogTime.set(System.currentTimeMillis());
        } else {
            hostInfo = new HostInfo(this.attemptLimit.get(), this.tryAgainInterval.get());
            hostInfo.logCount.set(1);
            if (hostInfo.isUnavailable()) {
                this.firePropertyChange("gov.nasa.worldwind.util.NetworkStatus.HostUnavailable", null, uRL);
            }
            this.hostMap.put(string, hostInfo);
        }
        this.lastUnavailableLogTime.set(System.currentTimeMillis());
    }

    @Override
    public synchronized void logAvailableHost(URL uRL) {
        if (this.offlineMode) {
            return;
        }
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = uRL.getHost();
        HostInfo hostInfo = this.hostMap.get(string);
        if (hostInfo != null) {
            this.hostMap.remove(string);
            this.firePropertyChange("gov.nasa.worldwind.util.NetworkStatus.HostAvailable", null, uRL);
        }
        this.lastAvailableLogTime.set(System.currentTimeMillis());
    }

    @Override
    public synchronized boolean isHostUnavailable(URL uRL) {
        if (this.offlineMode) {
            return true;
        }
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = uRL.getHost();
        HostInfo hostInfo = this.hostMap.get(string);
        if (hostInfo == null) {
            return false;
        }
        if (hostInfo.isTimeToTryAgain()) {
            hostInfo.logCount.set(0);
            return false;
        }
        return hostInfo.isUnavailable();
    }

    @Override
    public boolean isNetworkUnavailable() {
        return this.offlineMode || this.isNetworkUnavailable(10000L);
    }

    @Override
    public synchronized boolean isNetworkUnavailable(long l) {
        if (this.offlineMode) {
            return true;
        }
        if (this.lastAvailableLogTime.get() > this.lastUnavailableLogTime.get()) {
            this.lastNetworkUnavailableResult.set(false);
            return this.lastNetworkUnavailableResult.get();
        }
        long l2 = System.currentTimeMillis();
        if (!this.lastNetworkUnavailableResult.get() && l2 - this.lastAvailableLogTime.get() < l) {
            return this.lastNetworkUnavailableResult.get();
        }
        if (l2 - this.lastNetworkCheckTime.get() < l) {
            return this.lastNetworkUnavailableResult.get();
        }
        this.lastNetworkCheckTime.set(l2);
        if (!this.isWorldWindServerUnavailable()) {
            this.lastNetworkUnavailableResult.set(false);
            return this.lastNetworkUnavailableResult.get();
        }
        for (String string : this.networkTestSites) {
            if (!BasicNetworkStatus.isHostReachable(string)) continue;
            this.lastNetworkUnavailableResult.set(false);
            return this.lastNetworkUnavailableResult.get();
        }
        if (l2 - this.lastNetworkStatusReportTime.get() > 120000L) {
            this.lastNetworkStatusReportTime.set(l2);
            String string = Logging.getMessage("NetworkStatus.NetworkUnreachable");
            Logging.logger().info(string);
        }
        this.lastNetworkUnavailableResult.set(true);
        return this.lastNetworkUnavailableResult.get();
    }

    @Override
    public boolean isWorldWindServerUnavailable() {
        return this.offlineMode || !BasicNetworkStatus.isHostReachable("worldwind.arc.nasa.gov");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isHostReachable(String string) {
        try {
            InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            String string2 = Logging.getMessage("NetworkStatus.UnreachableTestHost", string);
            Logging.logger().fine(string2);
            return false;
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("NetworkStatus.ExceptionTestingHost", string);
            Logging.logger().info(string3);
            return false;
        }
        URLConnection uRLConnection = null;
        try {
            URL uRL = new URL("http://" + string);
            Proxy proxy = WWIO.configureProxy();
            uRLConnection = proxy != null ? uRL.openConnection(proxy) : uRL.openConnection();
            uRLConnection.setConnectTimeout(2000);
            uRLConnection.setReadTimeout(2000);
            String string4 = uRLConnection.getContentType();
            if (string4 != null) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
            String string5 = Logging.getMessage("NetworkStatus.ExceptionTestingHost", string);
            Logging.logger().info(string5);
        }
        finally {
            if (uRLConnection != null && uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).disconnect();
            }
        }
        return false;
    }

    protected static class HostInfo {
        protected final long tryAgainInterval;
        protected final int attemptLimit;
        protected AtomicInteger logCount = new AtomicInteger();
        protected AtomicLong lastLogTime = new AtomicLong();

        protected HostInfo(int n, long l) {
            this.lastLogTime.set(System.currentTimeMillis());
            this.logCount.set(1);
            this.tryAgainInterval = l;
            this.attemptLimit = n;
        }

        protected boolean isUnavailable() {
            return this.logCount.get() >= this.attemptLimit;
        }

        protected boolean isTimeToTryAgain() {
            return System.currentTimeMillis() - this.lastLogTime.get() >= this.tryAgainInterval;
        }
    }
}

