/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.terrain;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.ogc.wms.WMSCapabilities;
import gov.nasa.worldwind.retrieve.AbstractRetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.HTTPRetriever;
import gov.nasa.worldwind.terrain.BasicElevationModel;
import gov.nasa.worldwind.util.DataConfigurationUtils;
import gov.nasa.worldwind.util.Level;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.TileUrlBuilder;
import gov.nasa.worldwind.util.WWIO;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WMSBasicElevationModel
extends BasicElevationModel {
    private static final String[] formatOrderPreference = new String[]{"application/bil32", "application/bil16", "application/bil", "image/bil", "image/png", "image/tiff"};

    public WMSBasicElevationModel(AVList aVList) {
        super(aVList);
    }

    public WMSBasicElevationModel(Element element, AVList aVList) {
        this(WMSBasicElevationModel.wmsGetParamsFromDocument(element, aVList));
    }

    public WMSBasicElevationModel(WMSCapabilities wMSCapabilities, AVList aVList) {
        this(WMSBasicElevationModel.wmsGetParamsFromCapsDoc(wMSCapabilities, aVList));
    }

    public WMSBasicElevationModel(String string) {
        super(WMSBasicElevationModel.wmsRestorableStateToParams(string));
        RestorableSupport restorableSupport;
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string2 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2, exception);
        }
        this.doRestoreState(restorableSupport, null);
    }

    protected static AVList wmsGetParamsFromDocument(Element element, AVList aVList) {
        if (element == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        DataConfigurationUtils.getWMSLayerConfigParams(element, aVList);
        BasicElevationModel.getBasicElevationModelConfigParams(element, aVList);
        WMSBasicElevationModel.wmsSetFallbacks(aVList);
        aVList.setValue("gov.nasa.worldwind.avkey.TileURLBuilder", new URLBuilder(aVList.getStringValue("gov.nasa.worldwind.avkey.WMSVersion"), aVList));
        return aVList;
    }

    protected static AVList wmsGetParamsFromCapsDoc(WMSCapabilities wMSCapabilities, AVList aVList) {
        String string;
        if (wMSCapabilities == null) {
            String string2 = Logging.getMessage("nullValue.WMSCapabilities");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (aVList == null) {
            String string3 = Logging.getMessage("nullValue.ElevationModelConfigParams");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        try {
            string = wMSCapabilities.getVersion();
            WMSBasicElevationModel.getWMSElevationModelConfigParams(wMSCapabilities, formatOrderPreference, aVList);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string4 = Logging.getMessage("WMS.MissingLayerParameters");
            Logging.logger().log(java.util.logging.Level.SEVERE, string4, illegalArgumentException);
            throw new IllegalArgumentException(string4, illegalArgumentException);
        }
        catch (WWRuntimeException wWRuntimeException) {
            String string5 = Logging.getMessage("WMS.MissingCapabilityValues");
            Logging.logger().log(java.util.logging.Level.SEVERE, string5, wWRuntimeException);
            throw new IllegalArgumentException(string5, wWRuntimeException);
        }
        WMSBasicElevationModel.wmsSetFallbacks(aVList);
        aVList.setValue("gov.nasa.worldwind.avkey.TileURLBuilder", new URLBuilder(string, aVList));
        return aVList;
    }

    protected static void wmsSetFallbacks(AVList aVList) {
        if (aVList.getValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta") == null) {
            Angle angle = Angle.fromDegrees(20.0);
            aVList.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", new LatLon(angle, angle));
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.TileWidthKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileWidthKey", 150);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.TileHeightKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileHeightKey", 150);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.FormatSuffixKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", ".bil");
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.MissingDataFlag") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.MissingDataFlag", -9999.0);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.NumLevels") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.NumLevels", 18);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.NumEmptyLevels") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", 0);
        }
    }

    public static AVList getWMSElevationModelConfigParams(WMSCapabilities wMSCapabilities, String[] stringArray, AVList aVList) {
        String string;
        if (wMSCapabilities == null) {
            String string2 = Logging.getMessage("nullValue.WMSCapabilities");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (aVList == null) {
            String string3 = Logging.getMessage("nullValue.ElevationModelConfigParams");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        DataConfigurationUtils.getWMSLayerConfigParams(wMSCapabilities, stringArray, aVList);
        String string4 = aVList.getStringValue("gov.nasa.worldwind.avkey.LayerNames");
        if (string4 == null || string4.length() == 0) {
            String string5 = Logging.getMessage("nullValue.WMSLayerNames");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        String[] stringArray2 = string4.split(",");
        if (stringArray2 == null || stringArray2.length == 0) {
            String string6 = Logging.getMessage("nullValue.WMSLayerNames");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        Double[] doubleArray = wMSCapabilities.getLayerExtremeElevations(wMSCapabilities, stringArray2);
        Double d = (Double)aVList.getValue("gov.nasa.worldwind.avkey.ElevationMinKey");
        if (d == null && doubleArray != null && doubleArray[0] != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ElevationMinKey", doubleArray[0]);
        }
        if ((d = (Double)aVList.getValue("gov.nasa.worldwind.avkey.ElevationMaxKey")) == null && doubleArray != null && doubleArray[1] != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ElevationMaxKey", doubleArray[1]);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.DataType") == null && aVList.getValue("gov.nasa.worldwind.avkey.ImageFormat") != null && (string = WWIO.makeDataTypeForMimeType(aVList.getValue("gov.nasa.worldwind.avkey.ImageFormat").toString())) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.DataType", string);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.DataType") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.Int16");
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.ByteOrder") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ByteOrder", "gov.nasa.worldwind.avkey.LittleEndian");
        }
        return aVList;
    }

    @Override
    protected Document createConfigurationDocument(AVList aVList) {
        Document document = super.createConfigurationDocument(aVList);
        if (document == null || document.getDocumentElement() == null) {
            return document;
        }
        DataConfigurationUtils.createWMSLayerConfigElements(aVList, document.getDocumentElement());
        return document;
    }

    @Override
    public void composeElevations(Sector sector, List<? extends LatLon> list, int n, double[] dArray) throws Exception {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.LatLonListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ElevationsBufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray.length < list.size() || n > list.size()) {
            String string = Logging.getMessage("ElevationModel.ElevationsBufferTooSmall", list.size());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ElevationCompositionTile elevationCompositionTile = new ElevationCompositionTile(sector, this.getLevels().getLastLevel(), n, list.size() / n);
        this.downloadElevations(elevationCompositionTile);
        elevationCompositionTile.setElevations(this.readElevations(elevationCompositionTile.getFile().toURI().toURL()), this);
        for (int i = 0; i < list.size(); ++i) {
            double d;
            LatLon latLon = list.get(i);
            if (latLon == null || (d = this.lookupElevation(latLon.getLatitude(), latLon.getLongitude(), elevationCompositionTile)) == this.getMissingDataSignal()) continue;
            dArray[i] = d;
        }
    }

    protected void downloadElevations(ElevationCompositionTile elevationCompositionTile) throws Exception {
        URL uRL = elevationCompositionTile.getResourceURL();
        HTTPRetriever hTTPRetriever = new HTTPRetriever(uRL, new CompositionRetrievalPostProcessor(elevationCompositionTile.getFile()));
        hTTPRetriever.setConnectTimeout(10000);
        hTTPRetriever.setReadTimeout(60000);
        hTTPRetriever.call();
    }

    @Override
    public void getRestorableStateForAVPair(String string, Object object, RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        if (object instanceof URLBuilder) {
            restorableSupport.addStateValueAsString(stateObject, "wms.Version", ((URLBuilder)object).wmsVersion);
            restorableSupport.addStateValueAsString(stateObject, "wms.Crs", ((URLBuilder)object).crs);
        } else {
            super.getRestorableStateForAVPair(string, object, restorableSupport, stateObject);
        }
    }

    protected static AVList wmsRestorableStateToParams(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        AVListImpl aVListImpl = new AVListImpl();
        WMSBasicElevationModel.wmsRestoreStateForParams(restorableSupport, null, aVListImpl);
        return aVListImpl;
    }

    protected static void wmsRestoreStateForParams(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject, AVList aVList) {
        WMSBasicElevationModel.restoreStateForParams(restorableSupport, null, aVList);
        String string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.ImageFormat");
        if (string != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ImageFormat", string);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.Title")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.Title", string);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.DisplayName")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.DisplayName", string);
        }
        RestorableSupport.adjustTitleAndDisplayName(aVList);
        string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.LayerNames");
        if (string != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.LayerNames", string);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.StyleNames")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.StyleNames", string);
        }
        string = restorableSupport.getStateValueAsString(stateObject, "wms.Version");
        aVList.setValue("gov.nasa.worldwind.avkey.TileURLBuilder", new URLBuilder(string, aVList));
    }

    protected static class CompositionRetrievalPostProcessor
    extends AbstractRetrievalPostProcessor {
        protected File outFile;

        public CompositionRetrievalPostProcessor(File file) {
            this.outFile = file;
        }

        @Override
        protected File doGetOutputFile() {
            return this.outFile;
        }

        @Override
        protected boolean overwriteExistingFile() {
            return true;
        }

        @Override
        protected boolean isDeleteOnExit(File file) {
            return file.getPath().contains("WWJDeleteOnExit");
        }
    }

    private static class ElevationCompositionTile
    extends BasicElevationModel.ElevationTile {
        private int width;
        private int height;
        private File file;

        public ElevationCompositionTile(Sector sector, Level level, int n, int n2) throws IOException {
            super(sector, level, -1, -1);
            this.width = n;
            this.height = n2;
            this.file = File.createTempFile("WWJDeleteOnExit", level.getFormatSuffix());
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public String getPath() {
            return this.file.getPath();
        }

        public File getFile() {
            return this.file;
        }
    }

    protected static class URLBuilder
    implements TileUrlBuilder {
        protected static final String MAX_VERSION = "1.3";
        private final String layerNames;
        private final String styleNames;
        private final String imageFormat;
        private final String wmsVersion;
        private final String crs;
        protected String URLTemplate = null;

        protected URLBuilder(String string, AVList aVList) {
            Double d = (Double)aVList.getValue("gov.nasa.worldwind.avkey.MissingDataFlag");
            this.layerNames = aVList.getStringValue("gov.nasa.worldwind.avkey.LayerNames");
            this.styleNames = aVList.getStringValue("gov.nasa.worldwind.avkey.StyleNames");
            this.imageFormat = aVList.getStringValue("gov.nasa.worldwind.avkey.ImageFormat");
            if (string == null || string.compareTo(MAX_VERSION) >= 0) {
                this.wmsVersion = MAX_VERSION;
                this.crs = "&crs=CRS:84";
            } else {
                this.wmsVersion = string;
                this.crs = "&srs=EPSG:4326";
            }
        }

        @Override
        public URL getURL(Tile tile, String string) throws MalformedURLException {
            StringBuffer stringBuffer;
            if (this.URLTemplate == null) {
                stringBuffer = new StringBuffer(tile.getLevel().getService());
                if (!stringBuffer.toString().toLowerCase().contains("service=wms")) {
                    stringBuffer.append("service=WMS");
                }
                stringBuffer.append("&request=GetMap");
                stringBuffer.append("&version=");
                stringBuffer.append(this.wmsVersion);
                stringBuffer.append(this.crs);
                stringBuffer.append("&layers=");
                stringBuffer.append(this.layerNames);
                stringBuffer.append("&styles=");
                stringBuffer.append(this.styleNames != null ? this.styleNames : "");
                stringBuffer.append("&format=");
                if (string == null) {
                    stringBuffer.append(this.imageFormat);
                } else {
                    stringBuffer.append(string);
                }
                this.URLTemplate = stringBuffer.toString();
            } else {
                stringBuffer = new StringBuffer(this.URLTemplate);
            }
            stringBuffer.append("&width=");
            stringBuffer.append(tile.getWidth());
            stringBuffer.append("&height=");
            stringBuffer.append(tile.getHeight());
            Sector sector = tile.getSector();
            stringBuffer.append("&bbox=");
            stringBuffer.append(sector.getMinLongitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMinLatitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMaxLongitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMaxLatitude().getDegrees());
            stringBuffer.append("&");
            return new URL(stringBuffer.toString().replace(" ", "%20"));
        }
    }
}

