/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.terrain;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.event.BulkRetrievalEvent;
import gov.nasa.worldwind.event.BulkRetrievalListener;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.retrieve.BulkRetrievalThread;
import gov.nasa.worldwind.retrieve.RetrievalService;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.terrain.BasicElevationModel;
import gov.nasa.worldwind.util.Level;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.TileKey;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;

public class BasicElevationModelBulkDownloader
extends BulkRetrievalThread {
    protected static final int MAX_TILE_COUNT_PER_REGION = 200;
    protected static final long DEFAULT_AVERAGE_FILE_SIZE = 45000L;
    protected final BasicElevationModel elevationModel;
    protected final int level;
    protected ArrayList<Tile> missingTiles;

    public BasicElevationModelBulkDownloader(BasicElevationModel basicElevationModel, Sector sector, double d, BulkRetrievalListener bulkRetrievalListener) {
        super(basicElevationModel, sector, d, basicElevationModel.getDataFileStore(), bulkRetrievalListener);
        this.elevationModel = basicElevationModel;
        this.level = this.computeLevelForResolution(sector, d);
    }

    public BasicElevationModelBulkDownloader(BasicElevationModel basicElevationModel, Sector sector, double d, FileStore fileStore, BulkRetrievalListener bulkRetrievalListener) {
        super(basicElevationModel, sector, d, fileStore, bulkRetrievalListener);
        this.elevationModel = basicElevationModel;
        this.level = this.computeLevelForResolution(sector, d);
    }

    @Override
    public void run() {
        try {
            this.progress.setTotalCount(this.estimateMissingTilesCount(20));
            this.progress.setTotalSize(this.progress.getTotalCount() * this.estimateAverageTileSize());
            for (int i = 0; i <= this.level; ++i) {
                if (this.elevationModel.getLevels().isLevelEmpty(i)) continue;
                int n = this.computeRegionDivisions(this.sector, i, 200);
                Iterator<Sector> iterator = this.getRegionIterator(this.sector, n);
                while (iterator.hasNext()) {
                    Sector sector = iterator.next();
                    this.missingTiles = this.getMissingTilesInSector(sector, i);
                    while (this.missingTiles.size() > 0) {
                        this.submitMissingTilesRequests();
                        if (this.missingTiles.size() <= 0) continue;
                        Thread.sleep(this.RETRIEVAL_SERVICE_POLL_DELAY);
                    }
                }
            }
            this.progress.setTotalCount(this.progress.getCurrentCount());
            this.progress.setTotalSize(this.progress.getCurrentSize());
        }
        catch (InterruptedException interruptedException) {
            String string = Logging.getMessage("generic.BulkRetrievalInterrupted", this.elevationModel.getName());
            Logging.logger().log(java.util.logging.Level.WARNING, string, interruptedException);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionDuringBulkRetrieval", this.elevationModel.getName());
            Logging.logger().severe(string);
            throw new RuntimeException(string);
        }
    }

    protected synchronized void submitMissingTilesRequests() throws InterruptedException {
        RetrievalService retrievalService = WorldWind.getRetrievalService();
        int n = 0;
        while (this.missingTiles.size() > n && retrievalService.isAvailable()) {
            Thread.sleep(1L);
            Tile tile = this.missingTiles.get(n);
            if (this.elevationModel.getLevels().isResourceAbsent(tile)) {
                this.removeAbsentTile(tile);
                continue;
            }
            URL uRL = this.fileStore.findFile(tile.getPath(), false);
            if (uRL != null) {
                this.removeRetrievedTile(tile);
                continue;
            }
            this.elevationModel.downloadElevations(tile, new BulkDownloadPostProcessor(tile, this.elevationModel, this.fileStore));
            ++n;
        }
    }

    protected void callRetrievalListeners(Retriever retriever, Tile tile) {
        String string = retriever.getState().equals("gov.nasa.worldwind.RetrieverStatusSuccessful") ? BulkRetrievalEvent.RETRIEVAL_SUCCEEDED : BulkRetrievalEvent.RETRIEVAL_FAILED;
        super.callRetrievalListeners(new BulkRetrievalEvent(this.elevationModel, string, tile.getPath()));
    }

    protected synchronized void removeRetrievedTile(Tile tile) {
        this.missingTiles.remove(tile);
        this.progress.setCurrentCount(this.progress.getCurrentCount() + 1L);
        this.progress.setCurrentSize(this.progress.getCurrentSize() + this.estimateAverageTileSize());
        this.progress.setLastUpdateTime(System.currentTimeMillis());
        this.normalizeProgress();
    }

    protected synchronized void removeAbsentTile(Tile tile) {
        this.missingTiles.remove(tile);
        this.progress.setTotalCount(this.progress.getTotalCount() - 1L);
        this.progress.setTotalSize(this.progress.getTotalSize() - this.estimateAverageTileSize());
        this.progress.setLastUpdateTime(System.currentTimeMillis());
        this.normalizeProgress();
    }

    protected void normalizeProgress() {
        if (this.progress.getTotalCount() < this.progress.getCurrentCount()) {
            this.progress.setTotalCount(this.progress.getCurrentCount());
            this.progress.setTotalSize(this.progress.getCurrentSize());
        }
    }

    protected long getEstimatedMissingDataSize() {
        long l = this.estimateMissingTilesCount(6);
        long l2 = this.estimateAverageTileSize();
        return l * l2;
    }

    protected long estimateMissingTilesCount(int n) {
        int n2;
        int n3 = this.computeLevelForResolution(this.sector, this.resolution);
        long l = 0L;
        for (n2 = 0; n2 <= n3; ++n2) {
            if (this.elevationModel.getLevels().isLevelEmpty(n2)) continue;
            l += this.countTilesInSector(this.sector, n2);
        }
        n2 = this.computeRegionDivisions(this.sector, n3, 36);
        Sector[] sectorArray = this.computeRandomRegions(this.sector, n2, n);
        long l2 = 0L;
        long l3 = 0L;
        try {
            if (sectorArray.length < n) {
                l3 = this.countTilesInSector(this.sector, n3);
                l2 = this.getMissingTilesInSector(this.sector, n3).size();
            } else {
                for (Sector sector : sectorArray) {
                    l3 += this.countTilesInSector(sector, n3);
                    l2 += (long)this.getMissingTilesInSector(sector, n3).size();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            return 0L;
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionDuringDataSizeEstimate", this.getName());
            Logging.logger().severe(string);
            throw new RuntimeException(string);
        }
        return (long)((double)l * ((double)l2 / (double)l3));
    }

    protected long estimateAverageTileSize() {
        Object object;
        Long l = (Long)this.elevationModel.getValue("gov.nasa.worldwind.avkey.AverageTileSize");
        if (l != null) {
            return l;
        }
        long l2 = 0L;
        int n = 0;
        Level level = this.elevationModel.getLevels().getFirstLevel();
        while (level.isEmpty() && !level.equals(this.elevationModel.getLevels().getLastLevel())) {
            level = this.elevationModel.getLevels().getLevel(level.getLevelNumber() + 1);
        }
        File file = new File(this.fileStore.getWriteLocation(), level.getPath());
        if (file.exists()) {
            for (File file2 : object = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory();
                }
            })) {
                long l3 = BasicElevationModelBulkDownloader.computeAverageTileSize(file2);
                if (l3 > 0L) {
                    l2 += l3;
                    ++n;
                }
                if (n >= 2) break;
            }
        }
        object = Long.valueOf(45000L);
        if (n > 0 && l2 > 0L) {
            object = l2 / (long)n;
            this.elevationModel.setValue("gov.nasa.worldwind.avkey.AverageTileSize", object);
        }
        return object.longValue();
    }

    protected static long computeAverageTileSize(File file) {
        File[] fileArray;
        long l = 0L;
        int n = 0;
        for (File file2 : fileArray = file.listFiles()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file2);
                l += (long)fileInputStream.available();
                fileInputStream.close();
                ++n;
            }
            catch (IOException iOException) {
                n += 0;
            }
        }
        return n > 0 ? l / (long)n : 0L;
    }

    protected int computeLevelForResolution(Sector sector, double d) {
        double d2;
        Level level;
        double d3;
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Level level2 = this.elevationModel.getLevels().getLastLevel();
        for (int i = 0; i < this.elevationModel.getLevels().getLastLevel().getLevelNumber(); ++i) {
            double d4;
            if (this.elevationModel.getLevels().isLevelEmpty(i) || (d4 = this.elevationModel.getLevels().getLevel(i).getTexelSize()) > d) continue;
            level2 = this.elevationModel.getLevels().getLevel(i);
            break;
        }
        if (level2.getLevelNumber() != 0 && !this.elevationModel.getLevels().isLevelEmpty(level2.getLevelNumber() - 1) && (d3 = Math.abs((level = this.elevationModel.getLevels().getLevel(level2.getLevelNumber() - 1)).getTexelSize() - d)) < (d2 = Math.abs(level2.getTexelSize() - d))) {
            level2 = level;
        }
        return level2.getLevelNumber();
    }

    protected long countTilesInSector(Sector sector, int n) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Level level = this.elevationModel.getLevels().getLastLevel();
        if (n >= 0) {
            for (int i = n; i < this.elevationModel.getLevels().getLastLevel().getLevelNumber(); ++i) {
                if (this.elevationModel.getLevels().isLevelEmpty(i)) continue;
                level = this.elevationModel.getLevels().getLevel(i);
                break;
            }
        }
        LatLon latLon = level.getTileDelta();
        LatLon latLon2 = this.elevationModel.getLevels().getTileOrigin();
        int n2 = Tile.computeRow(latLon.getLatitude(), sector.getMaxLatitude(), latLon2.getLatitude());
        int n3 = Tile.computeColumn(latLon.getLongitude(), sector.getMinLongitude(), latLon2.getLongitude());
        int n4 = Tile.computeRow(latLon.getLatitude(), sector.getMinLatitude(), latLon2.getLatitude());
        int n5 = Tile.computeColumn(latLon.getLongitude(), sector.getMaxLongitude(), latLon2.getLongitude());
        long l = n2 - n4 + 1;
        long l2 = n5 - n3 + 1;
        return l * l2;
    }

    protected Tile[][] getTilesInSector(Sector sector, int n) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Level level = this.elevationModel.getLevels().getLastLevel();
        if (n >= 0) {
            for (int i = n; i < this.elevationModel.getLevels().getLastLevel().getLevelNumber(); ++i) {
                if (this.elevationModel.getLevels().isLevelEmpty(i)) continue;
                level = this.elevationModel.getLevels().getLevel(i);
                break;
            }
        }
        LatLon latLon = level.getTileDelta();
        LatLon latLon2 = this.elevationModel.getLevels().getTileOrigin();
        int n2 = Tile.computeRow(latLon.getLatitude(), sector.getMaxLatitude(), latLon2.getLatitude());
        int n3 = Tile.computeColumn(latLon.getLongitude(), sector.getMinLongitude(), latLon2.getLongitude());
        int n4 = Tile.computeRow(latLon.getLatitude(), sector.getMinLatitude(), latLon2.getLatitude());
        int n5 = Tile.computeColumn(latLon.getLongitude(), sector.getMaxLongitude(), latLon2.getLongitude());
        int n6 = n2 - n4 + 1;
        int n7 = n5 - n3 + 1;
        Tile[][] tileArray = new Tile[n6][n7];
        for (int i = n2; i >= n4; --i) {
            for (int j = n3; j <= n5; ++j) {
                TileKey tileKey = new TileKey(level.getLevelNumber(), i, j, level.getCacheName());
                Sector sector2 = this.elevationModel.getLevels().computeSectorForKey(tileKey);
                tileArray[n2 - i][j - n3] = new Tile(sector2, level, i, j);
            }
        }
        return tileArray;
    }

    protected ArrayList<Tile> getMissingTilesInSector(Sector sector, int n) throws InterruptedException {
        Tile[][] tileArray;
        ArrayList<Tile> arrayList = new ArrayList<Tile>();
        Tile[][] tileArray2 = tileArray = this.getTilesInSector(sector, n);
        int n2 = tileArray2.length;
        for (int i = 0; i < n2; ++i) {
            Tile[] tileArray3;
            for (Tile tile : tileArray3 = tileArray2[i]) {
                Thread.sleep(1L);
                if (tile == null || this.isTileLocalOrAbsent(tile)) continue;
                arrayList.add(tile);
            }
        }
        return arrayList;
    }

    protected int computeRegionDivisions(Sector sector, int n, int n2) {
        long l = this.countTilesInSector(sector, n);
        if (l <= (long)n2) {
            return 1;
        }
        return (int)Math.ceil(Math.sqrt((float)l / (float)n2));
    }

    protected Sector[] computeRandomRegions(Sector sector, int n, int n2) {
        if (n2 > n * n) {
            return sector.subdivide(n);
        }
        double d = sector.getDeltaLat().degrees / (double)n;
        double d2 = sector.getDeltaLon().degrees / (double)n;
        ArrayList<Sector> arrayList = new ArrayList<Sector>(n2);
        Random random = new Random();
        while (arrayList.size() < n2) {
            double d3;
            int n3;
            double d4;
            int n4 = random.nextInt(n);
            Sector sector2 = Sector.fromDegrees(sector.getMinLatitude().degrees + d * (double)n4, d4 = n4 + 1 < n ? sector.getMinLatitude().degrees + d * (double)n4 + d : sector.getMaxLatitude().degrees, sector.getMinLongitude().degrees + d2 * (double)(n3 = random.nextInt(n)), d3 = n3 + 1 < n ? sector.getMinLongitude().degrees + d2 * (double)n3 + d2 : sector.getMaxLongitude().degrees);
            if (arrayList.contains(sector2)) continue;
            arrayList.add(sector2);
        }
        return arrayList.toArray(new Sector[n2]);
    }

    protected Iterator<Sector> getRegionIterator(final Sector sector, final int n) {
        final double d = sector.getDeltaLat().degrees / (double)n;
        final double d2 = sector.getDeltaLon().degrees / (double)n;
        return new Iterator<Sector>(){
            int row = 0;
            int col = 0;

            @Override
            public boolean hasNext() {
                return this.row < n;
            }

            @Override
            public Sector next() {
                double d3 = this.row + 1 < n ? sector.getMinLatitude().degrees + d * (double)this.row + d : sector.getMaxLatitude().degrees;
                double d22 = this.col + 1 < n ? sector.getMinLongitude().degrees + d2 * (double)this.col + d2 : sector.getMaxLongitude().degrees;
                Sector sector2 = Sector.fromDegrees(sector.getMinLatitude().degrees + d * (double)this.row, d3, sector.getMinLongitude().degrees + d2 * (double)this.col, d22);
                ++this.col;
                if (this.col >= n) {
                    this.col = 0;
                    ++this.row;
                }
                return sector2;
            }

            @Override
            public void remove() {
            }
        };
    }

    protected boolean isTileLocalOrAbsent(Tile tile) {
        if (this.elevationModel.getLevels().isResourceAbsent(tile)) {
            return true;
        }
        URL uRL = this.fileStore.findFile(tile.getPath(), false);
        return uRL != null && !this.elevationModel.isFileExpired(tile, uRL, this.fileStore);
    }

    protected class BulkDownloadPostProcessor
    extends BasicElevationModel.DownloadPostProcessor {
        public BulkDownloadPostProcessor(Tile tile, BasicElevationModel basicElevationModel, FileStore fileStore) {
            super(tile, basicElevationModel, fileStore);
        }

        @Override
        public ByteBuffer run(Retriever retriever) {
            ByteBuffer byteBuffer = super.run(retriever);
            if (retriever.getState().equals("gov.nasa.worldwind.RetrieverStatusSuccessful")) {
                BasicElevationModelBulkDownloader.this.removeRetrievedTile(this.tile);
            }
            if (BasicElevationModelBulkDownloader.this.hasRetrievalListeners()) {
                BasicElevationModelBulkDownloader.this.callRetrievalListeners(retriever, this.tile);
            }
            return byteBuffer;
        }
    }
}

