/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.lines;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.PhaseLine;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ForwardLineOfOwnTroops
extends PhaseLine {
    public static final int DEFAULT_NUM_WAVES = 20;
    public static final int DEFAULT_NUM_INTERVALS = 32;
    protected Iterable<? extends Position> positions;
    protected List<Position> computedPositions;
    protected double waveLength;
    protected int intervals = 32;

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-GLF--------");
    }

    public ForwardLineOfOwnTroops(String string) {
        super(string);
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        this.positions = iterable;
        this.computedPositions = null;
    }

    @Override
    public Iterable<? extends Position> getPositions() {
        return this.positions;
    }

    public double getWaveLength() {
        return this.waveLength;
    }

    public void setWaveLength(int n) {
        this.waveLength = n;
        this.onShapeChanged();
    }

    public int getIntervals() {
        return this.intervals;
    }

    public void setIntervals(int n) {
        if (n < 1) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.intervals = n;
        this.onShapeChanged();
    }

    @Override
    public void moveTo(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        this.positions = Position.computeShiftedPositions(position2, position, this.getPositions());
        this.path.moveTo(position);
    }

    @Override
    protected void computeGeometry(DrawContext drawContext) {
        if (this.computedPositions == null && this.positions != null) {
            this.generateIntermediatePositions(drawContext, this.positions);
            this.path.setPositions(this.computedPositions);
        }
        super.computeGeometry(drawContext);
    }

    protected void onShapeChanged() {
        this.computedPositions = null;
    }

    protected void generateIntermediatePositions(DrawContext drawContext, Iterable<? extends Position> iterable) {
        Globe globe = drawContext.getGlobe();
        double d = this.getWaveLength();
        if (d == 0.0) {
            d = this.computeDefaultWavelength(iterable, globe);
        }
        double d2 = d / 2.0 / globe.getRadius();
        PositionIterator positionIterator = new PositionIterator(iterable, d, globe);
        this.computedPositions = this.generateWavePositions(positionIterator, d2, false);
    }

    protected List<Position> generateWavePositions(Iterator<? extends Position> iterator, double d, boolean bl) {
        ArrayList<Position> arrayList = new ArrayList<Position>();
        int n = this.getIntervals();
        int n2 = bl ? -1 : 1;
        Position position = iterator.next();
        while (iterator.hasNext()) {
            Position position2 = iterator.next();
            if (position2 == null) continue;
            LatLon latLon = LatLon.interpolateGreatCircle(0.5, position2, position);
            Angle angle = LatLon.greatCircleAzimuth(position2, position);
            double d2 = Angle.POS180.radians / (double)n;
            for (int i = 0; i < n; ++i) {
                LatLon latLon2 = LatLon.greatCircleEndPosition(latLon, angle.radians + d2 * (double)i * (double)n2, d);
                arrayList.add(new Position(latLon2, 0.0));
            }
            position = position2;
        }
        return arrayList;
    }

    protected double computeDefaultWavelength(Iterable<? extends Position> iterable, Globe globe) {
        Sector sector = Sector.boundingSector(iterable);
        double d = Math.hypot(sector.getDeltaLatRadians(), sector.getDeltaLonRadians());
        return d * globe.getRadius() / 20.0;
    }

    protected Angle computeGreatCirclePathLength(Iterable<? extends Position> iterable) {
        double d = 0.0;
        Position position = null;
        for (Position position2 : iterable) {
            if (position != null) {
                Angle angle = LatLon.greatCircleDistance(position2, position);
                d += angle.radians;
            }
            position = position2;
        }
        return Angle.fromRadians(d);
    }

    @Override
    protected String getGraphicLabel() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mustShowHostileIndicator()) {
            stringBuilder.append("ENY");
            stringBuilder.append("\n");
        }
        stringBuilder.append("FLOT");
        return stringBuilder.toString();
    }

    protected static class PositionIterator
    implements Iterator<Position> {
        protected Iterator<? extends Position> positions;
        protected Angle interval;
        protected double tolerance = 0.25;
        protected Position thisPosition;
        protected Position nextControlPosition;

        protected PositionIterator(Iterable<? extends Position> iterable, double d, Globe globe) {
            if (iterable == null) {
                String string = Logging.getMessage("nullValue.PositionsListIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (globe == null) {
                String string = Logging.getMessage("nullValue.GlobeIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (d <= 0.0) {
                String string = Logging.getMessage("generic.LengthIsInvalid");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.interval = Angle.fromRadians(d / globe.getRadius());
            this.positions = iterable.iterator();
            this.nextControlPosition = this.positions.next();
        }

        @Override
        public boolean hasNext() {
            return this.nextControlPosition != null;
        }

        @Override
        public Position next() {
            if (this.thisPosition == null) {
                this.thisPosition = this.nextControlPosition;
                return this.thisPosition;
            }
            Angle angle = LatLon.greatCircleDistance(this.thisPosition, this.nextControlPosition);
            double d = this.interval.degrees;
            double d2 = angle.degrees - d;
            while (d2 < 0.0) {
                if (!this.positions.hasNext()) {
                    Position position = this.nextControlPosition;
                    this.nextControlPosition = null;
                    if (Math.abs(d2) < this.interval.degrees * this.tolerance) {
                        return position;
                    }
                    return null;
                }
                this.thisPosition = this.nextControlPosition;
                this.nextControlPosition = this.positions.next();
                angle = LatLon.greatCircleDistance(this.thisPosition, this.nextControlPosition);
                d2 = angle.degrees - (d -= angle.degrees);
            }
            Angle angle2 = LatLon.greatCircleAzimuth(this.thisPosition, this.nextControlPosition);
            LatLon latLon = LatLon.greatCircleEndPosition((LatLon)this.thisPosition, angle2, Angle.fromDegrees(d));
            this.thisPosition = new Position(latLon, 0.0);
            return this.thisPosition;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

