/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.areas;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.symbology.TacticalQuad;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.AbstractRectangularGraphic;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.FireSupportTextBuilder;
import gov.nasa.worldwind.util.WWUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RectangularFireSupportArea
extends AbstractRectangularGraphic
implements TacticalQuad,
PreRenderable {
    protected static final String DIAGONAL_FILL_PATH = "images/diagonal-fill-16x16.png";
    protected static final Offset LEFT_ALIGN_OFFSET = new Offset(-0.5, -0.5, "gov.nasa.worldwind.avkey.Fraction", "gov.nasa.worldwind.avkey.Fraction");

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-F-ACSR-------", "G-F-ACFR-------", "G-F-ACRR-------", "G-F-ACAR-------", "G-F-ACER-------", "G-F-ACDR-------", "G-F-ACZR-------", "G-F-ACBR-------", "G-F-ACVR-------", "G-F-ACNR-------", "G-F-AZIR-------", "G-F-AZXR-------", "G-F-AZCR-------", "G-F-AZFR-------", "G-F-AKBR-------", "G-F-AKPR-------");
    }

    public RectangularFireSupportArea(String string) {
        super(string);
    }

    public static Set<String> getGraphicsWithTimeLabel() {
        return new HashSet<String>(Arrays.asList("G-F-ACSR-------", "G-F-ACDR-------", "G-F-ACZR-------", "G-F-ACBR-------", "G-F-ACVR-------", "G-F-ACER-------", "G-F-AZIR-------", "G-F-AZXR-------", "G-F-AZCR-------", "G-F-AZFR-------"));
    }

    @Override
    protected void createLabels() {
        TacticalGraphicLabel tacticalGraphicLabel;
        FireSupportTextBuilder fireSupportTextBuilder = new FireSupportTextBuilder();
        String[] stringArray = fireSupportTextBuilder.createText(this);
        String string = stringArray[0];
        if (!WWUtil.isEmpty(string)) {
            tacticalGraphicLabel = this.addLabel(string);
            tacticalGraphicLabel.setTextAlign(this.getMainLabelTextAlign());
            if (this.isFilled()) {
                tacticalGraphicLabel.setEffect("gov.nasa.worldwind.avkey.TextEffectNone");
                tacticalGraphicLabel.setDrawInterior(true);
            }
        }
        if (stringArray.length > 1 && !WWUtil.isEmpty(stringArray[1])) {
            tacticalGraphicLabel = this.addLabel(stringArray[1]);
            tacticalGraphicLabel.setTextAlign("gov.nasa.worldwind.avkey.Right");
            tacticalGraphicLabel.setOffset(new Offset(0.0, 0.0, "gov.nasa.worldwind.avkey.Fraction", "gov.nasa.worldwind.avkey.Fraction"));
        }
    }

    @Override
    protected void determineLabelPositions(DrawContext drawContext) {
        Position position = new Position(this.quad.getCenter(), 0.0);
        ((TacticalGraphicLabel)this.labels.get(0)).setPosition(position);
        if (this.labels.size() > 1) {
            double d = this.quad.getWidth() / 2.0;
            double d2 = this.quad.getHeight() / 2.0;
            double d3 = drawContext.getGlobe().getRadiusAt(position.getLatitude(), position.getLongitude());
            double d4 = Math.sqrt(d * d + d2 * d2);
            double d5 = d4 / d3;
            double d6 = Math.atan2(-d2, d);
            double d7 = 1.5707963267948966 - (d6 - this.quad.getHeading().radians);
            LatLon latLon = LatLon.greatCircleEndPosition((LatLon)position, d7, d5);
            ((TacticalGraphicLabel)this.labels.get(1)).setPosition(new Position(latLon, 0.0));
        }
    }

    protected String getMainLabelTextAlign() {
        boolean bl = "G-F-ACAR-------".equalsIgnoreCase(this.maskedSymbolCode);
        if (bl) {
            return "gov.nasa.worldwind.avkey.Left";
        }
        return "gov.nasa.worldwind.avkey.Center";
    }

    @Override
    protected Offset getDefaultLabelOffset() {
        boolean bl = "G-F-ACAR-------".equalsIgnoreCase(this.maskedSymbolCode);
        if (bl) {
            return LEFT_ALIGN_OFFSET;
        }
        return super.getDefaultLabelOffset();
    }

    @Override
    protected void applyDefaultAttributes(ShapeAttributes shapeAttributes) {
        super.applyDefaultAttributes(shapeAttributes);
        if (this.isFilled()) {
            shapeAttributes.setDrawInterior(true);
            shapeAttributes.setImageSource(this.getImageSource());
        }
    }

    protected boolean isFilled() {
        return "G-F-ACNR-------".equalsIgnoreCase(this.maskedSymbolCode) || "G-F-AKBR-------".equalsIgnoreCase(this.maskedSymbolCode) || "G-F-AKPR-------".equalsIgnoreCase(this.maskedSymbolCode);
    }

    protected Object getImageSource() {
        return DIAGONAL_FILL_PATH;
    }
}

