/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.areas;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.BasicArea;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.FireSupportTextBuilder;
import gov.nasa.worldwind.util.WWUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IrregularFireSupportArea
extends BasicArea {
    protected static final String DIAGONAL_FILL_PATH = "images/diagonal-fill-16x16.png";
    protected static final Offset LEFT_ALIGN_OFFSET = new Offset(-0.5, -0.5, "gov.nasa.worldwind.avkey.Fraction", "gov.nasa.worldwind.avkey.Fraction");

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-F-AT---------", "G-F-ATB--------", "G-F-ACT--------", "G-F-ACSI-------", "G-F-ACFI-------", "G-F-ACRI-------", "G-F-ACAI-------", "G-F-ACEI-------", "G-F-ACDI-------", "G-F-ACZI-------", "G-F-ACBI-------", "G-F-ACVI-------", "G-F-ACNI-------", "G-F-AZII-------", "G-F-AZXI-------", "G-F-AZCI-------", "G-F-AZFI-------", "G-F-AKBI-------", "G-F-AKPI-------");
    }

    public IrregularFireSupportArea(String string) {
        super(string);
        this.setShowHostileIndicator(false);
    }

    public static Set<String> getGraphicsWithTimeLabel() {
        return new HashSet<String>(Arrays.asList("G-F-ACSI-------", "G-F-ACEI-------", "G-F-ACDI-------", "G-F-ACZI-------", "G-F-ACBI-------", "G-F-ACVI-------", "G-F-AZII-------", "G-F-AZXI-------", "G-F-AZCI-------", "G-F-AZFI-------"));
    }

    @Override
    protected void createLabels() {
        TacticalGraphicLabel tacticalGraphicLabel;
        FireSupportTextBuilder fireSupportTextBuilder = new FireSupportTextBuilder();
        String[] stringArray = fireSupportTextBuilder.createText(this);
        String string = stringArray[0];
        if (!WWUtil.isEmpty(string)) {
            tacticalGraphicLabel = this.addLabel(string);
            tacticalGraphicLabel.setTextAlign(this.getLabelAlignment());
            if (this.isFilled()) {
                tacticalGraphicLabel.setEffect("gov.nasa.worldwind.avkey.TextEffectNone");
                tacticalGraphicLabel.setDrawInterior(true);
            }
        }
        if (stringArray.length > 1 && !WWUtil.isEmpty(stringArray[1])) {
            tacticalGraphicLabel = this.addLabel(stringArray[1]);
            tacticalGraphicLabel.setTextAlign("gov.nasa.worldwind.avkey.Right");
            tacticalGraphicLabel.setOffset(new Offset(0.0, 0.0, "gov.nasa.worldwind.avkey.Fraction", "gov.nasa.worldwind.avkey.Fraction"));
        }
    }

    @Override
    protected void determineLabelPositions(DrawContext drawContext) {
        Position position;
        super.determineLabelPositions(drawContext);
        if (this.labels.size() > 1 && (position = this.computeTimeLabelPosition(drawContext)) != null) {
            ((TacticalGraphicLabel)this.labels.get(1)).setPosition(position);
        }
    }

    protected Position computeTimeLabelPosition(DrawContext drawContext) {
        Iterable<? extends LatLon> iterable = this.polygon.getLocations(drawContext.getGlobe());
        Sector sector = Sector.boundingSector(iterable);
        LatLon latLon = new LatLon(sector.getMaxLatitude(), sector.getMinLongitude());
        Angle angle = Angle.POS180;
        LatLon latLon2 = null;
        for (LatLon latLon3 : iterable) {
            Angle angle2 = LatLon.greatCircleDistance(latLon3, latLon);
            if (angle2.compareTo(angle) >= 0) continue;
            angle = angle2;
            latLon2 = latLon3;
        }
        if (latLon2 != null) {
            return new Position(latLon2, 0.0);
        }
        return null;
    }

    @Override
    protected String getLabelAlignment() {
        boolean bl = "G-F-AZII-------".equalsIgnoreCase(this.maskedSymbolCode);
        if (bl) {
            return "gov.nasa.worldwind.avkey.Left";
        }
        return "gov.nasa.worldwind.avkey.Center";
    }

    @Override
    protected Offset getDefaultLabelOffset() {
        boolean bl = "G-F-AZII-------".equalsIgnoreCase(this.maskedSymbolCode);
        if (bl) {
            return LEFT_ALIGN_OFFSET;
        }
        return super.getDefaultLabelOffset();
    }

    @Override
    protected void applyDefaultAttributes(ShapeAttributes shapeAttributes) {
        super.applyDefaultAttributes(shapeAttributes);
        if (this.isFilled()) {
            shapeAttributes.setDrawInterior(true);
            shapeAttributes.setImageSource(this.getImageSource());
        }
    }

    protected boolean isFilled() {
        return "G-F-ACNI-------".equalsIgnoreCase(this.maskedSymbolCode) || "G-F-AKBI-------".equalsIgnoreCase(this.maskedSymbolCode) || "G-F-AKPI-------".equalsIgnoreCase(this.maskedSymbolCode);
    }

    protected Object getImageSource() {
        return DIAGONAL_FILL_PATH;
    }
}

