/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces;

import gov.nasa.worldwind.Locatable;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.OutlinedShape;
import gov.nasa.worldwind.render.airspaces.Airspace;
import gov.nasa.worldwind.render.airspaces.Geometry;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.PerformanceStatistic;
import java.awt.Color;
import java.awt.Point;
import java.nio.Buffer;
import java.util.Iterator;
import java.util.logging.Level;
import javax.media.opengl.GL2;

public class AirspaceRenderer {
    private static final String EXT_BLEND_FUNC_SEPARATE_STRING = "GL_EXT_blend_func_separate";
    private boolean enableAntialiasing = false;
    private boolean enableBlending = true;
    private boolean enableDepthOffset = false;
    private boolean enableLighting = true;
    private boolean useEXTBlendFuncSeparate = true;
    private boolean haveEXTBlendFuncSeparate = false;
    private boolean drawExtents = false;
    private boolean drawWireframe = false;
    private final PickSupport pickSupport = new PickSupport();
    private double linePickWidth = 8.0;
    private Double depthOffsetFactor;
    private Double depthOffsetUnits;
    protected boolean enableBatchRendering = true;
    protected boolean enableBatchPicking = true;
    protected OutlinedShape outlineShapeRenderer = new OutlinedShape(){

        @Override
        public boolean isDrawOutline(DrawContext drawContext, Object object) {
            return ((Airspace)object).getAttributes().isDrawOutline();
        }

        @Override
        public boolean isDrawInterior(DrawContext drawContext, Object object) {
            return ((Airspace)object).getAttributes().isDrawInterior();
        }

        @Override
        public boolean isEnableDepthOffset(DrawContext drawContext, Object object) {
            return AirspaceRenderer.this.isEnableDepthOffset();
        }

        @Override
        public void drawOutline(DrawContext drawContext, Object object) {
            AirspaceRenderer.this.drawAirspaceOutline(drawContext, (Airspace)object);
        }

        @Override
        public void drawInterior(DrawContext drawContext, Object object) {
            AirspaceRenderer.this.drawAirspaceInterior(drawContext, (Airspace)object);
        }

        @Override
        public Double getDepthOffsetFactor(DrawContext drawContext, Object object) {
            return AirspaceRenderer.this.getDepthOffsetFactor();
        }

        @Override
        public Double getDepthOffsetUnits(DrawContext drawContext, Object object) {
            return AirspaceRenderer.this.getDepthOffsetUnits();
        }
    };

    public boolean isEnableAntialiasing() {
        return this.enableAntialiasing;
    }

    public void setEnableAntialiasing(boolean bl) {
        this.enableAntialiasing = bl;
    }

    public boolean isEnableBlending() {
        return this.enableBlending;
    }

    public void setEnableBlending(boolean bl) {
        this.enableBlending = bl;
    }

    public boolean isEnableDepthOffset() {
        return this.enableDepthOffset;
    }

    public void setEnableDepthOffset(boolean bl) {
        this.enableDepthOffset = bl;
    }

    public boolean isEnableLighting() {
        return this.enableLighting;
    }

    public void setEnableLighting(boolean bl) {
        this.enableLighting = bl;
    }

    public boolean isUseEXTBlendFuncSeparate() {
        return this.useEXTBlendFuncSeparate;
    }

    public void setUseEXTBlendFuncSeparate(boolean bl) {
        this.useEXTBlendFuncSeparate = bl;
    }

    protected boolean isHaveEXTBlendFuncSeparate() {
        return this.haveEXTBlendFuncSeparate;
    }

    protected void setHaveEXTBlendFuncSeparate(boolean bl) {
        this.haveEXTBlendFuncSeparate = bl;
    }

    public boolean isDrawExtents() {
        return this.drawExtents;
    }

    public void setDrawExtents(boolean bl) {
        this.drawExtents = bl;
    }

    public boolean isDrawWireframe() {
        return this.drawWireframe;
    }

    public void setDrawWireframe(boolean bl) {
        this.drawWireframe = bl;
    }

    public double getLinePickWidth() {
        return this.linePickWidth;
    }

    public void setLinePickWidth(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "width < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.linePickWidth = d;
    }

    public Double getDepthOffsetFactor() {
        return this.depthOffsetFactor;
    }

    public void setDepthOffsetFactor(Double d) {
        this.depthOffsetFactor = d;
    }

    public Double getDepthOffsetUnits() {
        return this.depthOffsetUnits;
    }

    public void setDepthOffsetUnits(Double d) {
        this.depthOffsetUnits = d;
    }

    public PickSupport getPickSupport() {
        return this.pickSupport;
    }

    public boolean isEnableBatchRendering() {
        return this.enableBatchRendering;
    }

    public void setEnableBatchRendering(boolean bl) {
        this.enableBatchRendering = bl;
    }

    public boolean isEnableBatchPicking() {
        return this.enableBatchPicking;
    }

    public void setEnableBatchPicking(boolean bl) {
        this.enableBatchPicking = bl;
    }

    public void renderOrdered(DrawContext drawContext, Iterable<? extends Airspace> iterable) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.AirspaceIterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.drawOrdered(drawContext, iterable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pickNow(DrawContext drawContext, Iterable<? extends Airspace> iterable, Point point, Layer layer) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.AirspaceIterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        PickSupport pickSupport = this.getPickSupport();
        pickSupport.clearPickList();
        pickSupport.beginPicking(drawContext);
        this.beginRendering(drawContext);
        try {
            this.drawNow(drawContext, iterable, pickSupport);
        }
        finally {
            this.endRendering(drawContext);
            pickSupport.endPicking(drawContext);
            pickSupport.resolvePick(drawContext, point, layer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderNow(DrawContext drawContext, Iterable<? extends Airspace> iterable) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.AirspaceIterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.beginRendering(drawContext);
        try {
            this.drawNow(drawContext, iterable, null);
        }
        finally {
            this.endRendering(drawContext);
        }
    }

    protected void drawOrdered(DrawContext drawContext, Iterable<? extends Airspace> iterable) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.AirspaceIterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (Airspace airspace : iterable) {
            if (!airspace.isVisible() || !airspace.isAirspaceVisible(drawContext)) continue;
            airspace.makeOrderedRenderable(drawContext, this);
        }
    }

    protected void drawNow(DrawContext drawContext, Iterable<? extends Airspace> iterable, PickSupport pickSupport) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.AirspaceIterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (Airspace airspace : iterable) {
            if (airspace == null || !airspace.isVisible() || !airspace.isAirspaceVisible(drawContext)) continue;
            this.drawAirspace(drawContext, airspace, pickSupport);
        }
    }

    public OrderedRenderable createOrderedRenderable(DrawContext drawContext, Airspace airspace, double d, Object object) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (airspace == null) {
            String string = Logging.getMessage("nullValue.AirspaceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new OrderedAirspace(this, airspace, drawContext.getCurrentLayer(), d, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawOrderedAirspace(DrawContext drawContext, OrderedAirspace orderedAirspace, PickSupport pickSupport) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (orderedAirspace == null) {
            String string = Logging.getMessage("nullValue.OrderedAirspace");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.beginRendering(drawContext);
        try {
            this.drawAirspace(drawContext, orderedAirspace.getAirspace(), orderedAirspace.getPickedObject(), pickSupport);
            this.drawOrderedAirspaces(drawContext, pickSupport);
        }
        finally {
            this.endRendering(drawContext);
        }
    }

    protected void drawOrderedAirspaces(DrawContext drawContext, PickSupport pickSupport) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isEnableBatchRendering()) {
            return;
        }
        if (drawContext.isPickingMode() && !this.isEnableBatchPicking()) {
            return;
        }
        OrderedRenderable orderedRenderable = drawContext.peekOrderedRenderables();
        while (orderedRenderable != null && orderedRenderable instanceof OrderedAirspace) {
            OrderedAirspace orderedAirspace = (OrderedAirspace)orderedRenderable;
            if (this != orderedAirspace.getRenderer()) {
                return;
            }
            this.drawAirspace(drawContext, orderedAirspace.getAirspace(), orderedAirspace.getPickedObject(), pickSupport);
            drawContext.pollOrderedRenderables();
            orderedRenderable = drawContext.peekOrderedRenderables();
        }
    }

    protected void drawAirspace(DrawContext drawContext, Airspace airspace, PickSupport pickSupport) {
        this.drawAirspace(drawContext, airspace, airspace, pickSupport);
    }

    protected void drawAirspace(DrawContext drawContext, Airspace airspace, Object object, PickSupport pickSupport) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (airspace == null) {
            String string = Logging.getMessage("nullValue.AirspaceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            if (pickSupport != null) {
                this.bindPickableObject(drawContext, object, pickSupport);
            }
            this.doDrawAirspace(drawContext, airspace);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionWhileRenderingAirspace");
            Logging.logger().log(Level.SEVERE, string, exception);
        }
    }

    protected void doDrawAirspace(DrawContext drawContext, Airspace airspace) {
        drawContext.drawOutlinedShape(this.outlineShapeRenderer, airspace);
        if (!drawContext.isPickingMode() && this.isDrawExtents()) {
            airspace.renderExtent(drawContext);
        }
    }

    protected void drawAirspaceInterior(DrawContext drawContext, Airspace airspace) {
        if (!drawContext.isPickingMode()) {
            airspace.getAttributes().applyInterior(drawContext, this.isEnableLighting());
        }
        airspace.renderGeometry(drawContext, "Airspace.DrawStyleFill");
    }

    protected void drawAirspaceOutline(DrawContext drawContext, Airspace airspace) {
        int[] nArray = new int[1];
        if (drawContext.isPickingMode()) {
            double d = airspace.getAttributes().getOutlineWidth();
            if (!airspace.getAttributes().isDrawInterior() && d != 0.0) {
                d += this.getLinePickWidth();
            }
            drawContext.getGL().glLineWidth((float)d);
        } else {
            if (this.isEnableLighting()) {
                drawContext.getGL().glGetIntegerv(2896, nArray, 0);
                if (nArray[0] == 1) {
                    drawContext.getGL().glDisable(2896);
                }
            }
            airspace.getAttributes().applyOutline(drawContext, false);
        }
        airspace.renderGeometry(drawContext, "Airspace.DrawStyleOutline");
        if (!drawContext.isPickingMode() && this.isEnableLighting() && nArray[0] == 1) {
            drawContext.getGL().glEnable(2896);
        }
    }

    protected void beginRendering(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glEnableClientState(32884);
        if (!drawContext.isPickingMode()) {
            int n = 20493;
            gL2.glPushAttrib(n);
            if (this.isDrawWireframe()) {
                gL2.glPolygonMode(1032, 6913);
            }
            if (this.isEnableBlending()) {
                this.setBlending(drawContext);
            }
            if (this.isEnableLighting()) {
                gL2.glEnableClientState(32885);
                drawContext.beginStandardLighting();
            }
            if (this.isEnableAntialiasing()) {
                gL2.glEnable(2848);
            }
        } else {
            int n = 5;
            gL2.glPushAttrib(n);
        }
    }

    protected void endRendering(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glDisableClientState(32884);
        if (!drawContext.isPickingMode() && this.isEnableLighting()) {
            gL2.glDisableClientState(32885);
            drawContext.endStandardLighting();
        }
        gL2.glPopAttrib();
    }

    protected void bindPickableObject(DrawContext drawContext, Object object, PickSupport pickSupport) {
        Color color = drawContext.getUniquePickColor();
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
        if (object instanceof Locatable) {
            pickSupport.addPickableObject(color.getRGB(), object, ((Locatable)object).getPosition());
        } else {
            pickSupport.addPickableObject(color.getRGB(), object);
        }
    }

    public void drawGeometry(DrawContext drawContext, int n, int n2, int n3, Buffer buffer, Geometry geometry) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (buffer == null) {
            String string = "nullValue.ElementBufferIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (geometry == null) {
            String string = "nullValue.AirspaceGeometryIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (geometry.getBuffer(2) == null) {
            String string = "nullValue.VertexBufferIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        int n4 = geometry.getSize(2);
        int n5 = geometry.getGLType(2);
        int n6 = geometry.getStride(2);
        Buffer buffer2 = geometry.getBuffer(2);
        gL2.glVertexPointer(n4, n5, n6, buffer2);
        Buffer buffer3 = null;
        if (!drawContext.isPickingMode() && this.isEnableLighting()) {
            buffer3 = geometry.getBuffer(3);
            if (buffer3 == null) {
                gL2.glDisableClientState(32885);
            } else {
                n5 = geometry.getGLType(3);
                n6 = geometry.getStride(3);
                gL2.glNormalPointer(n5, n6, buffer3);
            }
        }
        int n7 = 0;
        int n8 = geometry.getCount(2) - 1;
        gL2.glDrawRangeElements(n, n7, n8, n2, n3, buffer);
        if (!drawContext.isPickingMode()) {
            if (this.isEnableLighting() && buffer3 == null) {
                gL2.glEnableClientState(32885);
            }
            this.logGeometryStatistics(drawContext, geometry);
        }
    }

    public void drawGeometry(DrawContext drawContext, Geometry geometry) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (geometry == null) {
            String string = "nullValue.AirspaceGeometryIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (geometry.getBuffer(1) == null) {
            String string = "nullValue.ElementBufferIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = geometry.getMode(1);
        int n2 = geometry.getCount(1);
        int n3 = geometry.getGLType(1);
        Buffer buffer = geometry.getBuffer(1);
        this.drawGeometry(drawContext, n, n2, n3, buffer, geometry);
    }

    public void drawGeometry(DrawContext drawContext, Geometry geometry, Geometry geometry2) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (geometry == null) {
            String string = "nullValue.ElementGeometryIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (geometry.getBuffer(1) == null) {
            String string = "nullValue.ElementBufferIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null) {
            String string = "nullValue.VertexGeometryIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = geometry.getMode(1);
        int n2 = geometry.getCount(1);
        int n3 = geometry.getGLType(1);
        Buffer buffer = geometry.getBuffer(1);
        this.drawGeometry(drawContext, n, n2, n3, buffer, geometry2);
    }

    public void setBlending(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (drawContext.getGL() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        if (this.isUseEXTBlendFuncSeparate()) {
            this.setHaveEXTBlendFuncSeparate(gL2.isExtensionAvailable(EXT_BLEND_FUNC_SEPARATE_STRING));
        }
        gL2.glEnable(3008);
        gL2.glAlphaFunc(516, 0.0f);
        gL2.glEnable(3042);
        if (this.isUseEXTBlendFuncSeparate() && this.isHaveEXTBlendFuncSeparate()) {
            gL2.glBlendFuncSeparate(770, 771, 1, 771);
        } else {
            gL2.glBlendFunc(770, 771);
        }
    }

    protected void logGeometryStatistics(DrawContext drawContext, Geometry geometry) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (geometry == null) {
            String string = Logging.getMessage("nullValue.GeometryIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = 0;
        int n2 = 0;
        Iterator<PerformanceStatistic> iterator = drawContext.getPerFrameStatistics().iterator();
        while (iterator.hasNext()) {
            PerformanceStatistic performanceStatistic = iterator.next();
            if ("gov.nasa.worldwind.perfstat.AirspaceGeometryCount".equals(performanceStatistic.getKey())) {
                n += ((Integer)performanceStatistic.getValue()).intValue();
                iterator.remove();
            }
            if (!"gov.nasa.worldwind.perfstat.AirspaceVertexCount".equals(performanceStatistic.getKey())) continue;
            n2 += ((Integer)performanceStatistic.getValue()).intValue();
            iterator.remove();
        }
        drawContext.setPerFrameStatistic("gov.nasa.worldwind.perfstat.AirspaceGeometryCount", "Airspace Geometry Count", ++n);
        drawContext.setPerFrameStatistic("gov.nasa.worldwind.perfstat.AirspaceVertexCount", "Airspace Vertex Count", n2 += geometry.getCount(2));
    }

    protected static class OrderedAirspace
    implements OrderedRenderable {
        protected AirspaceRenderer renderer;
        protected Airspace airspace;
        protected Layer layer;
        protected double eyeDistance;
        protected Object pickedObject;

        public OrderedAirspace(AirspaceRenderer airspaceRenderer, Airspace airspace, Layer layer, double d, Object object) {
            if (airspaceRenderer == null) {
                String string = Logging.getMessage("nullValue.RendererIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (airspace == null) {
                String string = Logging.getMessage("nullValue.AirspaceIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.renderer = airspaceRenderer;
            this.airspace = airspace;
            this.layer = layer;
            this.eyeDistance = d;
            this.pickedObject = object;
        }

        public AirspaceRenderer getRenderer() {
            return this.renderer;
        }

        public Airspace getAirspace() {
            return this.airspace;
        }

        public Layer getLayer() {
            return this.layer;
        }

        @Override
        public double getDistanceFromEye() {
            return this.eyeDistance;
        }

        public Object getPickedObject() {
            return this.pickedObject;
        }

        @Override
        public void render(DrawContext drawContext) {
            if (drawContext == null) {
                String string = Logging.getMessage("nullValue.DrawContextIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.draw(drawContext, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pick(DrawContext drawContext, Point point) {
            if (drawContext == null) {
                String string = Logging.getMessage("nullValue.DrawContextIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            PickSupport pickSupport = this.getRenderer().getPickSupport();
            pickSupport.clearPickList();
            try {
                pickSupport.beginPicking(drawContext);
                this.draw(drawContext, pickSupport);
            }
            finally {
                pickSupport.endPicking(drawContext);
                pickSupport.resolvePick(drawContext, point, this.getLayer());
            }
        }

        protected void draw(DrawContext drawContext, PickSupport pickSupport) {
            AirspaceRenderer airspaceRenderer = this.getRenderer();
            airspaceRenderer.drawOrderedAirspace(drawContext, this, pickSupport);
        }
    }
}

